/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.DefaultModelUpdater;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.NlModelBuilder;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    public static final int DELAY_AFTER_TYPING_MS = 250;
    static final boolean CHECK_MODEL_INTEGRITY = false;
    private final Set<String> myPendingIds;
    @NotNull
    private final AndroidFacet myFacet;
    private final VirtualFile myFile;
    private final Configuration myConfiguration;
    private final ListenerCollection<ModelListener> myListeners;
    private String myModelDisplayName;
    @Nullable
    private NlComponent myRootComponent;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Set<Object> myActivations;
    private final ModelVersion myModelVersion;
    private final DesignerEditorFileType myType;
    private long myConfigurationModificationCount;
    private final MergingUpdateQueue myUpdateQueue;
    private ChangeType myModificationTrigger;
    private final BiFunction<Project, VirtualFile, XmlFile> myXmlFileProvider;
    @NotNull
    private final Consumer<NlComponent> myComponentRegistrar;
    @NotNull
    private final NlModelUpdaterInterface myModelUpdater;
    @NotNull
    private DataContext myDataContext;

    @NotNull
    public static NlModelBuilder builder(@NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration) {
        if (facet2 == null) {
            NlModel.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            NlModel.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(2);
        }
        return new NlModelBuilder(facet2, file2, configuration);
    }

    @Slow
    @NotNull
    static NlModel create(@Nullable Disposable parent, @Nullable String modelDisplayName, @NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull BiFunction<Project, VirtualFile, XmlFile> xmlFileProvider2, @Nullable NlModelUpdaterInterface modelUpdater, @NotNull DataContext dataContext) {
        if (facet2 == null) {
            NlModel.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            NlModel.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(5);
        }
        if (componentRegistrar2 == null) {
            NlModel.$$$reportNull$$$0(6);
        }
        if (xmlFileProvider2 == null) {
            NlModel.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            NlModel.$$$reportNull$$$0(8);
        }
        return new NlModel(parent, modelDisplayName, facet2, file2, configuration, componentRegistrar2, xmlFileProvider2, modelUpdater, dataContext);
    }

    protected NlModel(@Nullable Disposable parent, @Nullable String modelDisplayName, @NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull DataContext dataContext) {
        if (facet2 == null) {
            NlModel.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            NlModel.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(11);
        }
        if (componentRegistrar2 == null) {
            NlModel.$$$reportNull$$$0(12);
        }
        if (dataContext == null) {
            NlModel.$$$reportNull$$$0(13);
        }
        this(parent, modelDisplayName, facet2, file2, configuration, componentRegistrar2, NlModel::getDefaultXmlFile, null, dataContext);
    }

    @VisibleForTesting
    protected NlModel(@Nullable Disposable parent, @Nullable String modelDisplayName, @NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull BiFunction<Project, VirtualFile, XmlFile> xmlFileProvider2, @Nullable NlModelUpdaterInterface modelUpdater, @NotNull DataContext dataContext) {
        if (facet2 == null) {
            NlModel.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            NlModel.$$$reportNull$$$0(15);
        }
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(16);
        }
        if (componentRegistrar2 == null) {
            NlModel.$$$reportNull$$$0(17);
        }
        if (xmlFileProvider2 == null) {
            NlModel.$$$reportNull$$$0(18);
        }
        if (dataContext == null) {
            NlModel.$$$reportNull$$$0(19);
        }
        this.myPendingIds = new HashSet<String>();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myActivations = Collections.newSetFromMap(new WeakHashMap());
        this.myModelVersion = new ModelVersion();
        this.myFacet = facet2;
        this.myXmlFileProvider = xmlFileProvider2;
        this.myModelDisplayName = modelDisplayName;
        this.myFile = file2;
        this.myConfiguration = configuration;
        this.myComponentRegistrar = componentRegistrar2;
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myId = System.nanoTime() ^ (long)file2.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = DesignerEditorFileTypeKt.typeOf((PsiFile)this.getFile());
        this.myUpdateQueue = new MergingUpdateQueue("android.layout.preview.edit", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        this.myModelUpdater = modelUpdater == null ? new DefaultModelUpdater() : modelUpdater;
        this.myDataContext = dataContext;
    }

    @NotNull
    @VisibleForTesting
    public MergingUpdateQueue getUpdateQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myUpdateQueue;
        if (mergingUpdateQueue == null) {
            NlModel.$$$reportNull$$$0(20);
        }
        return mergingUpdateQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(@NotNull Object source) {
        boolean wasActive;
        if (source == null) {
            NlModel.$$$reportNull$$$0(21);
        }
        if (this.getFacet().isDisposed()) {
            return false;
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            wasActive = !this.myActivations.isEmpty();
            this.myActivations.add(source);
        }
        if (!wasActive) {
            if (this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                this.updateTheme();
            }
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
            manager.addListener(this, this.myFacet, this.myFile, this.myConfiguration);
            this.myListeners.forEach(listener2 -> listener2.modelActivated(this));
            return true;
        }
        return false;
    }

    public void updateTheme() {
        ResourceResolver resolver;
        ResourceUrl themeUrl = ResourceUrl.parse((String)this.myConfiguration.getTheme());
        if (themeUrl != null && themeUrl.type == ResourceType.STYLE && ((resolver = this.myConfiguration.getResourceResolver()) == null || resolver.getTheme(themeUrl.name, themeUrl.isFramework()) == null)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
    }

    private void deactivate() {
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
        manager.removeListener(this, this.myFacet, this.myFile, this.myConfiguration);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(@NotNull Object source) {
        boolean shouldDeactivate;
        if (source == null) {
            NlModel.$$$reportNull$$$0(22);
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            boolean removed = this.myActivations.remove(source);
            shouldDeactivate = removed && this.myActivations.isEmpty();
        }
        if (shouldDeactivate) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            NlModel.$$$reportNull$$$0(23);
        }
        return virtualFile;
    }

    @NotNull
    private static XmlFile getDefaultXmlFile(Project project, VirtualFile virtualFile) {
        XmlFile file2 = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile);
        XmlFile xmlFile = (XmlFile)Verify.verifyNotNull((Object)file2);
        if (xmlFile == null) {
            NlModel.$$$reportNull$$$0(24);
        }
        return xmlFile;
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile xmlFile = this.myXmlFileProvider.apply(this.getProject(), this.myFile);
        if (xmlFile == null) {
            NlModel.$$$reportNull$$$0(25);
        }
        return xmlFile;
    }

    @NotNull
    public DesignerEditorFileType getType() {
        DesignerEditorFileType designerEditorFileType = this.myType;
        if (designerEditorFileType == null) {
            NlModel.$$$reportNull$$$0(26);
        }
        return designerEditorFileType;
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model2) {
        this.myLintAnnotationsModel = model2;
    }

    @NotNull
    public Set<String> getPendingIds() {
        Set<String> set = this.myPendingIds;
        if (set == null) {
            NlModel.$$$reportNull$$$0(27);
        }
        return set;
    }

    public void syncWithPsi(@NotNull XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
        if (newRoot == null) {
            NlModel.$$$reportNull$$$0(28);
        }
        if (roots == null) {
            NlModel.$$$reportNull$$$0(29);
        }
        this.myModelUpdater.update(this, newRoot, roots);
    }

    protected void setRootComponent(NlComponent root2) {
        this.myRootComponent = root2;
    }

    public void checkStructure() {
    }

    private void checkUnique(NlComponent component, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component) {
    }

    public void addListener(@NotNull ModelListener listener2) {
        if (listener2 == null) {
            NlModel.$$$reportNull$$$0(30);
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ModelListener listener2) {
        if (listener2 == null) {
            NlModel.$$$reportNull$$$0(31);
        }
        this.myListeners.remove(listener2);
    }

    public void notifyListenersModelDerivedDataChanged() {
        this.myListeners.forEach(listener2 -> listener2.modelDerivedDataChanged(this));
    }

    public void notifyListenersModelChangedOnLayout(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelChangedOnLayout(this, animate));
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            NlModel.$$$reportNull$$$0(32);
        }
        return androidFacet;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myFacet.getModule();
        if (module2 == null) {
            NlModel.$$$reportNull$$$0(33);
        }
        return module2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            NlModel.$$$reportNull$$$0(34);
        }
        return project;
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(35);
        }
        return configuration;
    }

    @NotNull
    public ImmutableList<NlComponent> getComponents() {
        ImmutableList immutableList = this.myRootComponent != null ? ImmutableList.of((Object)this.myRootComponent) : ImmutableList.of();
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(36);
        }
        return immutableList;
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        Stream<NlComponent> stream = this.myRootComponent != null ? Stream.of(this.myRootComponent).flatMap(NlComponent::flatten) : Stream.empty();
        if (stream == null) {
            NlModel.$$$reportNull$$$0(37);
        }
        return stream;
    }

    public void notifyLiveUpdate(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelLiveUpdate(this, animate));
    }

    @NotNull
    public ImmutableList<NlComponent> findByOffset(int offset2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getFile(), (int)offset2, XmlTag.class, (boolean)false);
        ImmutableList<NlComponent> immutableList = tag != null ? this.findViewsByTag(tag) : ImmutableList.of();
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(38);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(39);
        }
        return this.myRootComponent != null ? this.myRootComponent.findViewByTag(tag) : null;
    }

    @Nullable
    public NlComponent find(@NotNull String id) {
        if (id == null) {
            NlModel.$$$reportNull$$$0(40);
        }
        return this.flattenComponents().filter(c -> id.equals(c.getId())).findFirst().orElse(null);
    }

    @Nullable
    public NlComponent find(@NotNull Predicate<NlComponent> condition) {
        if (condition == null) {
            NlModel.$$$reportNull$$$0(41);
        }
        return this.flattenComponents().filter(condition).findFirst().orElse(null);
    }

    @NotNull
    private ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(42);
        }
        if (this.myRootComponent == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                NlModel.$$$reportNull$$$0(43);
            }
            return immutableList;
        }
        ImmutableList<NlComponent> immutableList = this.myRootComponent.findViewsByTag(tag);
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(44);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element2) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element2 != null) {
            if (element2 instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element2);
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @Nullable
    public ResourceReference findAttributeByPsi(@NotNull PsiElement element2) {
        if (element2 == null) {
            NlModel.$$$reportNull$$$0(45);
        }
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element2 != null) {
            if (element2 instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)element2;
                ResourceNamespace namespace = IdeResourcesUtil.resolveResourceNamespace((XmlElement)attribute, attribute.getNamespacePrefix());
                if (namespace == null) {
                    return null;
                }
                return ResourceReference.attr((ResourceNamespace)namespace, (String)attribute.getLocalName());
            }
            element2 = element2.getParent();
        }
        return null;
    }

    public void delete(Collection<NlComponent> components) {
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Delete Component", null, () -> NlModel.handleDeletion(components), (PsiFile[])new PsiFile[]{this.getFile()});
        this.notifyModified(ChangeType.DELETE);
    }

    private static void handleDeletion(@NotNull Collection<NlComponent> components) {
        if (components == null) {
            NlModel.$$$reportNull$$$0(46);
        }
        Multimap<NlComponent, NlComponent> siblingLists = NlComponentUtil.groupSiblings(components);
        for (NlComponent parent : siblingLists.keySet()) {
            if (parent == null) continue;
            Collection children = siblingLists.get((Object)parent);
            if (parent.getMixin().maybeHandleDeletion(children)) continue;
            for (NlComponent component : children) {
                XmlTag tag;
                NlComponent p = component.getParent();
                if (p != null) {
                    p.removeChild(component);
                }
                if (!(tag = component.getTagDeprecated()).isValid()) continue;
                PsiElement parentTag = tag.getParent();
                tag.delete();
                if (!(parentTag instanceof XmlTag)) continue;
                ((XmlTag)parentTag).collapseIfEmpty();
            }
        }
    }

    @Nullable
    public NlComponent createComponent(@Nullable DesignSurface surface2, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(47);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(48);
        }
        XmlTag addedTag = tag;
        if (parent != null) {
            XmlTag parentTag = parent.getTagDeprecated();
            addedTag = (XmlTag)WriteAction.compute(() -> {
                if (before != null) {
                    return (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTagDeprecated());
                }
                return parentTag.addSubTag(tag, false);
            });
        }
        NlComponent child = this.createComponent(addedTag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        if (child.postCreate(surface2, insertType)) {
            return child;
        }
        return null;
    }

    @NotNull
    public NlComponent createComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(49);
        }
        NlComponent component = new NlComponent(this, tag);
        this.myComponentRegistrar.accept(component);
        NlComponent nlComponent = component;
        if (nlComponent == null) {
            NlModel.$$$reportNull$$$0(50);
        }
        return nlComponent;
    }

    @NotNull
    public List<NlComponent> createComponents(@NotNull DnDTransferItem item, @NotNull InsertType insertType, @NotNull DesignSurface surface2) {
        if (item == null) {
            NlModel.$$$reportNull$$$0(51);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(52);
        }
        if (surface2 == null) {
            NlModel.$$$reportNull$$$0(53);
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            XmlTag tag = XmlTagUtil.createTag(this.getProject(), dndComponent.getRepresentation());
            NlComponent component = this.createComponent(surface2, tag, null, null, insertType);
            if (component == null) {
                List<NlComponent> list = Collections.emptyList();
                if (list == null) {
                    NlModel.$$$reportNull$$$0(54);
                }
                return list;
            }
            component.postCreateFromTransferrable(dndComponent);
            components.add(component);
        }
        ArrayList<NlComponent> arrayList = components;
        if (arrayList == null) {
            NlModel.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(56);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(57);
        }
        return this.canAddComponents(toAdd, receiver, before, false);
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, boolean ignoreMissingDependencies) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(58);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(59);
        }
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd.isEmpty()) {
            return false;
        }
        if (toAdd.stream().anyMatch(c -> !c.canAddTo(receiver))) {
            return false;
        }
        if (NlComponentUtil.isDescendant(receiver, toAdd)) {
            return false;
        }
        return ignoreMissingDependencies || this.checkIfUserWantsToAddDependencies(toAdd);
    }

    private boolean checkIfUserWantsToAddDependencies(List<NlComponent> toAdd) {
        return NlDependencyManager.getInstance().checkIfUserWantsToAddDependencies(toAdd, this.getFacet());
    }

    public void addComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(60);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(61);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(62);
        }
        this.addComponents(toAdd, receiver, before, insertType, surface2, null);
    }

    public void addComponents(@NotNull List<NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2, @Nullable Runnable attributeUpdatingTask) {
        if (componentToAdd == null) {
            NlModel.$$$reportNull$$$0(63);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(64);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(65);
        }
        this.addComponents(componentToAdd, receiver, before, insertType, surface2, attributeUpdatingTask, null);
    }

    public void addComponents(@NotNull List<NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2, @Nullable Runnable attributeUpdatingTask, @Nullable String groupId) {
        ImmutableList toAdd;
        if (componentToAdd == null) {
            NlModel.$$$reportNull$$$0(66);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(67);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(68);
        }
        if (!this.canAddComponents((List<NlComponent>)(toAdd = ImmutableList.copyOf(componentToAdd)), receiver, before, insertType == InsertType.MOVE_WITHIN)) {
            return;
        }
        Runnable callback2 = () -> this.addComponentInWriteCommand((List<NlComponent>)toAdd, receiver, before, insertType, surface2, attributeUpdatingTask, groupId);
        if (insertType != InsertType.MOVE_WITHIN) {
            NlDependencyManager.getInstance().addDependenciesAsync((Iterable<? extends NlComponent>)toAdd, this.getFacet(), "Adding Components...", callback2);
        } else {
            callback2.run();
        }
    }

    private void addComponentInWriteCommand(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2, @Nullable Runnable attributeUpdatingTask, @Nullable String groupId) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(69);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(70);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(71);
        }
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
            NlWriteCommandActionUtil.run(toAdd, NlModel.generateAddComponentsDescription(toAdd, insertType), groupId, () -> {
                if (attributeUpdatingTask != null) {
                    attributeUpdatingTask.run();
                }
                this.handleAddition(toAdd, receiver, before, insertType, surface2);
            });
            this.notifyModified(ChangeType.ADD_COMPONENTS);
            if (insertType == InsertType.CREATE && surface2 != null) {
                surface2.getSelectionModel().setSelection(toAdd);
            }
        });
    }

    @NotNull
    private static String generateAddComponentsDescription(@NotNull List<NlComponent> toAdd, @NotNull InsertType insertType) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(72);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(73);
        }
        DragType dragType = insertType.getDragType();
        String componentType = "";
        if (toAdd.size() == 1) {
            String tagName = toAdd.get(0).getTagName();
            componentType = tagName.substring(tagName.lastIndexOf(46) + 1);
        }
        String string = dragType.getDescription(componentType);
        if (string == null) {
            NlModel.$$$reportNull$$$0(74);
        }
        return string;
    }

    public void addTags(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (added == null) {
            NlModel.$$$reportNull$$$0(75);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(76);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(77);
        }
        NlWriteCommandActionUtil.run(added, NlModel.generateAddComponentsDescription(added, insertType), () -> {
            for (NlComponent component : added) {
                component.addTags(receiver, before, insertType);
            }
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    @NotNull
    public Set<String> getIds() {
        LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(this.getFacet());
        HashSet<String> ids2 = new HashSet<String>(resources.getResources(ResourceNamespace.TODO(), ResourceType.ID).keySet());
        Set<String> pendingIds = this.getPendingIds();
        if (!pendingIds.isEmpty()) {
            HashSet<String> all = new HashSet<String>(pendingIds.size() + ids2.size());
            all.addAll(ids2);
            all.addAll(pendingIds);
            ids2 = all;
        }
        HashSet<String> hashSet = ids2;
        if (hashSet == null) {
            NlModel.$$$reportNull$$$0(78);
        }
        return hashSet;
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2) {
        if (added == null) {
            NlModel.$$$reportNull$$$0(79);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(80);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(81);
        }
        Set<String> ids2 = this.getIds();
        for (NlComponent component : added) {
            component.moveTo(receiver, before, insertType, ids2, surface2);
        }
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (dragType == null) {
            NlModel.$$$reportNull$$$0(82);
        }
        if (item != null && item.isFromPalette()) {
            InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(83);
            }
            return insertType;
        }
        switch (dragType) {
            case CREATE: {
                InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(84);
                }
                return insertType;
            }
            case MOVE: {
                InsertType insertType = item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(85);
                }
                return insertType;
            }
            case COPY: {
                InsertType insertType = InsertType.COPY;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(86);
                }
                return insertType;
            }
        }
        InsertType insertType = InsertType.PASTE;
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(87);
        }
        return insertType;
    }

    public long getId() {
        return this.myId;
    }

    public void setModelDisplayName(@Nullable String name) {
        this.myModelDisplayName = name;
    }

    @Nullable
    public String getModelDisplayName() {
        return this.myModelDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean shouldDeactivate;
        this.myLintAnnotationsModel = null;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            shouldDeactivate = !this.myActivations.isEmpty();
            this.myActivations.clear();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
        this.myListeners.clear();
    }

    @NotNull
    public String toString() {
        String string = NlModel.class.getSimpleName() + " for " + this.myFile;
        if (string == null) {
            NlModel.$$$reportNull$$$0(88);
        }
        return string;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        if (reason == null) {
            NlModel.$$$reportNull$$$0(89);
        }
        for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModifiedViaUpdateQueue(ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.notifyModifiedViaUpdateQueue(ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection<Configuration>)ImmutableList.of((Object)this.getConfiguration()));
                    this.notifyModified(ChangeType.RESOURCE_CHANGED);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection<Configuration>)ImmutableList.of((Object)this.getConfiguration()));
                    this.notifyModified(ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.notifyModified(ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getConfigurationModificationCount() {
        return this.myConfigurationModificationCount;
    }

    public void notifyModified(@NotNull ChangeType reason) {
        if (reason == null) {
            NlModel.$$$reportNull$$$0(90);
        }
        this.myModelVersion.increase(reason);
        this.updateTheme();
        this.myModificationTrigger = reason;
        this.myListeners.forEach(listener2 -> listener2.modelChanged(this));
    }

    public void notifyModifiedViaUpdateQueue(final @NotNull ChangeType reason) {
        if (reason == null) {
            NlModel.$$$reportNull$$$0(91);
        }
        this.myUpdateQueue.queue(new Update("edit"){

            public void run() {
                NlModel.this.notifyModified(reason);
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    @Nullable
    public ChangeType getLastChangeType() {
        return this.myModificationTrigger;
    }

    public void resetLastChange() {
        this.myModificationTrigger = null;
    }

    @NotNull
    public final DataContext getDataContext() {
        DataContext dataContext = this.myDataContext;
        if (dataContext == null) {
            NlModel.$$$reportNull$$$0(92);
        }
        return dataContext;
    }

    public final void setDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlModel.$$$reportNull$$$0(93);
        }
        this.myDataContext = dataContext;
    }

    private /* synthetic */ void lambda$checkStructure$1() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.getFile().getRootTag(), uniqueTags);
        uniqueTags.clear();
        if (this.myRootComponent != null) {
            this.checkUnique(this.myRootComponent.getTagDeprecated(), uniqueTags);
            this.checkUnique(this.myRootComponent, unique);
            this.checkStructure(this.myRootComponent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 50: 
            case 54: 
            case 55: 
            case 74: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 50: 
            case 54: 
            case 55: 
            case 74: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentRegistrar";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFileProvider";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 50: 
            case 54: 
            case 55: 
            case 74: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlModel";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 39: 
            case 42: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 48: 
            case 52: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 56: 
            case 58: 
            case 60: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 70: 
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentToAdd";
                break;
            }
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragType";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateQueue";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultXmlFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingIds";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenComponents";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findByOffset";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAddComponentsDescription";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getIds";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "determineInsertType";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 50: 
            case 54: 
            case 55: 
            case 74: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "syncWithPsi";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeByPsi";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "handleDeletion";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createComponents";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "canAddComponents";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addComponents";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addComponentInWriteCommand";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "generateAddComponentsDescription";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "handleAddition";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "determineInsertType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "resourcesChanged";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "notifyModified";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "notifyModifiedViaUpdateQueue";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "setDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 50: 
            case 54: 
            case 55: 
            case 74: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
        }

        public long getVersion() {
            return this.myVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        UPDATE_HIERARCHY,
        BUILD,
        CONFIGURATION_CHANGE;

    }

    public static interface TagSnapshotTreeNode {
        @Nullable
        public TagSnapshot getTagSnapshot();

        @NotNull
        public List<TagSnapshotTreeNode> getChildren();
    }

    public static interface NlModelUpdaterInterface {
        public void update(@NotNull NlModel var1, @Nullable XmlTag var2, @NotNull List<TagSnapshotTreeNode> var3);
    }
}

