/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import android.view.View;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.model.LayoutParamsManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesTransaction
implements NlAttributesHolder {
    private final NlComponent myComponent;
    private final ReentrantReadWriteLock myLock;
    private final HashMap<String, PendingAttribute> myPendingAttributes;
    private final HashMap<String, String> myOriginalValues;
    private final NlModel myModel;
    private boolean isValid;
    private boolean isSuccessful;
    private boolean hasPendingRelayout;
    private boolean hasLayoutAttributeChanged;

    public AttributesTransaction(@NotNull NlComponent thisComponent) {
        if (thisComponent == null) {
            AttributesTransaction.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myPendingAttributes = new HashMap();
        this.isValid = true;
        this.isSuccessful = false;
        this.hasLayoutAttributeChanged = false;
        this.myComponent = thisComponent;
        this.myModel = this.myComponent.getModel();
        List<AttributeSnapshot> attributes = this.myComponent.getAttributes();
        this.myOriginalValues = Maps.newHashMapWithExpectedSize((int)attributes.size());
        attributes.stream().forEach(attribute -> this.myOriginalValues.put(AttributesTransaction.attributeKey(attribute.namespace, attribute.name), attribute.value));
    }

    public void applyToModification(ComponentModification modification) {
        for (PendingAttribute attribute : this.myPendingAttributes.values()) {
            modification.setAttribute(attribute.namespace, attribute.name, attribute.value);
        }
    }

    @NotNull
    private static String attributeKey(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            AttributesTransaction.$$$reportNull$$$0(1);
        }
        String string = namespace + ":" + attribute;
        if (string == null) {
            AttributesTransaction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void applyAttributeToView(@NotNull PendingAttribute attribute, @NotNull ViewInfo viewInfo, NlModel model2) {
        if (attribute == null) {
            AttributesTransaction.$$$reportNull$$$0(3);
        }
        if (viewInfo == null) {
            AttributesTransaction.$$$reportNull$$$0(4);
        }
        if (attribute.name.startsWith("layout_")) {
            String value2 = attribute.value;
            Object layoutParams = viewInfo.getLayoutParamsObject();
            Object viewObject = viewInfo.getViewObject();
            if (viewObject == null || layoutParams == null) {
                return;
            }
            boolean changed = LayoutParamsManager.setAttribute(layoutParams, StringUtil.trimStart((String)attribute.name, (String)"layout_"), value2, model2.getModule(), model2.getConfiguration());
            this.hasPendingRelayout |= changed;
        }
    }

    private static void triggerViewRelayout(@NotNull View view) {
        if (view == null) {
            AttributesTransaction.$$$reportNull$$$0(5);
        }
        try {
            RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                view.setLayoutParams(view.getLayoutParams());
                view.forceLayout();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void applyAllPendingAttributesToView(@NotNull ViewInfo viewInfo) {
        View viewObject;
        if (viewInfo == null) {
            AttributesTransaction.$$$reportNull$$$0(6);
        }
        if ((viewObject = (View)viewInfo.getViewObject()) != null) {
            this.myPendingAttributes.values().stream().filter(Objects::nonNull).forEach(pendingAttribute -> this.applyAttributeToView((PendingAttribute)pendingAttribute, viewInfo, this.myModel));
            this.hasPendingRelayout = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value2) {
        if (name == null) {
            AttributesTransaction.$$$reportNull$$$0(7);
        }
        this.myLock.writeLock().lock();
        try {
            assert (this.isValid);
            String key = AttributesTransaction.attributeKey(namespace, name);
            PendingAttribute attribute = this.myPendingAttributes.get(key);
            if (attribute != null) {
                if (!StringUtil.equals((CharSequence)attribute.value, (CharSequence)value2)) {
                    attribute.value = value2;
                }
            } else {
                attribute = new PendingAttribute(namespace, name, value2);
                this.myPendingAttributes.put(key, attribute);
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            AttributesTransaction.$$$reportNull$$$0(8);
        }
        this.myLock.readLock().lock();
        try {
            assert (this.isValid);
            PendingAttribute pendingAttribute = this.myPendingAttributes.get(AttributesTransaction.attributeKey(namespace, attribute));
            if (pendingAttribute != null) {
                String string = pendingAttribute.value;
                return string;
            }
            String string = this.myComponent.getAttribute(namespace, attribute);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @NotNull
    public NlComponent getComponent() {
        NlComponent nlComponent = this.myComponent;
        if (nlComponent == null) {
            AttributesTransaction.$$$reportNull$$$0(9);
        }
        return nlComponent;
    }

    boolean finishTransaction() {
        assert (this.isValid);
        this.isValid = false;
        this.myComponent.myCurrentTransaction = null;
        boolean hadPendingChanges = !this.myPendingAttributes.isEmpty();
        this.myPendingAttributes.clear();
        this.myOriginalValues.clear();
        return hadPendingChanges;
    }

    public void apply() {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(this.myComponent);
        if (viewInfo != null) {
            this.applyAllPendingAttributesToView(viewInfo);
            if (this.hasPendingRelayout) {
                this.hasLayoutAttributeChanged = true;
                AttributesTransaction.triggerViewRelayout((View)viewInfo.getViewObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() {
        this.apply();
        this.myLock.writeLock().lock();
        try {
            assert (this.isValid);
            if (!this.myComponent.getBackend().isValid()) {
                boolean bl = this.finishTransaction();
                return bl;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                boolean bl = (Boolean)ApplicationManager.getApplication().runWriteAction(this::commit);
                return bl;
            }
            boolean modified = false;
            for (PendingAttribute attribute : this.myPendingAttributes.values()) {
                String originalValue = this.myOriginalValues.get(AttributesTransaction.attributeKey(attribute.namespace, attribute.name));
                String currentValue = this.myComponent.getAttribute(attribute.namespace, attribute.name);
                if (StringUtil.equals((CharSequence)currentValue, (CharSequence)attribute.value) || !StringUtil.equals((CharSequence)originalValue, (CharSequence)currentValue) && (StringUtil.isEmpty((String)attribute.value) || StringUtil.equals((CharSequence)originalValue, (CharSequence)attribute.value))) continue;
                modified = true;
                this.myComponent.setAttribute(attribute.namespace, attribute.name, attribute.value);
            }
            this.isSuccessful = true;
            this.finishTransaction();
            boolean bl = modified;
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public boolean isComplete() {
        return !this.isValid;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public boolean rollback() {
        this.myLock.writeLock().lock();
        try {
            if (this.hasLayoutAttributeChanged) {
                this.myModel.notifyModified(NlModel.ChangeType.DND_END);
            }
            boolean bl = this.finishTransaction();
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisComponent";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/AttributesTransaction";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/AttributesTransaction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "attributeKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "attributeKey";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyAttributeToView";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "triggerViewRelayout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyAllPendingAttributesToView";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PendingAttribute {
        final String namespace;
        final String name;
        String value;

        private PendingAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value2) {
            if (name == null) {
                PendingAttribute.$$$reportNull$$$0(0);
            }
            this.namespace = namespace;
            this.name = name;
            this.value = value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/common/model/AttributesTransaction$PendingAttribute", "<init>"));
        }
    }
}

