/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintExternalAnnotator;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class LintHighlightingPass
implements HighlightingPass {
    private final WeakReference<DesignSurface> mySurfaceRef;
    private LintAnnotationsModel myLintAnnotationsModel;

    public LintHighlightingPass(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            LintHighlightingPass.$$$reportNull$$$0(0);
        }
        this.mySurfaceRef = new WeakReference<DesignSurface>(surface2);
    }

    public void collectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            LintHighlightingPass.$$$reportNull$$$0(1);
        }
        this.myLintAnnotationsModel = null;
        DesignSurface surface2 = (DesignSurface)((Object)this.mySurfaceRef.get());
        if (surface2 == null) {
            return;
        }
        SceneView sceneView = surface2.getFocusedSceneView();
        if (sceneView == null) {
            return;
        }
        this.myLintAnnotationsModel = LintHighlightingPass.getAnnotations(sceneView.getModel(), progress);
    }

    public void applyInformationToEditor() {
        DesignSurface surface2 = (DesignSurface)((Object)this.mySurfaceRef.get());
        if (surface2 == null) {
            return;
        }
        SceneView sceneView = surface2.getFocusedSceneView();
        if (sceneView == null || this.myLintAnnotationsModel == null) {
            return;
        }
        sceneView.getModel().setLintAnnotationsModel(this.myLintAnnotationsModel);
        surface2.setLintAnnotationsModel(this.myLintAnnotationsModel);
        sceneView.getSurface().repaint();
    }

    @NotNull
    private static LintAnnotationsModel getAnnotations(@NotNull NlModel model2, @NotNull ProgressIndicator progress) {
        if (model2 == null) {
            LintHighlightingPass.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            LintHighlightingPass.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LintAnnotationsModel lintModel = new LintAnnotationsModel();
        XmlFile xmlFile = model2.getFile();
        LintExternalAnnotator annotator = new LintExternalAnnotator();
        LintEditorResult lintResult = annotator.collectInformation((PsiFile)xmlFile);
        if (lintResult != null) {
            lintResult = annotator.doAnnotate(lintResult);
        }
        if (lintResult == null) {
            LintAnnotationsModel lintAnnotationsModel = lintModel;
            if (lintAnnotationsModel == null) {
                LintHighlightingPass.$$$reportNull$$$0(4);
            }
            return lintAnnotationsModel;
        }
        for (LintProblemData problemData : lintResult.getProblems()) {
            AndroidLintInspectionBase inspection;
            NlComponent component;
            if (progress.isCanceled()) break;
            TextRange range = problemData.getTextRange();
            PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
            PsiElement endElement = xmlFile.findElementAt(range.getEndOffset());
            if (startElement == null || endElement == null || (component = model2.findViewByPsi(startElement)) == null) continue;
            ResourceReference attribute = model2.findAttributeByPsi(startElement);
            AttributeKey attributeKey = attribute != null ? new AttributeKey(component, attribute.getNamespace().getXmlNamespaceUri(), attribute.getName()) : null;
            Issue issue2 = problemData.getIssue();
            Pair pair = LintExternalAnnotator.getHighlightLevelAndInspection((Project)xmlFile.getProject(), (Issue)issue2, (PsiElement)xmlFile);
            if (pair == null || (inspection = (AndroidLintInspectionBase)pair.getFirst()) == null) continue;
            HighlightDisplayLevel level = (HighlightDisplayLevel)pair.getSecond();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
            if (key == null) continue;
            lintModel.addIssue(component, attributeKey, issue2, problemData.getMessage(), inspection, level, startElement, endElement, problemData.getQuickfixData());
        }
        LintAnnotationsModel lintAnnotationsModel = lintModel;
        if (lintAnnotationsModel == null) {
            LintHighlightingPass.$$$reportNull$$$0(5);
        }
        return lintAnnotationsModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/lint/LintHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/lint/LintHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

