/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintAnnotationsModel {
    private ListMultimap<NlComponent, IssueData> myIssues = ImmutableListMultimap.of();
    private ListMultimap<AttributeKey, IssueData> myAttributeIssues = ImmutableListMultimap.of();
    private List<IssueData> myIssueList = Collections.emptyList();

    @Nullable
    public String getIssueMessage(@NotNull NlComponent component) {
        if (component == null) {
            LintAnnotationsModel.$$$reportNull$$$0(0);
        }
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        return LintAnnotationsModel.findHighestSeverityIssue((List<IssueData>)issueData).message;
    }

    @Nullable
    public IssueData findIssue(@NotNull NlComponent component, @NotNull String namespace, @NotNull String attributeName) {
        if (component == null) {
            LintAnnotationsModel.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            LintAnnotationsModel.$$$reportNull$$$0(2);
        }
        if (attributeName == null) {
            LintAnnotationsModel.$$$reportNull$$$0(3);
        }
        if (this.myAttributeIssues == null) {
            return null;
        }
        AttributeKey attributeKey = new AttributeKey(component, namespace, attributeName);
        List issueData = this.myAttributeIssues.get((Object)attributeKey);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        return LintAnnotationsModel.findHighestSeverityIssue(issueData);
    }

    private static IssueData findHighestSeverityIssue(List<IssueData> issueData) {
        return Collections.max(issueData);
    }

    public void addIssue(@NotNull NlComponent component, @Nullable AttributeKey attribute, @NotNull Issue issue2, @NotNull String message2, @NotNull AndroidLintInspectionBase inspection, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @Nullable LintFix quickfixData) {
        if (component == null) {
            LintAnnotationsModel.$$$reportNull$$$0(4);
        }
        if (issue2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(5);
        }
        if (message2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(6);
        }
        if (inspection == null) {
            LintAnnotationsModel.$$$reportNull$$$0(7);
        }
        if (level == null) {
            LintAnnotationsModel.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            LintAnnotationsModel.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            LintAnnotationsModel.$$$reportNull$$$0(10);
        }
        if (issue2 == RtlDetector.COMPAT) {
            return;
        }
        if (this.myIssues.isEmpty()) {
            this.myIssues = ArrayListMultimap.create();
            this.myAttributeIssues = ArrayListMultimap.create();
            this.myIssueList = new ArrayList<IssueData>();
        }
        IssueData data = new IssueData(component, attribute, inspection, issue2, message2, level, startElement, endElement, quickfixData);
        this.myIssues.put((Object)component, (Object)data);
        this.myIssueList.add(data);
        if (attribute != null) {
            this.myAttributeIssues.put((Object)attribute, (Object)data);
        }
    }

    public int getIssueCount() {
        return this.myIssueList == null ? 0 : this.myIssueList.size();
    }

    @NotNull
    public List<IssueData> getIssues() {
        List<IssueData> list = this.myIssueList != null ? this.myIssueList : Collections.emptyList();
        if (list == null) {
            LintAnnotationsModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/lint/LintAnnotationsModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/lint/LintAnnotationsModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIssueMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIssue";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addIssue";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IssueData
    implements Comparable<IssueData> {
        @NotNull
        public final AndroidLintInspectionBase inspection;
        @NotNull
        public final HighlightDisplayLevel level;
        @NotNull
        public final String message;
        @NotNull
        public final Issue issue;
        @NotNull
        public final PsiElement endElement;
        @NotNull
        public final PsiElement startElement;
        @NotNull
        public final NlComponent component;
        @NotNull
        public final IssueSource issueSource;
        @Nullable
        public final AttributeKey attribute;
        @Nullable
        public final LintFix quickfixData;

        private IssueData(@NotNull NlComponent component, @Nullable AttributeKey attribute, @NotNull AndroidLintInspectionBase inspection, @NotNull Issue issue2, @NotNull String message2, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @Nullable LintFix quickfixData) {
            if (component == null) {
                IssueData.$$$reportNull$$$0(0);
            }
            if (inspection == null) {
                IssueData.$$$reportNull$$$0(1);
            }
            if (issue2 == null) {
                IssueData.$$$reportNull$$$0(2);
            }
            if (message2 == null) {
                IssueData.$$$reportNull$$$0(3);
            }
            if (level == null) {
                IssueData.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                IssueData.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                IssueData.$$$reportNull$$$0(6);
            }
            this.component = component;
            this.issueSource = IssueSource.fromNlComponent(component);
            this.attribute = attribute;
            this.inspection = inspection;
            this.issue = issue2;
            this.message = message2;
            this.level = level;
            this.startElement = startElement;
            this.endElement = endElement;
            this.quickfixData = quickfixData;
        }

        @Override
        public int compareTo(@NotNull IssueData o) {
            if (o == null) {
                IssueData.$$$reportNull$$$0(7);
            }
            return ComparisonChain.start().compare((Comparable)this.level.getSeverity(), (Comparable)o.level.getSeverity()).compare(this.issue.getPriority(), o.issue.getPriority()).compare((Comparable)o.issue.getDefaultSeverity(), (Comparable)this.issue.getDefaultSeverity()).result();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "issue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/lint/LintAnnotationsModel$IssueData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

