/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueView
extends JPanel {
    private static final int COLLAPSED_ROW_HEIGHT = 30;
    private static final String SUGGESTED_FIXES = "Suggested Fixes";
    private static final int BORDER_THICKNESS = 1;
    private static final JBColor SELECTED_BG_COLOR = new JBColor(0xF2F2F2, 2303013);
    private final IssuePanel myContainerIssuePanel;
    private RoundedLineBorder mySelectedBorder;
    private Border myUnselectedBorder;
    private JPanel myContent;
    private JBLabel myExpandIcon;
    private JLabel myErrorIcon;
    private JLabel mySourceLabel;
    private JTextPane myErrorDescription;
    private JBLabel myErrorTitle;
    private JPanel myFixPanel;
    private JPanel myDetailPanel;
    private JBLabel mySuggestedFixLabel;
    private boolean myIsExpanded;
    private final int myDisplayPriority;
    private boolean myInitialized;
    @NotNull
    private final String myErrorDescriptionContent;

    IssueView(@NotNull Issue issue2, @NotNull IssuePanel container) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(0);
        }
        if (container == null) {
            IssueView.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.mySelectedBorder = IdeBorderFactory.createRoundedBorder((int)JBUI.scale((int)1));
        this.myUnselectedBorder = JBUI.Borders.empty((int)1);
        this.addMouseListener(this.createMouseListener());
        this.myContainerIssuePanel = container;
        this.myDisplayPriority = IssueView.getDisplayPriority(issue2);
        this.mySelectedBorder.setColor(UIUtil.getTreeSelectionBorderColor());
        this.myErrorDescription.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.myErrorDescriptionContent = new HtmlBuilder().openHtmlBody().addHtml(issue2.getDescription()).closeHtmlBody().getHtml();
        this.setupHeader(issue2);
        this.setupDescriptionPanel(issue2);
        this.setupFixPanel(issue2);
        this.myInitialized = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setMaximumSize((Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)30));
        this.setBackground(UIUtil.getEditorPaneBackground());
        if (this.myInitialized) {
            this.mySelectedBorder = IdeBorderFactory.createRoundedBorder((int)JBUI.scale((int)1));
            this.mySelectedBorder.setColor(UIUtil.getTreeSelectionBorderColor());
            this.myUnselectedBorder = JBUI.Borders.empty((int)1);
            this.myErrorDescription.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.myErrorTitle.setFont(UIUtil.getLabelFont().deriveFont(1));
            this.mySuggestedFixLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
    }

    private void setupHeader(@NotNull Issue issue2) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(2);
        }
        this.myErrorIcon.setIcon(IssueView.getSeverityIcon(issue2.getSeverity()));
        this.myExpandIcon.setIcon(UIUtil.getTreeCollapsedIcon());
        this.myErrorTitle.setText(issue2.getSummary());
        String displayText = issue2.getSource().getDisplayText();
        if (displayText != "") {
            this.mySourceLabel.setText(displayText);
        }
    }

    private void setupFixPanel(@NotNull Issue issue2) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(3);
        }
        this.myFixPanel.setLayout(new BoxLayout(this.myFixPanel, 1));
        issue2.getFixes().forEach(this::createFixEntry);
        if (this.myFixPanel.getComponentCount() > 0) {
            this.myFixPanel.setVisible(true);
            this.mySuggestedFixLabel.setVisible(true);
            if (this.myFixPanel.getComponentCount() > 1) {
                this.mySuggestedFixLabel.setText(SUGGESTED_FIXES);
            }
        } else {
            this.myFixPanel.setVisible(false);
        }
    }

    private void setupDescriptionPanel(@NotNull Issue issue2) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(4);
        }
        this.myErrorDescription.setEditorKit(new IssueHTMLEditorKit());
        this.myErrorDescription.addHyperlinkListener(issue2.getHyperlinkListener());
        this.myErrorDescription.setFont(UIUtil.getToolTipFont());
        this.myErrorDescription.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueView.this.myContainerIssuePanel.setSelectedIssue(IssueView.this);
                IssueView.this.setFocused(true);
            }
        });
    }

    private static int getDisplayPriority(@NotNull Issue error) {
        if (error == null) {
            IssueView.$$$reportNull$$$0(5);
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            return 0;
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            return 1;
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.WEAK_WARNING)) {
            return 2;
        }
        return 3;
    }

    int getDisplayPriority() {
        return this.myDisplayPriority;
    }

    private void createFixEntry(@NotNull Issue.Fix fix) {
        if (fix == null) {
            IssueView.$$$reportNull$$$0(6);
        }
        this.myFixPanel.add(new FixEntry(fix.getDescription(), fix.getRunnable()));
    }

    @NotNull
    private MouseAdapter createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueView.this.myContainerIssuePanel.requestFocusInWindow();
                if (e.getClickCount() == 1) {
                    IssueView.this.myContainerIssuePanel.setSelectedIssue(IssueView.this);
                    IssueView.this.setFocused(true);
                }
                if (e.getX() > IssueView.this.myExpandIcon.getX() - 3 && e.getX() < IssueView.this.myExpandIcon.getX() + IssueView.this.myExpandIcon.getWidth() + 3 || e.getClickCount() >= 2) {
                    IssueView.this.setExpanded(!IssueView.this.myIsExpanded);
                }
            }
        };
    }

    void setExpanded(boolean expanded) {
        this.myIsExpanded = expanded;
        if (this.myIsExpanded) {
            this.myErrorDescription.setText(this.myErrorDescriptionContent);
            this.myErrorDescription.getPreferredSize();
        } else {
            this.myErrorDescription.setText("");
        }
        this.myDetailPanel.setVisible(this.myIsExpanded);
        this.myExpandIcon.setIcon(this.myIsExpanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon());
        IssuePanel.ExpandListener expandListener = this.myContainerIssuePanel.getExpandListener();
        if (expandListener != null) {
            expandListener.onExpanded(this.myContainerIssuePanel.getSelectedIssue(), expanded);
        }
        this.revalidate();
        this.repaint();
    }

    @NotNull
    public static Icon getSeverityIcon(@Nullable HighlightSeverity severity) {
        if (severity != null) {
            if (HighlightSeverity.ERROR.equals((Object)severity)) {
                Icon icon2 = StudioIcons.Common.ERROR;
                if (icon2 == null) {
                    IssueView.$$$reportNull$$$0(7);
                }
                return icon2;
            }
            if (HighlightSeverity.WARNING.equals((Object)severity)) {
                Icon icon3 = StudioIcons.Common.WARNING;
                if (icon3 == null) {
                    IssueView.$$$reportNull$$$0(8);
                }
                return icon3;
            }
        }
        Icon icon4 = StudioIcons.Common.INFO;
        if (icon4 == null) {
            IssueView.$$$reportNull$$$0(9);
        }
        return icon4;
    }

    void setSelected(boolean selected) {
        this.setOpaque(selected);
        this.setBackground((Color)(selected ? SELECTED_BG_COLOR : UIUtil.getEditorPaneBackground()));
        this.setFocused(this.myContainerIssuePanel.hasFocus() && selected);
    }

    int getSourceLabelWidth() {
        return this.mySourceLabel.getFontMetrics(this.mySourceLabel.getFont()).stringWidth(this.mySourceLabel.getText());
    }

    void setSourceLabelSize(int sourceLabelSize) {
        Dimension size = this.mySourceLabel.getPreferredSize();
        size.width = sourceLabelSize;
        this.mySourceLabel.setPreferredSize(size);
    }

    @VisibleForTesting
    public String getIssueDescription() {
        return this.myErrorDescription.getText();
    }

    @VisibleForTesting
    public String getIssueTitle() {
        return this.myErrorTitle.getText();
    }

    private void createUIComponents() {
        this.myContent = this;
    }

    private static void applyIssueDescriptionStyle(@NotNull JTextPane textPane) {
        if (textPane == null) {
            IssueView.$$$reportNull$$$0(10);
        }
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL);
        MutableAttributeSet attrs = textPane.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        textPane.getStyledDocument().setCharacterAttributes(0, textPane.getStyledDocument().getLength() + 1, attrs, false);
    }

    void setFocused(boolean focused) {
        this.setBorder((Border)(focused ? this.mySelectedBorder : this.myUnselectedBorder));
    }

    @VisibleForTesting
    @NotNull
    FixEntry[] getFixEntries() {
        FixEntry[] fixEntryArray = (FixEntry[])Arrays.copyOf(this.myFixPanel.getComponents(), this.myFixPanel.getComponentCount(), FixEntry[].class);
        if (fixEntryArray == null) {
            IssueView.$$$reportNull$$$0(11);
        }
        return fixEntryArray;
    }

    @NotNull
    int[] getColumnsX() {
        int[] nArray = new int[]{this.myExpandIcon.getX(), this.mySourceLabel.getX()};
        if (nArray == null) {
            IssueView.$$$reportNull$$$0(12);
        }
        return nArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/error/IssueView";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/error/IssueView";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixEntries";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsX";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupHeader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupFixPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupDescriptionPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayPriority";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFixEntry";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyIssueDescriptionStyle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JTextPane jTextPane;
        JPanel jPanel2;
        JBLabel jBLabel2;
        JLabel jLabel;
        JLabel jLabel2;
        JBLabel jBLabel3;
        this.createUIComponents();
        JPanel jPanel3 = this.myContent;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(2, 5, 2, 5), -1, -1, false, false));
        jPanel3.setOpaque(false);
        this.myExpandIcon = jBLabel3 = new JBLabel();
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorIcon = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLabel = jLabel = new JLabel();
        jPanel3.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorTitle = jBLabel2 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel2.getFont());
        if (font != null) {
            jBLabel2.setFont(font);
        }
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setHorizontalTextPosition(2);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 0, null, null, null));
        this.myDetailPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        ((Component)jPanel2).setVisible(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 2, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myErrorDescription = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        Font font2 = this.$$$getFont$$$(null, -1, -1, jTextPane.getFont());
        if (font2 != null) {
            jTextPane.setFont(font2);
        }
        jTextPane.setOpaque(false);
        jPanel2.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 2, null, new Dimension(558, 50), null));
        this.mySuggestedFixLabel = jBLabel = new JBLabel();
        Font font3 = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font3 != null) {
            jBLabel.setFont(font3);
        }
        jBLabel.setText("Suggested Fix");
        jBLabel.setVisible(false);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(558, 17), null));
        this.myFixPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 3, null, new Dimension(558, 24), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContent;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private static class IssueHTMLEditorKit
    extends HTMLEditorKit {
        StyleSheet style = this.createStyleSheet();

        private IssueHTMLEditorKit() {
        }

        public StyleSheet createStyleSheet() {
            StyleSheet style = new StyleSheet();
            style.addStyleSheet(JBHtmlEditorKit.createStyleSheet());
            style.addRule("body { font-family: Sans-Serif; }");
            style.addRule("code { font-size: 100%; font-family: monospace; }");
            style.addRule("small { font-size: small; }");
            style.addRule("a { text-decoration: none;}");
            return style;
        }

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        @Override
        protected void createInputAttributes(Element element2, MutableAttributeSet set) {
        }
    }

    public static class FixEntry
    extends JComponent {
        private JButton myFixButton;
        private JBLabel myFixText;
        private JComponent myComponent;

        public FixEntry(@NotNull String text2, @NotNull Runnable fixRunnable) {
            if (text2 == null) {
                FixEntry.$$$reportNull$$$0(0);
            }
            if (fixRunnable == null) {
                FixEntry.$$$reportNull$$$0(1);
            }
            this.$$$setupUI$$$();
            this.myFixText.setText(text2);
            this.myFixButton.addActionListener(e -> fixRunnable.run());
        }

        private void createUIComponents() {
            this.myComponent = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixRunnable";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/common/error/IssueView$FixEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBLabel jBLabel;
            JButton jButton;
            this.createUIComponents();
            JComponent jComponent = this.myComponent;
            jComponent.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jComponent.setOpaque(false);
            this.myFixButton = jButton = new JButton();
            jButton.setOpaque(false);
            jButton.setText("Fix");
            jComponent.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 3, null, null, null));
            Spacer spacer = new Spacer();
            jComponent.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myFixText = jBLabel = new JBLabel();
            jComponent.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myComponent;
        }
    }
}

