/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.TooManyIssuesIssue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.ModalityUiUtil;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    private static final int MAX_ISSUE_NUMBER_LIMIT = 200;
    private final int myIssueNumberLimit;
    private ImmutableList<Issue> myIssues;
    private final ListenerCollection<IssueModelListener> myListeners;
    protected int myWarningCount;
    protected int myErrorCount;
    @VisibleForTesting
    public final Runnable myUpdateCallback;
    private List<IssueProvider> myIssueProviders;

    @VisibleForTesting
    IssueModel(@NotNull Executor listenerExecutor, int issueNumberLimit) {
        if (listenerExecutor == null) {
            IssueModel.$$$reportNull$$$0(0);
        }
        this.myIssues = ImmutableList.of();
        this.myUpdateCallback = () -> this.updateErrorsList();
        this.myIssueProviders = new ArrayList<IssueProvider>();
        this.myListeners = ListenerCollection.createWithExecutor(listenerExecutor);
        this.myIssueNumberLimit = issueNumberLimit;
    }

    @VisibleForTesting
    IssueModel(@NotNull Executor listenerExecutor) {
        if (listenerExecutor == null) {
            IssueModel.$$$reportNull$$$0(1);
        }
        this(listenerExecutor, 200);
    }

    public IssueModel() {
        this(command -> ModalityUiUtil.invokeLaterIfNeeded((Runnable)command, (ModalityState)ModalityState.defaultModalityState()));
    }

    @Nullable
    public Issue getHighestSeverityIssue(NlComponent component) {
        IssueSource componentSource = IssueSource.fromNlComponent(component);
        Issue[] filtered = (Issue[])this.myIssues.stream().filter(it -> componentSource.equals(it.getSource())).toArray(Issue[]::new);
        if (filtered.length == 0) {
            return null;
        }
        Issue max = filtered[0];
        for (int i2 = 1; i2 < filtered.length; ++i2) {
            Issue it2 = filtered[i2];
            if (max.getSeverity().compareTo(it2.getSeverity()) >= 0) continue;
            max = it2;
        }
        return max;
    }

    @Nullable
    public static Icon getIssueIcon(@NotNull HighlightSeverity severity, boolean selected) {
        boolean isError;
        if (severity == null) {
            IssueModel.$$$reportNull$$$0(2);
        }
        boolean bl = isError = severity == HighlightSeverity.ERROR;
        if (selected) {
            return isError ? StudioIcons.Common.ERROR_INLINE_SELECTED : StudioIcons.Common.WARNING_INLINE_SELECTED;
        }
        return isError ? StudioIcons.Common.ERROR_INLINE : StudioIcons.Common.WARNING_INLINE;
    }

    @VisibleForTesting
    public void updateErrorsList() {
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        for (IssueProvider provider2 : ImmutableList.copyOf(this.myIssueProviders)) {
            provider2.collectIssues((ImmutableCollection.Builder<Issue>)issueListBuilder);
        }
        ImmutableList newIssueList = issueListBuilder.build();
        if (newIssueList.size() > this.myIssueNumberLimit) {
            newIssueList = ImmutableList.builder().addAll((Iterable)newIssueList.subList(0, this.myIssueNumberLimit)).add((Object)new TooManyIssuesIssue(newIssueList.size() - this.myIssueNumberLimit)).build();
        }
        newIssueList.forEach(issue2 -> this.updateIssuesCounts((Issue)issue2));
        this.myIssues = newIssueList;
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull Issue issue2) {
        if (issue2 == null) {
            IssueModel.$$$reportNull$$$0(3);
        }
        if (issue2.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue2.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    public void addIssueProvider(@NotNull IssueProvider issueProvider2) {
        if (issueProvider2 == null) {
            IssueModel.$$$reportNull$$$0(4);
        }
        this.myIssueProviders.add(issueProvider2);
        issueProvider2.addListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    public void removeIssueProvider(@NotNull IssueProvider issueProvider2) {
        if (issueProvider2 == null) {
            IssueModel.$$$reportNull$$$0(5);
        }
        this.myIssueProviders.remove(issueProvider2);
        issueProvider2.removeListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        ImmutableList<Issue> immutableList = this.myIssues;
        if (immutableList == null) {
            IssueModel.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener2) {
        if (listener2 == null) {
            IssueModel.$$$reportNull$$$0(7);
        }
        this.myListeners.add(listener2);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener2) {
        if (listener2 == null) {
            IssueModel.$$$reportNull$$$0(8);
        }
        this.myListeners.remove(listener2);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    @Nullable
    public Issue findIssue(@NotNull NlComponent component) {
        if (component == null) {
            IssueModel.$$$reportNull$$$0(9);
        }
        for (Issue issue2 : this.myIssues) {
            if (!component.equals(issue2.getSource())) continue;
            return issue2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/error/IssueModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/error/IssueModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIssueIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateIssuesCounts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addIssueProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeIssueProvider";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addErrorModelListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeErrorModelListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

