/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.editor.DesignSurfaceNotificationManager;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.error.IssuePanelSplitter;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.download.AndroidLayoutlibDownloader;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DesignerEditorPanel
extends JPanel
implements Disposable,
DesignSurfaceNotificationManager {
    private static final String DESIGN_UNAVAILABLE_MESSAGE = "Design editor is unavailable until after a successful project sync";
    private static final String ACCESSORY_PROPORTION = "AndroidStudio.AccessoryProportion";
    @NotNull
    private final DesignerEditor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final MyContentPanel myContentPanel;
    @NotNull
    private final WorkBench<DesignSurface> myWorkBench;
    private JBSplitter mySplitter;
    @Nullable
    private final JPanel myAccessoryPanel;
    @Nullable
    private JComponent myBottomComponent;
    private boolean myGradleSyncHappenedAfterModelCreation;
    @NotNull
    private final Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface>>> myToolWindowDefinitions;
    @NotNull
    private State myState;
    @NotNull
    private final AtomicBoolean myIsModelInitializated;
    private final EditorNotificationPanel myNotificationPanel;

    public DesignerEditorPanel(@NotNull DesignerEditor editor2, @NotNull Project project, @NotNull VirtualFile file2, @NotNull WorkBench<DesignSurface> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface> surface2, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface>>> toolWindowDefinitions, final @Nullable BiFunction<? super DesignSurface, ? super NlModel, JComponent> bottomModelComponent, @NotNull State defaultEditorPanelState) {
        if (editor2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DesignerEditorPanel.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(2);
        }
        if (workBench == null) {
            DesignerEditorPanel.$$$reportNull$$$0(3);
        }
        if (surface2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(4);
        }
        if (toolWindowDefinitions == null) {
            DesignerEditorPanel.$$$reportNull$$$0(5);
        }
        if (defaultEditorPanelState == null) {
            DesignerEditorPanel.$$$reportNull$$$0(6);
        }
        super(new BorderLayout());
        this.myIsModelInitializated = new AtomicBoolean(false);
        this.myNotificationPanel = new EditorNotificationPanel();
        this.myEditor = editor2;
        this.myProject = project;
        this.myFile = file2;
        this.myWorkBench = workBench;
        this.myContentPanel = new MyContentPanel();
        this.mySurface = surface2.apply(this);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.myAccessoryPanel = this.mySurface.getAccessoryPanel();
        JComponent toolbar2 = DesignerEditorPanel.createSurfaceToolbar(this.mySurface);
        JPanel toolbarAndNotification = new JPanel();
        toolbarAndNotification.setLayout(new BorderLayout());
        toolbarAndNotification.add((Component)toolbar2, "North");
        this.myNotificationPanel.setVisible(false);
        this.myNotificationPanel.createActionLabel("Dismiss", () -> this.myNotificationPanel.setVisible(false));
        toolbarAndNotification.add((Component)this.myNotificationPanel, "South");
        this.myContentPanel.add(toolbarAndNotification, "North");
        this.myWorkBench.setLoadingText(CommonBundle.getLoadingTreeNodeText());
        this.myState = defaultEditorPanelState;
        this.mySurface.getAnalyticsManager().setEditorModeWithoutTracking(this.myState);
        this.onStateChange();
        this.mySplitter = new IssuePanelSplitter(this.mySurface, (JComponent)this.myWorkBench);
        this.add((Component)this.mySplitter);
        this.myToolWindowDefinitions = toolWindowDefinitions;
        if (bottomModelComponent != null) {
            this.mySurface.addListener(new DesignSurfaceListener(){

                @Override
                public void modelChanged(@NotNull DesignSurface surface2, @Nullable NlModel model2) {
                    if (surface2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (DesignerEditorPanel.this.myBottomComponent != null) {
                        DesignerEditorPanel.this.myContentPanel.remove(DesignerEditorPanel.this.myBottomComponent);
                    }
                    DesignerEditorPanel.this.myBottomComponent = (JComponent)bottomModelComponent.apply(surface2, model2);
                    if (DesignerEditorPanel.this.myBottomComponent != null) {
                        DesignerEditorPanel.this.myContentPanel.add(DesignerEditorPanel.this.myBottomComponent, "South");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/common/editor/DesignerEditorPanel$1", "modelChanged"));
                }
            });
        }
    }

    public void setState(@NotNull State state) {
        if (state == null) {
            DesignerEditorPanel.$$$reportNull$$$0(7);
        }
        this.mySurface.getAnalyticsManager().setEditorModeWithoutTracking(state);
        if (this.myState != state) {
            this.myState = state;
            this.onStateChange();
        }
    }

    private void onStateChange() {
        State currentState = this.getState();
        this.myWorkBench.setContext(currentState.name());
        this.myWorkBench.setDefaultPropertiesForContext(currentState == State.SPLIT);
        if (currentState != State.DEACTIVATED && !this.myIsModelInitializated.getAndSet(true)) {
            ClearResourceCacheAfterFirstBuild.getInstance(this.myProject).runWhenResourceCacheClean(this::initNeleModel, this::buildError);
        }
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            DesignerEditorPanel.$$$reportNull$$$0(8);
        }
        return state;
    }

    public DesignerEditorPanel(@NotNull DesignerEditor editor2, @NotNull Project project, @NotNull VirtualFile file2, @NotNull WorkBench<DesignSurface> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface> surface2, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface>>> toolWindowDefinitions, @NotNull State defaultState) {
        if (editor2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(9);
        }
        if (project == null) {
            DesignerEditorPanel.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(11);
        }
        if (workBench == null) {
            DesignerEditorPanel.$$$reportNull$$$0(12);
        }
        if (surface2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(13);
        }
        if (toolWindowDefinitions == null) {
            DesignerEditorPanel.$$$reportNull$$$0(14);
        }
        if (defaultState == null) {
            DesignerEditorPanel.$$$reportNull$$$0(15);
        }
        this(editor2, project, file2, workBench, surface2, toolWindowDefinitions, null, defaultState);
    }

    @NotNull
    private static JComponent createSurfaceToolbar(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(16);
        }
        JComponent jComponent = surface2.getActionManager().createToolbar();
        if (jComponent == null) {
            DesignerEditorPanel.$$$reportNull$$$0(17);
        }
        return jComponent;
    }

    private void buildError() {
        this.myWorkBench.loadingStopped(DESIGN_UNAVAILABLE_MESSAGE);
    }

    public void initNeleModel() {
        SyncUtil.runWhenSmartAndSynced(this.myProject, this, result2 -> {
            if (result2.isSuccessful()) {
                this.initNeleModelWhenSmart();
            } else {
                this.buildError();
                SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initNeleModel());
            }
        });
    }

    private void initNeleModelWhenSmart() {
        if (Disposer.isDisposed((Disposable)this.myEditor)) {
            return;
        }
        CompletableFuture.supplyAsync(this::createAndInitNeleModel, AppExecutorUtil.getAppExecutorService()).whenComplete((model2, exception) -> {
            if (exception == null) {
                this.mySurface.goingToSetModel((NlModel)model2).join();
                this.myWorkBench.setLoadingText("Waiting for build to finish...");
                SyncUtil.runWhenSmartAndSyncedOnEdt(this.myProject, this, result2 -> {
                    this.myWorkBench.setLoadingText("Initializing...");
                    if (result2.isSuccessful()) {
                        this.initNeleModelOnEventDispatchThread((NlModel)model2);
                    } else {
                        this.buildError();
                        SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initNeleModel());
                    }
                });
            } else {
                Throwable cause = exception.getCause();
                if (cause instanceof WaitingForGradleSyncException) {
                    Logger.getInstance(DesignerEditorPanel.class).info(cause.getMessage());
                    SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initNeleModel());
                    this.myWorkBench.loadingStopped("Design editor is unavailable until next gradle sync.");
                    return;
                }
                if (cause instanceof ProcessCanceledException) {
                    this.myWorkBench.loadingStopped("Failed to initialize editor (operation canceled).");
                    assert (!IdeInfo.getInstance().isAndroidStudio()) : "AndroidStudio has all the resources bundled with the IDE.";
                    return;
                }
                this.myWorkBench.loadingStopped("Failed to initialize editor.");
                Logger.getInstance(DesignerEditorPanel.class).warn("Failed to initialize DesignerEditorPanel", exception);
            }
        });
    }

    @NotNull
    private NlModel createAndInitNeleModel() {
        AndroidLayoutlibDownloader.getInstance().makeSureComponentIsInPlace();
        XmlFile file2 = (XmlFile)ReadAction.compute(() -> this.getFile());
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            if (this.myGradleSyncHappenedAfterModelCreation) {
                throw new IllegalStateException("Could not init NlModel. AndroidFacet is unexpectedly null. That might happen if the file does not belong to an Android module of the project.");
            }
            this.myGradleSyncHappenedAfterModelCreation = true;
            throw new WaitingForGradleSyncException("Waiting for next gradle sync to set AndroidFacet.");
        }
        NlModel model2 = NlModel.builder(facet2, this.myFile, this.mySurface.getConfigurationManager(facet2).getConfiguration(this.myFile)).withParentDisposable((Disposable)this.myEditor).withComponentRegistrar(this.mySurface.getComponentRegistrar()).withModelDisplayName("").build();
        final Module modelModule = AndroidPsiUtils.getModuleSafely((Project)this.myProject, (VirtualFile)this.myFile);
        this.myProject.getMessageBus().connect((Disposable)this.mySurface).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module2) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (module2.equals(modelModule)) {
                    Disposer.dispose((Disposable)DesignerEditorPanel.this.mySurface);
                    DesignerEditorPanel.this.myWorkBench.loadingStopped("This file does not belong to the project.");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/common/editor/DesignerEditorPanel$2";
                objectArray[2] = "moduleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        NlModel nlModel = model2;
        if (nlModel == null) {
            DesignerEditorPanel.$$$reportNull$$$0(18);
        }
        return nlModel;
    }

    @UiThread
    private void initNeleModelOnEventDispatchThread(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(19);
        }
        if (Disposer.isDisposed((Disposable)model2)) {
            return;
        }
        model2.getType().setTypePrerequisites(model2);
        CompletableFuture<Void> modelSetFuture = this.mySurface.setModel(model2);
        if (this.myAccessoryPanel != null) {
            boolean verticalSplitter = (Boolean)StudioFlags.NELE_MOTION_HORIZONTAL.get();
            float initialProportion = PropertiesComponent.getInstance().getFloat(ACCESSORY_PROPORTION, 0.5f);
            final OnePixelSplitter splitter = new OnePixelSplitter(verticalSplitter, initialProportion, 0.1f, 0.9f);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent((JComponent)((Object)this.mySurface));
            splitter.setSecondComponent((JComponent)this.myAccessoryPanel);
            this.mySurface.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (DesignerEditorPanel.this.myAccessoryPanel.isVisible()) {
                        float proportion = splitter.getProportion();
                        PropertiesComponent.getInstance().setValue(DesignerEditorPanel.ACCESSORY_PROPORTION, proportion, 0.5f);
                    }
                }
            });
            this.myContentPanel.add((Component)splitter, "Center");
        } else {
            this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
        }
        modelSetFuture.whenCompleteAsync((result2, ex) -> {
            this.myWorkBench.setContext(this.getState().name());
            this.myWorkBench.init((JComponent)((Object)this.myContentPanel), (Object)this.mySurface, this.myToolWindowDefinitions.apply(model2.getFacet()), this.getState() == State.SPLIT);
        }, (Executor)EdtExecutorService.getInstance());
    }

    @Override
    public void showNotification(String text2) {
        this.myNotificationPanel.setText(text2);
        this.myNotificationPanel.setVisible(true);
    }

    @Override
    public void hideNotification() {
        this.myNotificationPanel.setVisible(false);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            DesignerEditorPanel.$$$reportNull$$$0(20);
        }
        return designSurface;
    }

    @NotNull
    private XmlFile getFile() {
        XmlFile file2 = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)this.myFile);
        assert (file2 != null);
        XmlFile xmlFile = file2;
        if (xmlFile == null) {
            DesignerEditorPanel.$$$reportNull$$$0(21);
        }
        return xmlFile;
    }

    @TestOnly
    public void setIssuePanelProportion(float proportion) {
        this.mySplitter.setProportion(proportion);
    }

    public void dispose() {
    }

    @NotNull
    public WorkBench<DesignSurface> getWorkBench() {
        WorkBench<DesignSurface> workBench = this.myWorkBench;
        if (workBench == null) {
            DesignerEditorPanel.$$$reportNull$$$0(22);
        }
        return workBench;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workBench";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowDefinitions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultEditorPanelState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/DesignerEditorPanel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultState";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditorPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createSurfaceToolbar";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndInitNeleModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkBench";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSurfaceToolbar";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initNeleModelOnEventDispatchThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyContentPanel
    extends AdtPrimaryPanel
    implements DataProvider {
        private MyContentPanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyContentPanel.$$$reportNull$$$0(0);
            }
            if (DesignerDataKeys.DESIGN_SURFACE.is(dataId)) {
                return DesignerEditorPanel.this.getSurface();
            }
            if (NlActionManager.LAYOUT_EDITOR.is(dataId)) {
                ScreenViewProvider mode;
                DesignSurface surface2 = DesignerEditorPanel.this.getSurface();
                if (surface2 instanceof NlDesignSurface && ((mode = ((NlDesignSurface)surface2).getScreenViewProvider()) == NlScreenViewProvider.RENDER || mode == NlScreenViewProvider.BLUEPRINT || mode == NlScreenViewProvider.RENDER_AND_BLUEPRINT)) {
                    return surface2;
                }
            } else if (DesignerDataKeys.NOTIFICATION_KEY.is(dataId)) {
                return DesignerEditorPanel.this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/android/tools/idea/common/editor/DesignerEditorPanel$MyContentPanel", "getData"));
        }
    }

    private static class WaitingForGradleSyncException
    extends RuntimeException {
        private WaitingForGradleSyncException(@NotNull String message2) {
            if (message2 == null) {
                WaitingForGradleSyncException.$$$reportNull$$$0(0);
            }
            super(message2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/common/editor/DesignerEditorPanel$WaitingForGradleSyncException", "<init>"));
        }
    }

    public static enum State {
        FULL,
        SPLIT,
        DEACTIVATED;

    }
}

