/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR);

    private IssueNotificationAction() {
    }

    @NotNull
    public static IssueNotificationAction getInstance() {
        IssueNotificationAction issueNotificationAction = (IssueNotificationAction)ActionManager.getInstance().getAction("Android.Designer.IssueNotificationAction");
        if (issueNotificationAction == null) {
            IssueNotificationAction.$$$reportNull$$$0(0);
        }
        return issueNotificationAction;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(1);
        }
        if (DesignerActionUtils.isActionEventFromJTextField(event)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        super.update(event);
        DesignSurface surface2 = (DesignSurface)((Object)event.getData(DesignerDataKeys.DESIGN_SURFACE));
        Presentation presentation = event.getPresentation();
        if (surface2 == null) {
            event.getPresentation().setEnabled(false);
            presentation.setDescription("Toggle visibility of issue panel");
            presentation.setIcon(DISABLED_ICON);
        } else {
            event.getPresentation().setEnabled(true);
            IssueModel issueModel = surface2.getIssueModel();
            int markerCount = issueModel.getIssueCount();
            presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
            presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        DesignSurface surface2;
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(2);
        }
        return (surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE))) != null && !surface2.getIssuePanel().isMinimized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        DesignSurface surface2;
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(3);
        }
        if ((surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE))) != null) {
            surface2.getAnalyticsManager().trackShowIssuePanel();
            surface2.setShowIssuePanel(state, true);
        }
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        if (issueModel == null) {
            IssueNotificationAction.$$$reportNull$$$0(4);
        }
        Icon icon2 = issueModel.getErrorCount() > 0 ? StudioIcons.Common.ERROR : (issueModel.getWarningCount() > 0 ? StudioIcons.Common.WARNING : (issueModel.getIssueCount() > 0 ? StudioIcons.Common.INFO : DISABLED_ICON));
        Icon icon3 = icon2;
        if (icon3 == null) {
            IssueNotificationAction.$$$reportNull$$$0(5);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIssueTypeIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

