/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StopAvdAction
extends AvdUiAction {
    private boolean myEnabled;
    @NotNull
    private final PropertyChangeSupport myPropertyChangeSupport;
    @NotNull
    private final Function<AvdUiAction.AvdInfoProvider, ListenableFuture<Boolean>> myIsAvdRunning;
    @NotNull
    private final Executor myExecutor;

    StopAvdAction(@NotNull AvdUiAction.AvdInfoProvider provider2) {
        if (provider2 == null) {
            StopAvdAction.$$$reportNull$$$0(0);
        }
        this(provider2, StopAvdAction::isAvdRunning, (Executor)EdtExecutorService.getInstance());
    }

    @VisibleForTesting
    StopAvdAction(@NotNull AvdUiAction.AvdInfoProvider provider2, @NotNull Function<AvdUiAction.AvdInfoProvider, ListenableFuture<Boolean>> isAvdRunning, @NotNull Executor executor) {
        if (provider2 == null) {
            StopAvdAction.$$$reportNull$$$0(1);
        }
        if (isAvdRunning == null) {
            StopAvdAction.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            StopAvdAction.$$$reportNull$$$0(3);
        }
        super(provider2, "Stop", "Stop the emulator running this AVD", AllIcons.Actions.Suspend);
        this.myEnabled = true;
        this.myPropertyChangeSupport = new SwingPropertyChangeSupport(this);
        this.myIsAvdRunning = isAvdRunning;
        this.myExecutor = executor;
    }

    @NotNull
    private static ListenableFuture<Boolean> isAvdRunning(@NotNull AvdUiAction.AvdInfoProvider provider2) {
        if (provider2 == null) {
            StopAvdAction.$$$reportNull$$$0(4);
        }
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService());
        AvdInfo device = provider2.getAvdInfo();
        assert (device != null);
        ListenableFuture listenableFuture = service.submit(() -> AvdManagerConnection.getDefaultAvdManagerConnection().isAvdRunning(device));
        if (listenableFuture == null) {
            StopAvdAction.$$$reportNull$$$0(5);
        }
        return listenableFuture;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.myPropertyChangeSupport.firePropertyChange("enabled", oldEnabled, enabled);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            StopAvdAction.$$$reportNull$$$0(6);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
        FutureUtils.addCallback(this.myIsAvdRunning.apply(this.myAvdInfoProvider), (Executor)this.myExecutor, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(@Nullable Boolean running) {
                StopAvdAction.this.setEnabled(running);
            }

            public void onFailure(@NotNull Throwable throwable) {
                if (throwable == null) {
                    1.$$$reportNull$$$0(0);
                }
                Logger.getInstance(StopAvdAction.class).warn(throwable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/android/tools/idea/avdmanager/StopAvdAction$1", "onFailure"));
            }
        });
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            StopAvdAction.$$$reportNull$$$0(7);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        if (event == null) {
            StopAvdAction.$$$reportNull$$$0(8);
        }
        AvdManagerConnection.getDefaultAvdManagerConnection().stopAvd(Objects.requireNonNull(this.getAvdInfo()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAvdRunning";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/StopAvdAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/StopAvdAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isAvdRunning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvdRunning";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

