/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileOp;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinLayoutDefinition {
    private static final Splitter TOKEN_SPLITTER = Splitter.on((Pattern)Pattern.compile("\\s+")).omitEmptyStrings().trimResults();
    private static final Splitter QUERY_SPLITTER = Splitter.on((char)'.');
    private final Map<String, String> myProperties;
    private final Map<String, SkinLayoutDefinition> myChildren;

    @Nullable
    public static SkinLayoutDefinition parseFile(@NotNull File file2, @NotNull FileOp fop) {
        String contents;
        if (file2 == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(0);
        }
        if (fop == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(1);
        }
        try {
            contents = fop.toString(file2, Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        return SkinLayoutDefinition.parseString(contents);
    }

    @NotNull
    public static SkinLayoutDefinition parseString(@NotNull String contents) {
        if (contents == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(2);
        }
        SkinLayoutDefinition skinLayoutDefinition = SkinLayoutDefinition.loadFromTokens(TOKEN_SPLITTER.split((CharSequence)contents).iterator());
        if (skinLayoutDefinition == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(3);
        }
        return skinLayoutDefinition;
    }

    private SkinLayoutDefinition(@NotNull Map<String, String> properties2, @NotNull Map<String, SkinLayoutDefinition> children) {
        if (properties2 == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(4);
        }
        if (children == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(5);
        }
        this.myProperties = properties2;
        this.myChildren = children;
    }

    private static SkinLayoutDefinition loadFromTokens(Iterator<String> tokens) {
        String key;
        ImmutableMap.Builder children = ImmutableMap.builder();
        ImmutableMap.Builder properties2 = ImmutableMap.builder();
        while (tokens.hasNext() && !(key = tokens.next()).equals("}")) {
            String value2 = tokens.next();
            if (value2.equals("{")) {
                children.put((Object)key, (Object)SkinLayoutDefinition.loadFromTokens(tokens));
                continue;
            }
            properties2.put((Object)key, (Object)value2);
        }
        return new SkinLayoutDefinition((Map<String, String>)properties2.build(), (Map<String, SkinLayoutDefinition>)children.build());
    }

    @Nullable
    public String getValue(@NotNull String queryString) {
        if (queryString == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(6);
        }
        int lastDot = queryString.lastIndexOf(46);
        String name = queryString.substring(lastDot + 1);
        SkinLayoutDefinition node2 = lastDot < 0 ? this : this.getNode(queryString.substring(0, lastDot));
        return node2 == null ? null : node2.myProperties.get(name);
    }

    @Nullable
    public SkinLayoutDefinition getNode(@NotNull String queryString) {
        if (queryString == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(7);
        }
        SkinLayoutDefinition result2 = null;
        SkinLayoutDefinition node2 = this;
        for (String name : QUERY_SPLITTER.split((CharSequence)queryString)) {
            if (node2 == null) {
                return null;
            }
            result2 = node2 = node2.myChildren.get(name);
        }
        return result2;
    }

    @NotNull
    public Map<String, SkinLayoutDefinition> getChildren() {
        Map<String, SkinLayoutDefinition> map2 = this.myChildren;
        if (map2 == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(8);
        }
        return map2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.makeString(buf, 1);
        return buf.toString();
    }

    private void makeString(@NotNull StringBuilder buf, int depth) {
        if (buf == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(9);
        }
        buf.append("{\n");
        for (String key : ContainerUtil.sorted(this.myProperties.keySet())) {
            SkinLayoutDefinition.appendSpace(buf, depth);
            buf.append(key);
            buf.append("    ");
            buf.append(this.myProperties.get(key));
            buf.append("\n");
        }
        for (String key : ContainerUtil.sorted(this.myChildren.keySet())) {
            SkinLayoutDefinition.appendSpace(buf, depth);
            buf.append(key);
            buf.append("    ");
            this.myChildren.get(key).makeString(buf, depth + 1);
        }
        SkinLayoutDefinition.appendSpace(buf, depth - 1);
        buf.append("}\n");
    }

    private static void appendSpace(@NotNull StringBuilder buf, int depth) {
        if (buf == null) {
            SkinLayoutDefinition.$$$reportNull$$$0(10);
        }
        for (int i2 = 0; i2 < depth; ++i2) {
            buf.append("  ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/SkinLayoutDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryString";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/SkinLayoutDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseString";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendSpace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

