/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinChooser
extends ComboboxWithBrowseButton
implements ItemListener,
ItemSelectable {
    private List<ItemListener> myListeners = new ArrayList<ItemListener>();
    private boolean myResolveSystemImageSkins;

    public SkinChooser(@Nullable Project project, boolean resolveSystemImageSkins) {
        this.myResolveSystemImageSkins = resolveSystemImageSkins;
        this.setItems(this.getSkins());
        this.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                File skinFile = value2 == null ? AvdWizardUtils.NO_SKIN : (File)value2;
                String skinPath = skinFile.getPath();
                if (FileUtil.filesEqual((File)skinFile, (File)AvdWizardUtils.NO_SKIN)) {
                    this.append("No Skin");
                } else if (skinPath.contains("/sdk/platforms/")) {
                    this.append(skinPath.replaceAll(".*/sdk/platforms/(.*)/skins/(.*)", "$2 ($1)"));
                } else if (skinPath.contains("/sdk/system-images/")) {
                    this.append(skinPath.replaceAll(".*/sdk/system-images/(.*)/(.*)/(.*)/skins/(.*)", "$4 ($1 $3)"));
                } else {
                    this.append(skinFile.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/avdmanager/SkinChooser$1", "customizeCellRenderer"));
            }
        });
        FileChooserDescriptor skinChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.addBrowseFolderListener("Select Custom Skin", "Select the directory containing your custom skin definition", project, skinChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                return ((File)component.getSelectedItem()).getPath();
            }

            public void setText(JComboBox component, @NotNull String text2) {
                if (text2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                List<File> items2 = SkinChooser.this.getSkins();
                File f = new File(text2);
                items2.add(f);
                SkinChooser.this.setItems(items2);
                SkinChooser.this.getComboBox().setSelectedItem(f);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/avdmanager/SkinChooser$2", "setText"));
            }
        });
        this.getComboBox().addItemListener(this);
        this.setTextFieldPreferredWidth(20);
    }

    private void setItems(List<File> items2) {
        this.getComboBox().setModel(new CollectionComboBoxModel(items2));
    }

    private List<File> getSkins() {
        List<Device> devices2 = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        TreeSet result2 = new TreeSet();
        for (Device device : devices2) {
            File skinFile = AvdWizardUtils.pathToUpdatedSkins(device.getDefaultHardware().getSkinFile(), null, FileOpUtils.create());
            if (skinFile == null || !skinFile.exists()) continue;
            result2.add(skinFile);
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SkinChooser.class);
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        for (IAndroidTarget target : sdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress)) {
            Arrays.stream(target.getSkins()).map(this::resolve).forEach(result2::add);
        }
        for (ISystemImage img : sdkHandler.getSystemImageManager((ProgressIndicator)progress).getImages()) {
            Arrays.stream(img.getSkins()).map(this::resolve).forEach(result2::add);
        }
        ArrayList<File> resultList = new ArrayList<File>();
        resultList.add(AvdWizardUtils.NO_SKIN);
        resultList.addAll(result2);
        return resultList;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemEvent newEvent = new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange());
        for (ItemListener listener2 : this.myListeners) {
            listener2.itemStateChanged(newEvent);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getComboBox().getSelectedObjects();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.getComboBox().addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.getComboBox().removeItemListener(l);
    }

    @Nullable
    private File resolve(@Nullable File skinFile) {
        if (skinFile == null) {
            return null;
        }
        if (this.myResolveSystemImageSkins) {
            return AvdWizardUtils.pathToUpdatedSkins(skinFile, null, FileOpUtils.create());
        }
        return new File(skinFile.getName());
    }
}

