/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileUtilKt;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.table.TableView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SizeOnDisk
implements Comparable<SizeOnDisk> {
    @VisibleForTesting
    static final int MODEL_COLUMN_INDEX = 7;
    @NotNull
    private String myString;
    private long myValue;
    @NotNull
    private final ListenableFuture<Long> myFuture;

    SizeOnDisk(@NotNull AvdInfo device, @NotNull TableView<AvdInfo> table2) {
        if (device == null) {
            SizeOnDisk.$$$reportNull$$$0(0);
        }
        if (table2 == null) {
            SizeOnDisk.$$$reportNull$$$0(1);
        }
        this(device, table2, () -> SizeOnDisk.getSize(Paths.get(device.getDataFolderPath(), new String[0])), (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private static ListenableFuture<Long> getSize(@NotNull Path path2) {
        if (path2 == null) {
            SizeOnDisk.$$$reportNull$$$0(2);
        }
        ListenableFuture listenableFuture = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService()).submit(() -> FileUtilKt.recursiveSize((Path)path2));
        if (listenableFuture == null) {
            SizeOnDisk.$$$reportNull$$$0(3);
        }
        return listenableFuture;
    }

    @VisibleForTesting
    SizeOnDisk(@NotNull AvdInfo device, @NotNull TableView<AvdInfo> table2, @NotNull ListenableFuture<Long> future2) {
        if (device == null) {
            SizeOnDisk.$$$reportNull$$$0(4);
        }
        if (table2 == null) {
            SizeOnDisk.$$$reportNull$$$0(5);
        }
        if (future2 == null) {
            SizeOnDisk.$$$reportNull$$$0(6);
        }
        this(device, table2, () -> future2, MoreExecutors.directExecutor());
    }

    private SizeOnDisk(final @NotNull AvdInfo device, final @NotNull TableView<AvdInfo> table2, @NotNull Supplier<? extends ListenableFuture<Long>> futureSupplier, @NotNull Executor executor) {
        if (device == null) {
            SizeOnDisk.$$$reportNull$$$0(7);
        }
        if (table2 == null) {
            SizeOnDisk.$$$reportNull$$$0(8);
        }
        if (futureSupplier == null) {
            SizeOnDisk.$$$reportNull$$$0(9);
        }
        if (executor == null) {
            SizeOnDisk.$$$reportNull$$$0(10);
        }
        this.myString = "Calculating...";
        this.myValue = -1L;
        this.myFuture = futureSupplier.get();
        this.addCallback(executor, new FutureCallback<Long>(){

            public void onSuccess(@Nullable Long value2) {
                assert (value2 != null);
                Storage storage = new Storage(value2.longValue());
                SizeOnDisk.this.myString = SizeOnDisk.toString(storage);
                SizeOnDisk.this.myValue = storage.getSize();
                ((AbstractTableModel)table2.getModel()).fireTableCellUpdated(table2.getItems().indexOf(device), 7);
            }

            public void onFailure(@NotNull Throwable throwable) {
                if (throwable == null) {
                    1.$$$reportNull$$$0(0);
                }
                Logger.getInstance(SizeOnDisk.class).warn(throwable);
                SizeOnDisk.this.myString = "Failed to calculate";
                SizeOnDisk.this.myValue = Long.MAX_VALUE;
                ((AbstractTableModel)table2.getModel()).fireTableCellUpdated(table2.getItems().indexOf(device), 7);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/android/tools/idea/avdmanager/SizeOnDisk$1", "onFailure"));
            }
        });
    }

    private void addCallback(@NotNull Executor executor, @NotNull FutureCallback<Long> callback2) {
        if (executor == null) {
            SizeOnDisk.$$$reportNull$$$0(11);
        }
        if (callback2 == null) {
            SizeOnDisk.$$$reportNull$$$0(12);
        }
        Futures.addCallback(this.myFuture, callback2, (Executor)executor);
    }

    @NotNull
    @VisibleForTesting
    static String toString(@NotNull Storage storage) {
        if (storage == null) {
            SizeOnDisk.$$$reportNull$$$0(13);
        }
        double value2 = storage.getPreciseSizeAsUnit(Storage.Unit.MiB);
        String unitSymbol = "MB";
        if (value2 >= 1024.0) {
            value2 = storage.getPreciseSizeAsUnit(Storage.Unit.GiB);
            unitSymbol = "GB";
        }
        String string = String.format(value2 > 9.94 ? "%.0f %s" : "%.1f %s", value2, unitSymbol);
        if (string == null) {
            SizeOnDisk.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.myString;
        if (string == null) {
            SizeOnDisk.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull SizeOnDisk sizeOnDisk) {
        if (sizeOnDisk == null) {
            SizeOnDisk.$$$reportNull$$$0(16);
        }
        return Long.compare(this.myValue, sizeOnDisk.myValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/SizeOnDisk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futureSupplier";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sizeOnDisk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/SizeOnDisk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSize";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 3: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCallback";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

