/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;

public class HaxmAlert
extends JPanel {
    private JBLabel myWarningMessage;
    private HyperlinkLabel myErrorInstructionsLink = new HyperlinkLabel();
    private HyperlinkListener myErrorLinkListener;
    private SystemImageDescription myImageDescription;
    private AccelerationErrorCode myAccelerationErrorCode;
    private Logger myLogger;

    public HaxmAlert() {
        this.myWarningMessage = new JBLabel(){

            public Dimension getPreferredSize() {
                View view = (View)this.getClientProperty("html");
                Container parent = this.getParent();
                if (view != null && parent != null && parent.getWidth() > 0 && parent.getWidth() != (int)view.getPreferredSpan(0)) {
                    view.setSize(parent.getWidth(), 0.0f);
                    return new Dimension((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
                }
                return super.getPreferredSize();
            }
        };
        this.setLayout((LayoutManager)new GridLayoutManager(2, 1));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        this.add((Component)this.myWarningMessage, constraints);
        constraints.setRow(1);
        this.add((Component)this.myErrorInstructionsLink, constraints);
        this.myErrorInstructionsLink.setOpaque(false);
        this.myWarningMessage.setForeground((Color)JBColor.RED);
        this.myWarningMessage.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Recommendation"), BorderFactory.createEmptyBorder(0, 5, 3, 5)));
    }

    public void setSystemImageDescription(SystemImageDescription description2) {
        this.myImageDescription = description2;
        this.refresh();
    }

    private void refresh() {
        if (this.myImageDescription == null) {
            this.setVisible(false);
            return;
        }
        ListenableFuture<AccelerationErrorCode> accelerationError = this.getAccelerationState(false);
        Futures.addCallback(accelerationError, (FutureCallback)new FutureCallback<AccelerationErrorCode>(){

            public void onSuccess(AccelerationErrorCode result2) {
                String warningText;
                HaxmAlert.this.myAccelerationErrorCode = result2;
                boolean hasLink = false;
                StringBuilder warningTextBuilder = new StringBuilder();
                if (result2 != AccelerationErrorCode.ALREADY_INSTALLED) {
                    hasLink = true;
                    warningTextBuilder.append(result2.getProblem());
                    warningTextBuilder.append("<br>");
                    HaxmAlert.this.myErrorInstructionsLink.setHyperlinkText(result2.getSolution().getDescription());
                    if (HaxmAlert.this.myErrorLinkListener != null) {
                        HaxmAlert.this.myErrorInstructionsLink.removeHyperlinkListener(HaxmAlert.this.myErrorLinkListener);
                    }
                    final Runnable action2 = AccelerationErrorSolution.getActionForFix(result2, null, () -> HaxmAlert.this.refresh(), null);
                    HaxmAlert.this.myErrorLinkListener = new HyperlinkAdapter(){

                        protected void hyperlinkActivated(HyperlinkEvent e) {
                            action2.run();
                        }
                    };
                    HaxmAlert.this.myErrorInstructionsLink.addHyperlinkListener(HaxmAlert.this.myErrorLinkListener);
                    HaxmAlert.this.myErrorInstructionsLink.setToolTipText(result2.getSolution() != AccelerationErrorSolution.SolutionCode.NONE ? result2.getSolutionMessage() : null);
                }
                if (HaxmAlert.this.myImageDescription != null) {
                    Abi abi;
                    if (HaxmAlert.this.myImageDescription.getVersion().getApiLevel() < 16) {
                        if (warningTextBuilder.length() > 0) {
                            warningTextBuilder.append("<br>");
                        }
                        warningTextBuilder.append("This API Level is Deprecated<br>");
                    }
                    if ((abi = Abi.getEnum((String)HaxmAlert.this.myImageDescription.getAbiType())) != Abi.X86 && abi != Abi.X86_64) {
                        if (warningTextBuilder.length() > 0) {
                            warningTextBuilder.append("<br>");
                        }
                        warningTextBuilder.append("Consider using an x86 system image on an x86 host for better emulation performance.<br>");
                    }
                    if (!AvdWizardUtils.TAGS_WITH_GOOGLE_API.contains(HaxmAlert.this.myImageDescription.getTag())) {
                        if (warningTextBuilder.length() > 0) {
                            warningTextBuilder.append("<br>");
                        }
                        warningTextBuilder.append("Consider using a system image with Google APIs to enable testing with Google Play Services.");
                    }
                }
                if (!(warningText = warningTextBuilder.toString()).isEmpty()) {
                    warningTextBuilder.insert(0, "<html>");
                    warningTextBuilder.append("</html>");
                    HaxmAlert.this.myWarningMessage.setText(warningTextBuilder.toString().replaceAll("\n", "<br>"));
                    HaxmAlert.this.setVisible(true);
                    HaxmAlert.this.myErrorInstructionsLink.setVisible(hasLink);
                } else {
                    HaxmAlert.this.setVisible(false);
                }
            }

            public void onFailure(Throwable t) {
                if (HaxmAlert.this.myLogger == null) {
                    HaxmAlert.this.myLogger = Logger.getInstance(HaxmAlert.class);
                }
                HaxmAlert.this.myLogger.warn("Check for emulation acceleration failed", t);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    public ListenableFuture<AccelerationErrorCode> getAccelerationState(boolean forceRefresh) {
        if (this.myAccelerationErrorCode == null || forceRefresh) {
            return HaxmAlert.computeAccelerationState();
        }
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)((Object)this.myAccelerationErrorCode));
        if (listenableFuture == null) {
            HaxmAlert.$$$reportNull$$$0(0);
        }
        return listenableFuture;
    }

    @NotNull
    private static ListenableFuture<AccelerationErrorCode> computeAccelerationState() {
        AvdManagerConnection manager = AvdManagerConnection.getDefaultAvdManagerConnection();
        ListenableFuture<AccelerationErrorCode> listenableFuture = manager.checkAccelerationAsync();
        if (listenableFuture == null) {
            HaxmAlert.$$$reportNull$$$0(1);
        }
        return listenableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/avdmanager/HaxmAlert";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccelerationState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAccelerationState";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

