/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.EmulatorProcessHandler;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AvdLaunchEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorRunner {
    private final GeneralCommandLine myCommandLine;
    private ProcessHandler myProcessHandler;
    private final List<ProcessListener> myExtraListeners;

    public EmulatorRunner(@NotNull GeneralCommandLine commandLine, @Nullable AvdInfo avdInfo) {
        if (commandLine == null) {
            EmulatorRunner.$$$reportNull$$$0(0);
        }
        this.myExtraListeners = new ArrayList<ProcessListener>();
        this.myCommandLine = commandLine;
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_TO_EMULATOR);
        event.setAvdLaunchEvent(AvdLaunchEvent.newBuilder().setLaunchType(EmulatorRunner.getLaunchType(commandLine)).setAvdClass(EmulatorRunner.getAvdClass(avdInfo)));
        if (avdInfo != null) {
            event.setDeviceInfo(DeviceInfo.newBuilder().setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)avdInfo.getAbiType())).setBuildApiLevelFull(avdInfo.getAndroidVersion().toString()));
        }
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public ProcessHandler start() throws ExecutionException {
        Process process = this.myCommandLine.createProcess();
        this.myProcessHandler = new EmulatorProcessHandler(process, this.myCommandLine);
        this.myExtraListeners.forEach(arg_0 -> ((ProcessHandler)this.myProcessHandler).addProcessListener(arg_0));
        this.myProcessHandler.startNotify();
        return this.myProcessHandler;
    }

    public void addProcessListener(@NotNull ProcessListener listener2) {
        if (listener2 == null) {
            EmulatorRunner.$$$reportNull$$$0(1);
        }
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener(listener2);
        } else {
            this.myExtraListeners.add(listener2);
        }
    }

    @NotNull
    private static AvdLaunchEvent.LaunchType getLaunchType(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            EmulatorRunner.$$$reportNull$$$0(2);
        }
        AvdLaunchEvent.LaunchType launchType = commandLine.getParametersList().getParameters().contains("-qt-hide-window") ? AvdLaunchEvent.LaunchType.IN_TOOL_WINDOW : AvdLaunchEvent.LaunchType.STANDALONE;
        if (launchType == null) {
            EmulatorRunner.$$$reportNull$$$0(3);
        }
        return launchType;
    }

    @NotNull
    private static AvdLaunchEvent.AvdClass getAvdClass(@Nullable AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdLaunchEvent.AvdClass avdClass = AvdLaunchEvent.AvdClass.UNKNOWN_AVD_CLASS;
            if (avdClass == null) {
                EmulatorRunner.$$$reportNull$$$0(4);
            }
            return avdClass;
        }
        String tag = avdInfo.getProperty("tag.id");
        if ("android-tv".equals(tag)) {
            AvdLaunchEvent.AvdClass avdClass = AvdLaunchEvent.AvdClass.TV;
            if (avdClass == null) {
                EmulatorRunner.$$$reportNull$$$0(5);
            }
            return avdClass;
        }
        if ("android-automotive".equals(tag)) {
            AvdLaunchEvent.AvdClass avdClass = AvdLaunchEvent.AvdClass.AUTOMOTIVE;
            if (avdClass == null) {
                EmulatorRunner.$$$reportNull$$$0(6);
            }
            return avdClass;
        }
        if ("android-wear".equals(tag)) {
            AvdLaunchEvent.AvdClass avdClass = AvdLaunchEvent.AvdClass.WEARABLE;
            if (avdClass == null) {
                EmulatorRunner.$$$reportNull$$$0(7);
            }
            return avdClass;
        }
        if (AvdManagerConnection.isFoldable(avdInfo)) {
            AvdLaunchEvent.AvdClass avdClass = AvdLaunchEvent.AvdClass.FOLDABLE;
            if (avdClass == null) {
                EmulatorRunner.$$$reportNull$$$0(8);
            }
            return avdClass;
        }
        AvdLaunchEvent.AvdClass avdClass = AvdLaunchEvent.AvdClass.GENERIC;
        if (avdClass == null) {
            EmulatorRunner.$$$reportNull$$$0(9);
        }
        return avdClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/EmulatorRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/EmulatorRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvdClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addProcessListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

