/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.Slow;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.MoreFiles;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceSkinUpdater {
    @NotNull
    private final Path myStudioSkins;
    @NotNull
    private final Path mySdkSkins;
    private final boolean myEmulatorSupportsWebP;
    @NotNull
    private final FileSystem myFileSystem;
    @NotNull
    private final Converter myConverter;

    @VisibleForTesting
    DeviceSkinUpdater(@NotNull Path studioSkins, @NotNull Path sdkSkins, boolean emulatorSupportsWebP, @NotNull FileSystem fileSystem, @NotNull Converter converter) {
        if (studioSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(0);
        }
        if (sdkSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(1);
        }
        if (fileSystem == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(3);
        }
        this.myStudioSkins = studioSkins;
        this.mySdkSkins = sdkSkins;
        this.myEmulatorSupportsWebP = emulatorSupportsWebP;
        this.myFileSystem = fileSystem;
        this.myConverter = converter;
    }

    @Slow
    @NotNull
    static Path updateSkins(@NotNull Path device) {
        if (device == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(4);
        }
        File studioSkins = DeviceArtDescriptor.getBundledDescriptorsFolder();
        AndroidSdkData sdk = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        return DeviceSkinUpdater.updateSkins(device, studioSkins == null ? null : studioSkins.toPath(), sdk == null ? null : sdk.getLocation().toPath(), sdk != null && AvdWizardUtils.emulatorSupportsWebp(sdk.getSdkHandler()));
    }

    @VisibleForTesting
    @NotNull
    static Path updateSkins(@NotNull Path device, @Nullable Path studioSkins, @Nullable Path sdkSkins, boolean emulatorSupportsWebP) {
        if (device == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(5);
        }
        if (studioSkins == null && sdkSkins == null) {
            Path path2 = device;
            if (path2 == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(6);
            }
            return path2;
        }
        if (studioSkins == null) {
            Path path3 = sdkSkins.resolve(device);
            if (path3 == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(7);
            }
            return path3;
        }
        if (sdkSkins == null) {
            Path path4 = studioSkins.resolve(device);
            if (path4 == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(8);
            }
            return path4;
        }
        DeviceSkinUpdater updater = new DeviceSkinUpdater(studioSkins, sdkSkins, emulatorSupportsWebP, FileSystems.getDefault(), new Converter());
        Path path5 = updater.updateSkinsImpl(device);
        if (path5 == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(9);
        }
        return path5;
    }

    @VisibleForTesting
    @NotNull
    Path updateSkinsImpl(@NotNull Path device) {
        Path studioDeviceSkins;
        Path sdkDeviceSkins;
        block10: {
            Path path2;
            if (device == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(10);
            }
            assert (!(device.toString().isEmpty() || device.isAbsolute() || device.equals(this.myFileSystem.getPath("_no_skin", new String[0])))) : device;
            sdkDeviceSkins = this.mySdkSkins.resolve(device);
            studioDeviceSkins = this.getStudioDeviceSkins(device);
            try {
                if (!DeviceSkinUpdater.areSdkDeviceSkinsUpToDate(sdkDeviceSkins, studioDeviceSkins)) break block10;
                path2 = sdkDeviceSkins;
            }
            catch (IOException exception) {
                Logger.getInstance(DeviceSkinUpdater.class).warn((Throwable)exception);
                Path path3 = studioDeviceSkins;
                if (path3 == null) {
                    DeviceSkinUpdater.$$$reportNull$$$0(13);
                }
                return path3;
            }
            if (path2 == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(11);
            }
            return path2;
        }
        Files.createDirectories(sdkDeviceSkins, new FileAttribute[0]);
        if (this.myEmulatorSupportsWebP) {
            DeviceSkinUpdater.copyStudioDeviceSkins(studioDeviceSkins, sdkDeviceSkins);
        } else {
            this.convertAndCopyStudioDeviceSkins(studioDeviceSkins, sdkDeviceSkins);
        }
        Path path4 = sdkDeviceSkins;
        if (path4 == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(12);
        }
        return path4;
    }

    @NotNull
    private Path getStudioDeviceSkins(@NotNull Path device) {
        if (device == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(14);
        }
        if (device.equals(this.myFileSystem.getPath("AndroidWearRound", new String[0]))) {
            Path path2 = this.myStudioSkins.resolve("wear_round");
            if (path2 == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(15);
            }
            return path2;
        }
        if (device.equals(this.myFileSystem.getPath("AndroidWearSquare", new String[0]))) {
            Path path3 = this.myStudioSkins.resolve("wear_square");
            if (path3 == null) {
                DeviceSkinUpdater.$$$reportNull$$$0(16);
            }
            return path3;
        }
        Path path4 = this.myStudioSkins.resolve(device);
        if (path4 == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(17);
        }
        return path4;
    }

    private static boolean areSdkDeviceSkinsUpToDate(@NotNull Path sdkDeviceSkins, @NotNull Path studioDeviceSkins) throws IOException {
        if (sdkDeviceSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(18);
        }
        if (studioDeviceSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(19);
        }
        if (Files.notExists(sdkDeviceSkins, new LinkOption[0])) {
            return false;
        }
        Path studioLayout = studioDeviceSkins.resolve("layout");
        if (Files.notExists(studioLayout, new LinkOption[0])) {
            return true;
        }
        Path sdkLayout = sdkDeviceSkins.resolve("layout");
        if (Files.notExists(sdkLayout, new LinkOption[0])) {
            return false;
        }
        if (Files.getLastModifiedTime(studioLayout, new LinkOption[0]).compareTo(Files.getLastModifiedTime(sdkLayout, new LinkOption[0])) < 0) {
            return true;
        }
        PathUtils.deleteRecursivelyIfExists((Path)sdkDeviceSkins);
        return false;
    }

    private static void copyStudioDeviceSkins(@NotNull Path studioDeviceSkins, @NotNull Path sdkDeviceSkins) throws IOException {
        if (studioDeviceSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(20);
        }
        if (sdkDeviceSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(21);
        }
        for (Path path2 : DeviceSkinUpdater.list(studioDeviceSkins)) {
            DeviceSkinUpdater.copy(path2, sdkDeviceSkins.resolve(path2.getFileName()));
        }
    }

    private void convertAndCopyStudioDeviceSkins(@NotNull Path studioDeviceSkins, @NotNull Path sdkDeviceSkins) throws IOException {
        if (studioDeviceSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(22);
        }
        if (sdkDeviceSkins == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(23);
        }
        Collection<Path> paths = DeviceSkinUpdater.list(studioDeviceSkins);
        Path layout2 = null;
        int size = paths.size();
        ArrayList<String> namesToReplace = new ArrayList<String>(size);
        ArrayList<String> namesToReplaceThemWith = new ArrayList<String>(size);
        for (Path path2 : paths) {
            Path pngImage;
            String name = path2.getFileName().toString();
            if (name.equals("layout")) {
                layout2 = path2;
                continue;
            }
            if (name.endsWith(".webp") && this.myConverter.convert(path2, pngImage = sdkDeviceSkins.resolve(MoreFiles.getNameWithoutExtension((Path)path2.getFileName()) + ".png"))) {
                namesToReplace.add(name);
                namesToReplaceThemWith.add(pngImage.getFileName().toString());
                continue;
            }
            DeviceSkinUpdater.copy(path2, sdkDeviceSkins.resolve(name));
        }
        if (layout2 == null) {
            return;
        }
        DeviceSkinUpdater.replaceAll(layout2, namesToReplace, namesToReplaceThemWith, sdkDeviceSkins.resolve(layout2.getFileName()));
    }

    private static void replaceAll(@NotNull Path source, @NotNull @NotNull List<@NotNull String> stringsToReplace, @NotNull @NotNull List<@NotNull String> stringsToReplaceThemWith, @NotNull Path target) throws IOException {
        if (source == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(24);
        }
        if (stringsToReplace == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(25);
        }
        if (stringsToReplaceThemWith == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(26);
        }
        if (target == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(27);
        }
        String sourceString = new String(Files.readAllBytes(source), StandardCharsets.UTF_8);
        String targetString = StringUtil.replace((String)sourceString, stringsToReplace, stringsToReplaceThemWith);
        Files.write(target, targetString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    @NotNull
    static @NotNull Collection<@NotNull Path> list(@NotNull Path directory) throws IOException {
        if (directory == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(28);
        }
        Stream<Path> stream = Files.list(directory);
        Collection collection2 = stream.sorted().collect(Collectors.toList());
        Collection collection3 = collection2;
        if (collection3 == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(29);
        }
        return collection3;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @VisibleForTesting
    static void copy(@NotNull Path source, @NotNull Path target) throws IOException {
        if (source == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(30);
        }
        if (target == null) {
            DeviceSkinUpdater.$$$reportNull$$$0(31);
        }
        if (!Files.isRegularFile(source, new LinkOption[0])) {
            return;
        }
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        Files.copy(source, target, new CopyOption[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "studioSkins";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkSkins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/DeviceSkinUpdater";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkDeviceSkins";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "studioDeviceSkins";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringsToReplace";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringsToReplaceThemWith";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/DeviceSkinUpdater";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSkins";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSkinsImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStudioDeviceSkins";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateSkins";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSkinsImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStudioDeviceSkins";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "areSdkDeviceSkinsUpToDate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "copyStudioDeviceSkins";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convertAndCopyStudioDeviceSkins";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceAll";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class Converter {
        Converter() {
        }

        @VisibleForTesting
        boolean convert(@NotNull Path webPImage, @NotNull Path pngImage) throws IOException {
            BufferedImage image;
            if (webPImage == null) {
                Converter.$$$reportNull$$$0(0);
            }
            if (pngImage == null) {
                Converter.$$$reportNull$$$0(1);
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(webPImage, new OpenOption[0]));){
                image = ImageIO.read(in);
            }
            if (image == null) {
                return false;
            }
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(pngImage, new OpenOption[0]));){
                ImageIO.write((RenderedImage)image, "PNG", out);
                boolean bl = true;
                return bl;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "webPImage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pngImage";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/avdmanager/DeviceSkinUpdater$Converter";
            objectArray[2] = "convert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

