/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.State;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdHardwareData;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureDeviceModel
extends WizardModel {
    private final DeviceUiAction.DeviceProvider myProvider;
    private final BindingsManager myBindings;
    private final Device.Builder myBuilder;
    private final AvdDeviceData myDeviceData;

    public ConfigureDeviceModel(@NotNull DeviceUiAction.DeviceProvider provider2) {
        if (provider2 == null) {
            ConfigureDeviceModel.$$$reportNull$$$0(0);
        }
        this(provider2, null, false);
    }

    public ConfigureDeviceModel(@NotNull DeviceUiAction.DeviceProvider provider2, @Nullable Device device, boolean cloneDevice) {
        if (provider2 == null) {
            ConfigureDeviceModel.$$$reportNull$$$0(1);
        }
        this.myBindings = new BindingsManager();
        this.myBuilder = new Device.Builder();
        this.myProvider = provider2;
        this.myDeviceData = new AvdDeviceData(device, null);
        if (cloneDevice) {
            if (device == null) {
                throw new IllegalArgumentException("Can't clone a device without specifying a device.");
            }
            this.myDeviceData.setUniqueName(String.format("%s (Edited)", device.getDisplayName()));
        }
        this.myDeviceData.density().set(Density.NODPI);
        if (device != null) {
            this.initBootProperties(device);
        }
    }

    @Nullable
    private static State createState(ScreenOrientation orientation, Hardware hardware, boolean hasHardwareKeyboard) {
        State state = null;
        Object name = "";
        Object description2 = "";
        if (orientation == ScreenOrientation.LANDSCAPE) {
            name = "Landscape";
            description2 = "The device in landscape orientation";
            state = new State();
        } else if (orientation == ScreenOrientation.PORTRAIT) {
            name = "Portrait";
            description2 = "The device in portrait orientation";
            state = new State();
        }
        if (state != null) {
            if (hasHardwareKeyboard) {
                name = (String)name + " with keyboard";
                description2 = (String)description2 + " with a keyboard open";
                state.setKeyState(KeyboardState.EXPOSED);
            } else if (hardware.getKeyboard() != null && hardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                state.setKeyState(KeyboardState.SOFT);
            } else {
                state.setKeyState(KeyboardState.HIDDEN);
            }
            state.setName((String)name);
            state.setHardware(hardware);
            state.setOrientation(orientation);
            state.setDescription((String)description2);
            state.setNavState(hardware.getNav().equals((Object)Navigation.NONAV) ? NavigationState.HIDDEN : NavigationState.EXPOSED);
        }
        return state;
    }

    @Nullable
    public Project getProject() {
        return this.myProvider.getProject();
    }

    public AvdDeviceData getDeviceData() {
        return this.myDeviceData;
    }

    private void initBootProperties(@NotNull Device device) {
        if (device == null) {
            ConfigureDeviceModel.$$$reportNull$$$0(2);
        }
        for (Map.Entry entry : device.getBootProps().entrySet()) {
            this.myBuilder.addBootProp((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    protected void handleFinished() {
        Device device = this.buildDevice();
        DeviceManagerConnection.getDefaultDeviceManagerConnection().createOrEditDevice(device);
        this.myProvider.refreshDevices();
        this.myProvider.setDevice(device);
    }

    @NotNull
    private Device buildDevice() {
        String deviceName = (String)this.myDeviceData.name().get();
        this.myBuilder.setName(deviceName);
        this.myBuilder.setId(deviceName);
        this.myBuilder.addSoftware(this.myDeviceData.software().getValue());
        this.myBuilder.setManufacturer((String)this.myDeviceData.manufacturer().get());
        IdDisplay tag = this.myDeviceData.deviceType().getValueOrNull();
        this.myBuilder.setTagId(SystemImage.DEFAULT_TAG.equals((Object)tag) || tag == null ? null : tag.getId());
        List<State> states = this.generateStates(new AvdHardwareData(this.myDeviceData).buildHardware());
        this.myBuilder.addAllState(states);
        Device device = this.myBuilder.build();
        if (device == null) {
            ConfigureDeviceModel.$$$reportNull$$$0(3);
        }
        return device;
    }

    private List<State> generateStates(Hardware hardware) {
        ArrayList states = Lists.newArrayListWithExpectedSize((int)4);
        if (((Boolean)this.myDeviceData.supportsPortrait().get()).booleanValue()) {
            states.add(ConfigureDeviceModel.createState(ScreenOrientation.PORTRAIT, hardware, false));
        }
        if (((Boolean)this.myDeviceData.supportsLandscape().get()).booleanValue()) {
            states.add(ConfigureDeviceModel.createState(ScreenOrientation.LANDSCAPE, hardware, false));
        }
        if (((Boolean)this.myDeviceData.hasHardwareKeyboard().get()).booleanValue()) {
            if (((Boolean)this.myDeviceData.supportsPortrait().get()).booleanValue()) {
                states.add(ConfigureDeviceModel.createState(ScreenOrientation.PORTRAIT, hardware, true));
            }
            if (((Boolean)this.myDeviceData.supportsLandscape().get()).booleanValue()) {
                states.add(ConfigureDeviceModel.createState(ScreenOrientation.LANDSCAPE, hardware, true));
            }
        }
        ((State)states.get(0)).setDefaultState(true);
        return states;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/ConfigureDeviceModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/ConfigureDeviceModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initBootProperties";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

