/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.avdmanager.EmulatorConnectionListener;
import com.android.tools.idea.avdmanager.EmulatorRunner;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.emulator.EmulatorSettings;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class AvdManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG);
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AvdManagerConnection.class);
    private static final AvdManagerConnection NULL_CONNECTION = new AvdManagerConnection(null);
    private static final int MNC_API_LEVEL_23 = 23;
    private static final int LMP_MR1_API_LEVEL_22 = 22;
    public static final String AVD_INI_HW_LCD_DENSITY = "hw.lcd.density";
    public static final Revision TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"25.0.0 rc1");
    public static final Revision TOOLS_REVISION_25_0_2_RC3 = Revision.parseRevision((String)"25.0.2 rc3");
    public static final Revision PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"23.1.0");
    protected static Revision EMULATOR_REVISION_SUPPORTS_STUDIO_PARAMS = Revision.parseRevision((String)"26.1.0");
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENCENCY_WITH_FIRST_QEMU2 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 2), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 2), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 6), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 10)};
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENCENCY_WITH_25_0_2_RC3 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 4), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 4), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 8), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 12)};
    private static final Map<File, AvdManagerConnection> ourCache = ContainerUtil.createWeakMap();
    private static long ourMemorySize = -1L;
    private static Function<AndroidSdkHandler, AvdManagerConnection> ourConnectionFactory = AvdManagerConnection::new;
    @Nullable
    private final AndroidSdkHandler mySdkHandler;
    @NotNull
    private final FileOp myFileOp;
    @NotNull
    private final ListeningExecutorService myEdtListeningExecutorService;
    @Nullable
    private AvdManager myAvdManager;

    @NotNull
    public static AvdManagerConnection getDefaultAvdManagerConnection() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        if (handler2.getLocation() == null) {
            AvdManagerConnection avdManagerConnection = NULL_CONNECTION;
            if (avdManagerConnection == null) {
                AvdManagerConnection.$$$reportNull$$$0(0);
            }
            return avdManagerConnection;
        }
        return AvdManagerConnection.getAvdManagerConnection(handler2);
    }

    @NotNull
    public static synchronized AvdManagerConnection getAvdManagerConnection(@NotNull AndroidSdkHandler handler2) {
        File sdkPath;
        if (handler2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(1);
        }
        if (!ourCache.containsKey(sdkPath = handler2.getLocation())) {
            ourCache.put(sdkPath, ourConnectionFactory.apply(handler2));
        }
        AvdManagerConnection avdManagerConnection = ourCache.get(sdkPath);
        if (avdManagerConnection == null) {
            AvdManagerConnection.$$$reportNull$$$0(2);
        }
        return avdManagerConnection;
    }

    private AvdManagerConnection(@Nullable AndroidSdkHandler sdkHandler) {
        this(sdkHandler, MoreExecutors.listeningDecorator((ExecutorService)EdtExecutorService.getInstance()));
    }

    @VisibleForTesting
    public AvdManagerConnection(@Nullable AndroidSdkHandler sdkHandler, @NotNull ListeningExecutorService edtListeningExecutorService) {
        if (edtListeningExecutorService == null) {
            AvdManagerConnection.$$$reportNull$$$0(3);
        }
        this.mySdkHandler = sdkHandler;
        this.myFileOp = sdkHandler == null ? FileOpUtils.create() : sdkHandler.getFileOp();
        this.myEdtListeningExecutorService = edtListeningExecutorService;
    }

    @VisibleForTesting
    protected static synchronized void setConnectionFactory(@NotNull Function<AndroidSdkHandler, AvdManagerConnection> factory2) {
        if (factory2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(4);
        }
        ourCache.clear();
        ourConnectionFactory = factory2;
    }

    private boolean initIfNecessary() {
        if (this.myAvdManager == null) {
            if (this.mySdkHandler == null) {
                IJ_LOG.warn("No Android SDK Found");
                return false;
            }
            try {
                this.myAvdManager = AvdManager.getInstance((AndroidSdkHandler)this.mySdkHandler, (File)new File(AndroidLocation.getAvdFolder()), (ILogger)SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not instantiate AVD Manager from SDK", (Throwable)e);
                return false;
            }
            if (this.myAvdManager == null) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public String getSdCardSizeFromHardwareProperties() {
        assert (this.mySdkHandler != null);
        return AvdWizardUtils.getHardwarePropertyDefaultValue("sdcard.size", this.mySdkHandler);
    }

    @Nullable
    public String getInternalStorageSizeFromHardwareProperties() {
        assert (this.mySdkHandler != null);
        return AvdWizardUtils.getHardwarePropertyDefaultValue("disk.dataPartition.size", this.mySdkHandler);
    }

    @Nullable
    private File getBinaryLocation(String filename) {
        assert (this.mySdkHandler != null);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", REPO_LOG);
        if (sdkPackage == null) {
            return null;
        }
        File binaryFile = new File(sdkPackage.getLocation(), filename);
        if (!this.myFileOp.exists(binaryFile)) {
            return null;
        }
        return binaryFile;
    }

    @Nullable
    public File getEmulatorBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR);
    }

    @Nullable
    public File getEmulatorCheckBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR_CHECK);
    }

    @Nullable
    private SystemImageUpdateDependency[] getSystemImageUpdateDependencies() {
        assert (this.mySdkHandler != null);
        LocalPackage info2 = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("emulator");
        if (info2 == null) {
            return null;
        }
        if (info2.getVersion().compareTo(TOOLS_REVISION_25_0_2_RC3) >= 0) {
            return SYSTEM_IMAGE_DEPENCENCY_WITH_25_0_2_RC3;
        }
        if (info2.getVersion().compareTo(TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0) {
            return SYSTEM_IMAGE_DEPENCENCY_WITH_FIRST_QEMU2;
        }
        return null;
    }

    private boolean hasQEMU2Installed() {
        return this.getSystemImageUpdateDependencies() != null;
    }

    private boolean hasPlatformToolsForQEMU2Installed() {
        assert (this.mySdkHandler != null);
        LocalPackage info2 = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("platform-tools");
        if (info2 == null) {
            return false;
        }
        return info2.getVersion().compareTo(PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0;
    }

    private boolean hasSystemImagesForQEMU2Installed() {
        return this.getSystemImageUpdates().isEmpty();
    }

    @NotNull
    public List<String> getSystemImageUpdates() {
        ArrayList<String> requested = new ArrayList<String>();
        SystemImageUpdateDependency[] dependencies2 = this.getSystemImageUpdateDependencies();
        if (dependencies2 == null) {
            ArrayList<String> arrayList = requested;
            if (arrayList == null) {
                AvdManagerConnection.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        assert (this.mySdkHandler != null);
        block0: for (SystemImage systemImage : this.mySdkHandler.getSystemImageManager(REPO_LOG).getImages()) {
            for (SystemImageUpdateDependency dependency : dependencies2) {
                if (!dependency.updateRequired(systemImage)) continue;
                requested.add(systemImage.getPackage().getPath());
                continue block0;
            }
        }
        ArrayList<String> arrayList = requested;
        if (arrayList == null) {
            AvdManagerConnection.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<AvdInfo> getAvds(boolean forceRefresh) {
        if (!this.initIfNecessary()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                AvdManagerConnection.$$$reportNull$$$0(7);
            }
            return immutableList;
        }
        if (forceRefresh) {
            try {
                this.myAvdManager.reloadAvds(SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not find Android SDK!", (Throwable)e);
            }
        }
        ArrayList avdInfos = Lists.newArrayList((Object[])this.myAvdManager.getAllAvds());
        boolean needsRefresh = false;
        for (AvdInfo info2 : avdInfos) {
            if (info2.getStatus() != AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED) continue;
            this.updateDeviceChanged(info2);
            needsRefresh = true;
        }
        if (needsRefresh) {
            List<AvdInfo> list = this.getAvds(true);
            if (list == null) {
                AvdManagerConnection.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList arrayList = avdInfos;
        if (arrayList == null) {
            AvdManagerConnection.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public boolean deleteAvd(@NotNull String avdName) {
        if (avdName == null) {
            AvdManagerConnection.$$$reportNull$$$0(10);
        }
        if (!this.initIfNecessary()) {
            return false;
        }
        AvdInfo info2 = this.myAvdManager.getAvd(avdName, false);
        if (info2 == null) {
            return false;
        }
        return this.deleteAvd(info2);
    }

    public boolean deleteAvd(@NotNull AvdInfo info2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(11);
        }
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.myAvdManager.deleteAvd(info2, SDK_LOG);
    }

    public boolean isAvdRunning(@NotNull AvdInfo info2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(12);
        }
        return this.myAvdManager.isAvdRunning(info2, SDK_LOG);
    }

    public void stopAvd(@NotNull AvdInfo info2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(13);
        }
        this.myAvdManager.stopAvd(info2);
    }

    @NotNull
    public ListenableFuture<IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(14);
        }
        ListenableFuture<IDevice> listenableFuture = this.startAvd(project, info2, Collections.emptyList());
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(15);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info2, @NotNull List<String> parameters2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(16);
        }
        if (parameters2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(17);
        }
        return this.startAvd(project, info2, false, parameters2);
    }

    @NotNull
    ListenableFuture<IDevice> startAvdWithColdBoot(@Nullable Project project, @NotNull AvdInfo info2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(18);
        }
        return this.startAvd(project, info2, true, Collections.emptyList());
    }

    @NotNull
    private ListenableFuture<IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info2, boolean forceColdBoot, @NotNull List<String> parameters2) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(19);
        }
        if (parameters2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(20);
        }
        if (!this.initIfNecessary()) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException("No Android SDK Found"));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(21);
            }
            return listenableFuture;
        }
        String skinPath = (String)info2.getProperties().get("skin.path");
        if (skinPath != null) {
            File skinFile = new File(skinPath);
            File baseSkinFile = new File(skinFile.getName());
            AvdWizardUtils.pathToUpdatedSkins(baseSkinFile, null, this.myFileOp);
        }
        ListenableFuture listenableFuture = Futures.transformAsync(this.checkAccelerationAsync(), code -> this.continueToStartAvdIfAccelerationErrorIsNotBlocking((AccelerationErrorCode)((Object)code), project, info2, forceColdBoot, parameters2), (Executor)MoreExecutors.directExecutor());
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(22);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<IDevice> continueToStartAvdIfAccelerationErrorIsNotBlocking(@NotNull AccelerationErrorCode code, @Nullable Project project, @NotNull AvdInfo info2, boolean forceColdBoot, @NotNull List<String> parameters2) {
        if (code == null) {
            AvdManagerConnection.$$$reportNull$$$0(23);
        }
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(24);
        }
        if (parameters2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(25);
        }
        switch (code) {
            case ALREADY_INSTALLED: {
                return this.continueToStartAvd(project, info2, forceColdBoot, parameters2);
            }
            case TOOLS_UPDATE_REQUIRED: 
            case PLATFORM_TOOLS_UPDATE_ADVISED: 
            case SYSTEM_IMAGE_UPDATE_ADVISED: {
                return this.continueToStartAvd(project, info2, forceColdBoot, parameters2);
            }
            case NO_EMULATOR_INSTALLED: {
                return this.handleAccelerationError(project, info2, code);
            }
        }
        Abi abi = Abi.getEnum((String)info2.getAbiType());
        if (abi == null) {
            return this.continueToStartAvd(project, info2, forceColdBoot, parameters2);
        }
        if (abi.equals((Object)Abi.X86) || abi.equals((Object)Abi.X86_64)) {
            return this.handleAccelerationError(project, info2, code);
        }
        return this.continueToStartAvd(project, info2, forceColdBoot, parameters2);
    }

    @NotNull
    private ListenableFuture<IDevice> continueToStartAvd(@Nullable Project project, @NotNull AvdInfo avd, boolean forceColdBoot, @NotNull List<String> parameters2) {
        ProcessHandler processHandler;
        File emulatorBinary;
        if (avd == null) {
            AvdManagerConnection.$$$reportNull$$$0(26);
        }
        if (parameters2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(27);
        }
        if ((emulatorBinary = this.getEmulatorBinary()) == null) {
            IJ_LOG.error("No emulator binary found!");
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException("No emulator binary found"));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(28);
            }
            return listenableFuture;
        }
        avd = this.reloadAvd(avd);
        String avdName = avd.getName();
        if (this.myAvdManager.isAvdRunning(avd, SDK_LOG)) {
            String baseFolder;
            this.myAvdManager.logRunningAvdInfo(avd, SDK_LOG);
            try {
                baseFolder = this.myAvdManager.getBaseAvdFolder().getAbsolutePath();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                baseFolder = "$HOME";
            }
            String message2 = String.format("AVD %1$s is already running.\nIf that is not the case, delete the files at\n   %2$s/%1$s.avd/*.lock\nand try again.", avdName, baseFolder);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(message2));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(29);
            }
            return listenableFuture;
        }
        GeneralCommandLine commandLine = this.newEmulatorCommand(project, emulatorBinary, avd, forceColdBoot, parameters2);
        EmulatorRunner runner = new EmulatorRunner(commandLine, avd);
        this.addListeners(runner);
        try {
            processHandler = runner.start();
        }
        catch (ExecutionException e) {
            IJ_LOG.error("Error launching emulator", (Throwable)e);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(String.format("Error launching emulator %1$s ", avdName), e));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(30);
            }
            return listenableFuture;
        }
        AvdManagerConnection.notifyIfLaunchedStandalone(project, avd);
        BackgroundableProcessIndicator p = this.hasQEMU2Installed() ? new BackgroundableProcessIndicator(project, "Launching Emulator", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false) : new ProgressWindow(false, true, project);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> AvdManagerConnection.lambda$continueToStartAvd$1((ProgressWindow)p, processHandler));
        MessageBus messageBus = project != null ? project.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
        ((AvdLaunchListener)messageBus.syncPublisher(AvdLaunchListener.TOPIC)).avdLaunched(avd, commandLine, project);
        ListenableFuture<IDevice> listenableFuture = EmulatorConnectionListener.getDeviceForEmulator(project, avd.getName(), processHandler, 5L, TimeUnit.MINUTES);
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(31);
        }
        return listenableFuture;
    }

    @NotNull
    GeneralCommandLine newEmulatorCommand(@Nullable Project project, @NotNull File emulator, @NotNull AvdInfo device, boolean forceColdBoot, @NotNull List<String> parameters2) {
        if (emulator == null) {
            AvdManagerConnection.$$$reportNull$$$0(32);
        }
        if (device == null) {
            AvdManagerConnection.$$$reportNull$$$0(33);
        }
        if (parameters2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(34);
        }
        GeneralCommandLine command = new GeneralCommandLine();
        command.setExePath(emulator.getPath());
        command.setWorkDirectory(emulator.getParentFile());
        this.addParameters(project, device, forceColdBoot, command);
        String arguments = System.getenv("studio.emu.params");
        if (arguments != null) {
            command.addParameters(Splitter.on((char)',').splitToList((CharSequence)arguments));
        }
        command.addParameters(parameters2);
        GeneralCommandLine generalCommandLine = command;
        if (generalCommandLine == null) {
            AvdManagerConnection.$$$reportNull$$$0(35);
        }
        return generalCommandLine;
    }

    private static void notifyIfLaunchedStandalone(@Nullable Project project, @NotNull AvdInfo avd) {
        boolean show;
        if (avd == null) {
            AvdManagerConnection.$$$reportNull$$$0(36);
        }
        if (project == null || !AvdManagerConnection.isEmulatorToolWindowAvailable(project) || AvdManagerConnection.shouldBeLaunchedEmbedded(project, avd)) {
            return;
        }
        EmulatorSettings settings = EmulatorSettings.getInstance();
        boolean foldable = AvdManagerConnection.isFoldable(avd);
        boolean bl = show = foldable ? settings.getShowLaunchedStandaloneNotificationForFoldable() : settings.getShowLaunchedStandaloneNotification();
        if (!show) {
            return;
        }
        String reason = foldable ? "to support folding" : "to be able to use extended controls";
        String text2 = avd.getDisplayName() + " was launched standalone " + reason;
        AndroidNotification.getInstance(project).showBalloon("AVD Launched Standalone", text2, NotificationType.INFORMATION);
        if (foldable) {
            settings.setShowLaunchedStandaloneNotificationForFoldable(false);
        } else {
            settings.setShowLaunchedStandaloneNotification(false);
        }
    }

    protected void addListeners(@NotNull EmulatorRunner runner) {
        if (runner == null) {
            AvdManagerConnection.$$$reportNull$$$0(37);
        }
    }

    protected void addParameters(@Nullable Project project, @NotNull AvdInfo info2, boolean forceColdBoot, @NotNull GeneralCommandLine commandLine) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(38);
        }
        if (commandLine == null) {
            AvdManagerConnection.$$$reportNull$$$0(39);
        }
        Map properties2 = info2.getProperties();
        String netDelay = (String)properties2.get("runtime.network.latency");
        String netSpeed = (String)properties2.get("runtime.network.speed");
        if (netDelay != null) {
            commandLine.addParameters(new String[]{"-netdelay", netDelay});
        }
        if (netSpeed != null) {
            commandLine.addParameters(new String[]{"-netspeed", netSpeed});
        }
        if (EmulatorAdvFeatures.emulatorSupportsFastBoot(this.mySdkHandler, (ProgressIndicator)new StudioLoggerProgressIndicator(AvdManagerConnection.class), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class)))) {
            if ("yes".equals(properties2.get("fastboot.forceColdBoot"))) {
                commandLine.addParameter("-no-snapstorage");
            } else if (forceColdBoot) {
                commandLine.addParameter("-no-snapshot-load");
            } else if ("yes".equals(properties2.get("fastboot.forceChosenSnapshotBoot"))) {
                commandLine.addParameters(new String[]{"-snapshot", StringUtil.notNullize((String)((String)properties2.get("fastboot.chosenSnapshotFile")))});
                commandLine.addParameter("-no-snapshot-save");
            }
        }
        this.writeParameterFile(commandLine);
        commandLine.addParameters(new String[]{"-avd", info2.getName()});
        if (AvdManagerConnection.shouldBeLaunchedEmbedded(project, info2)) {
            commandLine.addParameters(new String[]{"-qt-hide-window", "-grpc-use-token", "-idle-grpc-timeout", "300"});
        }
    }

    private static boolean shouldBeLaunchedEmbedded(@Nullable Project project, @NotNull AvdInfo avd) {
        if (avd == null) {
            AvdManagerConnection.$$$reportNull$$$0(40);
        }
        return AvdManagerConnection.isEmulatorToolWindowAvailable(project) && !AvdManagerConnection.isFoldable(avd) && !"android-tv".equals(avd.getProperty("tag.id")) && !"android-automotive".equals(avd.getProperty("tag.id"));
    }

    private static boolean isEmulatorToolWindowAvailable(@Nullable Project project) {
        return EmulatorSettings.getInstance().getLaunchInToolWindow() && project != null && ToolWindowManager.getInstance((Project)project).getToolWindow("Android Emulator") != null;
    }

    public static boolean isFoldable(@NotNull AvdInfo avd) {
        String displayRegionWidth;
        if (avd == null) {
            AvdManagerConnection.$$$reportNull$$$0(41);
        }
        return (displayRegionWidth = avd.getProperty("hw.displayRegion.0.1.width")) != null && !"0".equals(displayRegionWidth);
    }

    public boolean emulatorVersionIsAtLeast(@NotNull Revision desired) {
        if (desired == null) {
            AvdManagerConnection.$$$reportNull$$$0(42);
        }
        if (this.mySdkHandler == null) {
            return false;
        }
        StudioLoggerProgressIndicator log = new StudioLoggerProgressIndicator(AvdWizardUtils.class);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", (ProgressIndicator)log);
        if (sdkPackage == null) {
            return false;
        }
        return sdkPackage.getVersion().compareTo(desired) >= 0;
    }

    protected void writeParameterFile(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            AvdManagerConnection.$$$reportNull$$$0(43);
        }
        if (!this.emulatorVersionIsAtLeast(EMULATOR_REVISION_SUPPORTS_STUDIO_PARAMS)) {
            return;
        }
        HttpConfigurable httpInstance = HttpConfigurable.getInstance();
        if (httpInstance == null) {
            return;
        }
        ArrayList<String> proxyParameters = new ArrayList<String>();
        List myPropList = httpInstance.getJvmProperties(false, null);
        for (Pair kv : myPropList) {
            switch ((String)kv.getFirst()) {
                case "http.proxyHost": 
                case "http.proxyPort": 
                case "https.proxyHost": 
                case "https.proxyPort": 
                case "proxy.authentication.username": 
                case "proxy.authentication.password": {
                    proxyParameters.add((String)kv.getFirst() + "=" + (String)kv.getSecond() + "\n");
                    break;
                }
            }
        }
        if (proxyParameters.isEmpty()) {
            return;
        }
        File tempFile = AvdManagerConnection.writeTempFile(proxyParameters);
        if (tempFile != null) {
            commandLine.addParameters(new String[]{"-studio-params", tempFile.getAbsolutePath()});
        }
    }

    @Nullable
    public static File tempFileDirectory() {
        String androidSdkRootValue = System.getenv("ANDROID_SDK_ROOT");
        if (androidSdkRootValue == null) {
            androidSdkRootValue = System.getProperty("user.home");
        }
        File tempDir = new File(androidSdkRootValue, "temp");
        tempDir.mkdirs();
        if (!tempDir.exists()) {
            return null;
        }
        return tempDir;
    }

    @Nullable
    public static File writeTempFile(@NotNull List<String> fileContents) {
        File tempFile;
        block5: {
            if (fileContents == null) {
                AvdManagerConnection.$$$reportNull$$$0(44);
            }
            tempFile = null;
            try {
                File tempDir = AvdManagerConnection.tempFileDirectory();
                if (tempDir == null) {
                    return null;
                }
                tempFile = FileUtil.createTempFile((File)tempDir, (String)"emu", (String)".tmp", (boolean)true);
                tempFile.deleteOnExit();
                if (!tempFile.setReadable(false, false) || !tempFile.setReadable(true, true)) {
                    IJ_LOG.warn("Error setting permissions for " + tempFile.getAbsolutePath());
                }
                Files.write(tempFile.toPath(), fileContents, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                if (tempFile == null) break block5;
                tempFile.delete();
                tempFile = null;
            }
        }
        return tempFile;
    }

    @NotNull
    private ListenableFuture<IDevice> handleAccelerationError(@Nullable Project project, @NotNull AvdInfo info2, @NotNull AccelerationErrorCode code) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(45);
        }
        if (code == null) {
            AvdManagerConnection.$$$reportNull$$$0(46);
        }
        if (code.getSolution().equals((Object)AccelerationErrorSolution.SolutionCode.NONE)) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException("Could not start AVD"));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(47);
            }
            return listenableFuture;
        }
        ListenableFuture listenableFuture = Futures.transformAsync(this.showAccelerationErrorDialog(code, project), result2 -> this.tryFixingAccelerationError((int)result2, project, info2, code), (Executor)MoreExecutors.directExecutor());
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(48);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<Integer> showAccelerationErrorDialog(@NotNull AccelerationErrorCode code, @Nullable Project project) {
        if (code == null) {
            AvdManagerConnection.$$$reportNull$$$0(49);
        }
        ListenableFuture listenableFuture = this.myEdtListeningExecutorService.submit(() -> {
            String message2 = (SystemInfo.isLinux ? "KVM" : "Intel HAXM") + " is required to run this AVD.\n" + code.getProblem() + "\n\n" + code.getSolutionMessage() + "\n";
            return Messages.showOkCancelDialog((Project)project, (String)message2, (String)code.getSolution().getDescription(), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)AllIcons.General.WarningDialog);
        });
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(50);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<IDevice> tryFixingAccelerationError(int result2, @Nullable Project project, @NotNull AvdInfo info2, @NotNull AccelerationErrorCode code) {
        if (info2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(51);
        }
        if (code == null) {
            AvdManagerConnection.$$$reportNull$$$0(52);
        }
        if (result2 == 2) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException("Could not start AVD"));
            if (listenableFuture == null) {
                AvdManagerConnection.$$$reportNull$$$0(53);
            }
            return listenableFuture;
        }
        SettableFuture future2 = SettableFuture.create();
        Runnable setFuture = () -> future2.setFuture(this.startAvd(project, info2));
        Runnable setException = () -> future2.setException((Throwable)new RuntimeException("Retry after fixing problem by hand"));
        ApplicationManager.getApplication().invokeLater(AccelerationErrorSolution.getActionForFix(code, project, setFuture, setException));
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(54);
        }
        return settableFuture;
    }

    public AccelerationErrorCode checkAcceleration() {
        int exitValue;
        if (!this.initIfNecessary()) {
            return AccelerationErrorCode.UNKNOWN_ERROR;
        }
        File emulatorBinary = this.getEmulatorBinary();
        if (emulatorBinary == null) {
            return AccelerationErrorCode.NO_EMULATOR_INSTALLED;
        }
        if (AvdManagerConnection.getMemorySize() < Storage.Unit.GiB.getNumberOfBytes()) {
            return AccelerationErrorCode.NOT_ENOUGH_MEMORY;
        }
        if (!this.hasQEMU2Installed()) {
            return AccelerationErrorCode.TOOLS_UPDATE_REQUIRED;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        File checkBinary = this.getEmulatorCheckBinary();
        if (checkBinary != null) {
            commandLine.setExePath(checkBinary.getPath());
            commandLine.addParameter("accel");
        } else {
            commandLine.setExePath(emulatorBinary.getPath());
            commandLine.addParameter("-accel-check");
        }
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            ProcessOutput output = process.runProcess();
            exitValue = output.getExitCode();
        }
        catch (ExecutionException e) {
            exitValue = AccelerationErrorCode.UNKNOWN_ERROR.getErrorCode();
        }
        if (exitValue != 0) {
            return AccelerationErrorCode.fromExitCode(exitValue);
        }
        if (!this.hasPlatformToolsForQEMU2Installed()) {
            return AccelerationErrorCode.PLATFORM_TOOLS_UPDATE_ADVISED;
        }
        if (!this.hasSystemImagesForQEMU2Installed()) {
            return AccelerationErrorCode.SYSTEM_IMAGE_UPDATE_ADVISED;
        }
        return AccelerationErrorCode.ALREADY_INSTALLED;
    }

    @NotNull
    public ListenableFuture<AccelerationErrorCode> checkAccelerationAsync() {
        ListenableFuture listenableFuture = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE).submit(this::checkAcceleration);
        if (listenableFuture == null) {
            AvdManagerConnection.$$$reportNull$$$0(55);
        }
        return listenableFuture;
    }

    @Nullable
    public AvdInfo createOrUpdateAvd(@Nullable AvdInfo currentInfo, @NotNull String avdName, @NotNull Device device, @NotNull SystemImageDescription systemImageDescription, @NotNull ScreenOrientation orientation, boolean isCircular, @Nullable String sdCard, @Nullable File skinFolder, @NotNull Map<String, String> hardwareProperties, boolean removePrevious) {
        boolean success2;
        File avdFolder;
        if (avdName == null) {
            AvdManagerConnection.$$$reportNull$$$0(56);
        }
        if (device == null) {
            AvdManagerConnection.$$$reportNull$$$0(57);
        }
        if (systemImageDescription == null) {
            AvdManagerConnection.$$$reportNull$$$0(58);
        }
        if (orientation == null) {
            AvdManagerConnection.$$$reportNull$$$0(59);
        }
        if (hardwareProperties == null) {
            AvdManagerConnection.$$$reportNull$$$0(60);
        }
        if (!this.initIfNecessary()) {
            return null;
        }
        try {
            avdFolder = currentInfo != null ? new File(currentInfo.getDataFolderPath()) : AvdInfo.getDefaultAvdFolder((AvdManager)this.myAvdManager, (String)avdName, (FileOp)this.myFileOp, (boolean)true);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            IJ_LOG.error("Could not create AVD " + avdName, (Throwable)e);
            return null;
        }
        Dimension resolution = device.getScreenSize(orientation);
        assert (resolution != null);
        String skinName = null;
        if (skinFolder == null && isCircular) {
            skinFolder = AvdManagerConnection.getRoundSkin(systemImageDescription);
        }
        if (FileUtil.filesEqual((File)skinFolder, (File)AvdWizardUtils.NO_SKIN)) {
            skinFolder = null;
        }
        if (skinFolder == null) {
            skinName = String.format(Locale.US, "%dx%d", Math.round(resolution.getWidth()), Math.round(resolution.getHeight()));
        }
        if (orientation == ScreenOrientation.LANDSCAPE) {
            hardwareProperties.put("hw.initialOrientation", StringUtil.toLowerCase((String)ScreenOrientation.LANDSCAPE.getShortDisplayValue()));
        }
        if (device.getId().equals("13.5in Freeform")) {
            hardwareProperties.put("display.settings.xml", "freeform");
        }
        if (device.getId().equals("7.3in Foldable")) {
            hardwareProperties.put("hw.sensor.hinge", "yes");
            hardwareProperties.put("hw.sensor.hinge.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "1");
            hardwareProperties.put("hw.sensor.hinge.sub_type", "1");
            hardwareProperties.put("hw.sensor.hinge.ranges", "0-180");
            hardwareProperties.put("hw.sensor.hinge.defaults", "180");
            hardwareProperties.put("hw.sensor.hinge.areas", "884-0-1-2208");
            hardwareProperties.put("hw.sensor.posture_list", "1,2,3");
            hardwareProperties.put("hw.sensor.hinge_angles_posture_definitions", "0-30, 30-150, 150-180");
        }
        if (device.getId().equals("8in Foldable")) {
            hardwareProperties.put("hw.sensor.hinge", "yes");
            hardwareProperties.put("hw.sensor.hinge.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "1");
            hardwareProperties.put("hw.sensor.hinge.sub_type", "1");
            hardwareProperties.put("hw.sensor.hinge.ranges", "180-360");
            hardwareProperties.put("hw.sensor.hinge.defaults", "180");
            hardwareProperties.put("hw.sensor.hinge.areas", "1148-0-1-2480");
            hardwareProperties.put("hw.sensor.hinge.fold_to_displayRegion.0.1_at_posture", "4");
            hardwareProperties.put("hw.sensor.posture_list", "3, 4");
            hardwareProperties.put("hw.sensor.hinge_angles_posture_definitions", "180-330, 330-360");
        }
        if (device.getId().equals("6.7in Foldable")) {
            hardwareProperties.put("hw.sensor.hinge", "yes");
            hardwareProperties.put("hw.sensor.hinge.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "0");
            hardwareProperties.put("hw.sensor.hinge.sub_type", "1");
            hardwareProperties.put("hw.sensor.hinge.ranges", "0-180");
            hardwareProperties.put("hw.sensor.hinge.defaults", "180");
            hardwareProperties.put("hw.sensor.hinge.areas", "0-1318-1080-1");
            hardwareProperties.put("hw.sensor.posture_list", "1, 2, 3");
            hardwareProperties.put("hw.sensor.hinge_angles_posture_definitions", "0-30, 30-150, 150-180");
        }
        if (currentInfo != null && !avdName.equals(currentInfo.getName()) && removePrevious && !(success2 = this.myAvdManager.moveAvd(currentInfo, avdName, currentInfo.getDataFolderPath(), SDK_LOG))) {
            return null;
        }
        return this.myAvdManager.createAvd(avdFolder, avdName, systemImageDescription.getSystemImage(), skinFolder, skinName, sdCard, hardwareProperties, device.getBootProps(), device.hasPlayStore(), false, removePrevious, SDK_LOG);
    }

    @Nullable
    private static File getRoundSkin(SystemImageDescription systemImageDescription) {
        File[] skins;
        for (File skin : skins = systemImageDescription.getSkins()) {
            if (!skin.getName().contains("Round")) continue;
            return skin;
        }
        return null;
    }

    public static boolean doesSystemImageSupportQemu2(@Nullable SystemImageDescription description2, @NotNull FileOp fileOp) {
        if (fileOp == null) {
            AvdManagerConnection.$$$reportNull$$$0(61);
        }
        if (description2 == null) {
            return false;
        }
        ISystemImage systemImage = description2.getSystemImage();
        if (systemImage == null) {
            return false;
        }
        File location = systemImage.getLocation();
        if (!fileOp.isDirectory(location)) {
            return false;
        }
        String[] files2 = fileOp.list(location, null);
        if (files2 != null) {
            for (String filename : files2) {
                if (!filename.startsWith("kernel-ranchu")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean avdExists(String candidate) {
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.myAvdManager.getAvd(candidate, false) != null;
    }

    static boolean isAvdRepairable(@NotNull AvdInfo.AvdStatus avdStatus) {
        if (avdStatus == null) {
            AvdManagerConnection.$$$reportNull$$$0(62);
        }
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_MISSING || avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_MISSING;
    }

    public static boolean isSystemImageDownloadProblem(@NotNull AvdInfo.AvdStatus status) {
        if (status == null) {
            AvdManagerConnection.$$$reportNull$$$0(63);
        }
        switch (status) {
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AvdInfo reloadAvd(@NotNull String avdId) {
        if (avdId == null) {
            AvdManagerConnection.$$$reportNull$$$0(64);
        }
        if (this.initIfNecessary()) {
            assert (this.myAvdManager != null);
            AvdInfo avd = this.myAvdManager.getAvd(avdId, false);
            if (avd != null) {
                return this.reloadAvd(avd);
            }
        }
        return null;
    }

    @NotNull
    private AvdInfo reloadAvd(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(65);
        }
        AvdInfo avdInfo2 = this.myAvdManager.reloadAvd(avdInfo, SDK_LOG);
        if (avdInfo2 == null) {
            AvdManagerConnection.$$$reportNull$$$0(66);
        }
        return avdInfo2;
    }

    @Nullable
    public static String getRequiredSystemImagePath(@NotNull AvdInfo avdInfo) {
        String imageSystemDir;
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(67);
        }
        if ((imageSystemDir = (String)avdInfo.getProperties().get("image.sysdir.1")) == null) {
            return null;
        }
        return StringUtil.trimEnd((String)imageSystemDir.replace(File.separatorChar, ';'), (char)';');
    }

    public boolean updateDeviceChanged(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(68);
        }
        if (this.initIfNecessary()) {
            try {
                return this.myAvdManager.updateDeviceChanged(avdInfo, SDK_LOG) != null;
            }
            catch (IOException e) {
                IJ_LOG.warn("Could not update AVD Device " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean wipeUserData(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdManagerConnection.$$$reportNull$$$0(69);
        }
        if (!this.initIfNecessary()) {
            return false;
        }
        File userdataImage = new File(avdInfo.getDataFolderPath(), "userdata-qemu.img");
        if (this.myFileOp.exists(userdataImage) && !this.myFileOp.delete(userdataImage)) {
            return false;
        }
        File snapshotDirectory = new File(avdInfo.getDataFolderPath(), "snapshots");
        this.myFileOp.deleteFileOrFolder(snapshotDirectory);
        return true;
    }

    public String uniquifyDisplayName(@NotNull String name) {
        if (name == null) {
            AvdManagerConnection.$$$reportNull$$$0(70);
        }
        int suffix = 1;
        String result2 = name;
        while (this.findAvdWithDisplayName(result2)) {
            result2 = String.format(Locale.US, "%1$s %2$d", name, ++suffix);
        }
        return result2;
    }

    public boolean findAvdWithDisplayName(@NotNull String name) {
        if (name == null) {
            AvdManagerConnection.$$$reportNull$$$0(71);
        }
        for (AvdInfo avd : this.getAvds(false)) {
            if (!avd.getDisplayName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static long getMemorySize() {
        if (ourMemorySize < 0L) {
            ourMemorySize = AvdManagerConnection.checkMemorySize();
        }
        return ourMemorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result2 = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result2 instanceof Number) {
                return ((Number)result2).longValue();
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException oracleSpecificMXBean) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            IJ_LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$continueToStartAvd$1(ProgressWindow p, ProcessHandler processHandler) {
        try {
            p.start();
            p.setText("Starting AVD...");
            for (double d = 0.0; d < 1.0; d += 0.0125) {
                p.setFraction(d);
                Thread.sleep(100L);
                if (!processHandler.isProcessTerminated()) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            p.stop();
            p.processFinish();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/AvdManagerConnection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtListeningExecutorService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 10: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 38: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 23: 
            case 46: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 26: 
            case 36: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avd";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emulator";
                break;
            }
            case 33: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desired";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemImageDescription";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardwareProperties";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOp";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdStatus";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdId";
                break;
            }
            case 65: 
            case 67: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfo";
                break;
            }
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAvdManagerConnection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/AvdManagerConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvdManagerConnection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemImageUpdates";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvds";
                break;
            }
            case 15: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "startAvd";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "continueToStartAvd";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newEmulatorCommand";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "handleAccelerationError";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "showAccelerationErrorDialog";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFixingAccelerationError";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAccelerationAsync";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAvd";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAvdManagerConnection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setConnectionFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteAvd";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvdRunning";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stopAvd";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startAvd";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startAvdWithColdBoot";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "continueToStartAvdIfAccelerationErrorIsNotBlocking";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "continueToStartAvd";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newEmulatorCommand";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notifyIfLaunchedStandalone";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeLaunchedEmbedded";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isFoldable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "emulatorVersionIsAtLeast";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "writeParameterFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "writeTempFile";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "handleAccelerationError";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "showAccelerationErrorDialog";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "tryFixingAccelerationError";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateAvd";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "doesSystemImageSupportQemu2";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isAvdRepairable";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isSystemImageDownloadProblem";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "reloadAvd";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredSystemImagePath";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "updateDeviceChanged";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "wipeUserData";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "uniquifyDisplayName";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findAvdWithDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SystemImageUpdateDependency {
        private final int myFeatureLevel;
        private final IdDisplay myTag;
        private final int myRequiredMajorRevision;

        SystemImageUpdateDependency(int featureLevel, @NotNull IdDisplay tag, int requiredMajorRevision) {
            if (tag == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(0);
            }
            this.myFeatureLevel = featureLevel;
            this.myTag = tag;
            this.myRequiredMajorRevision = requiredMajorRevision;
        }

        public boolean updateRequired(@NotNull SystemImage image) {
            if (image == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(1);
            }
            return this.updateRequired(image.getAbiType(), image.getAndroidVersion().getFeatureLevel(), image.getTag(), image.getRevision());
        }

        public boolean updateRequired(@NotNull String abiType, int featureLevel, @NotNull IdDisplay tag, @NotNull Revision revision) {
            Abi abi;
            if (abiType == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(2);
            }
            if (tag == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(3);
            }
            if (revision == null) {
                SystemImageUpdateDependency.$$$reportNull$$$0(4);
            }
            boolean isAvdIntel = (abi = Abi.getEnum((String)abiType)) == Abi.X86 || abi == Abi.X86_64;
            return isAvdIntel && featureLevel == this.myFeatureLevel && this.myTag.equals((Object)tag) && revision.getMajor() < this.myRequiredMajorRevision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "abiType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/avdmanager/AvdManagerConnection$SystemImageUpdateDependency";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateRequired";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

