/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.ui;

import com.android.tools.idea.appinspection.ide.analytics.AppInspectionAnalyticsTrackerService;
import com.android.tools.idea.appinspection.ide.model.AppInspectionBundle;
import com.android.tools.idea.appinspection.ide.ui.AppInspectionView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/appinspection/ide/ui/AppInspectionToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "appInspectionView", "Lcom/android/tools/idea/appinspection/ide/ui/AppInspectionView;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/appinspection/ide/ui/AppInspectionView;)V", "isWindowMinimizedBubbleShown", "", "wasVisible", "stateChanged", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.android.app-inspection.ide"})
public final class AppInspectionToolWindowManagerListener
implements ToolWindowManagerListener {
    private boolean isWindowMinimizedBubbleShown;
    private boolean wasVisible;
    private final Project project;
    private final AppInspectionView appInspectionView;

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Database Inspector");
        if (toolWindow == null) {
            return;
        }
        ToolWindow inspectionToolWindow = toolWindow;
        boolean visibilityChanged = inspectionToolWindow.isVisible() != this.wasVisible;
        this.wasVisible = inspectionToolWindow.isVisible();
        if (visibilityChanged) {
            if (inspectionToolWindow.isVisible()) {
                AppInspectionAnalyticsTrackerService.Companion.getInstance(this.project).trackToolWindowOpened();
            } else {
                AppInspectionAnalyticsTrackerService.Companion.getInstance(this.project).trackToolWindowHidden();
                if (!this.isWindowMinimizedBubbleShown && this.appInspectionView.isInspectionActive$intellij_android_app_inspection_ide()) {
                    this.isWindowMinimizedBubbleShown = true;
                    MessageType messageType = MessageType.INFO;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.INFO");
                    toolWindowManager.notifyByBalloon("Database Inspector", messageType, AppInspectionBundle.INSTANCE.message("inspection.is.running", new String[0]));
                }
            }
        }
    }

    public AppInspectionToolWindowManagerListener(@NotNull Project project, @NotNull AppInspectionView appInspectionView2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appInspectionView2, (String)"appInspectionView");
        this.project = project;
        this.appInspectionView = appInspectionView2;
    }
}

