/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.resolver;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.appinspection.ide.resolver.GradleScriptBuilder;
import com.android.tools.idea.appinspection.inspector.api.launch.ArtifactCoordinate;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader;", "", "taskManager", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManager;", "(Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManager;)V", "resolve", "", "Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader$DownloadResult;", "artifacts", "Lcom/android/tools/idea/appinspection/inspector/api/launch/ArtifactCoordinate;", "project", "Lcom/intellij/openapi/project/Project;", "writeGradleScriptToTempDirectory", "Ljava/io/File;", "content", "", "DownloadResult", "intellij.android.app-inspection.ide"})
public final class GradleArtifactDownloader {
    private final GradleTaskManager taskManager;

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final List<DownloadResult> resolve(@NotNull List<ArtifactCoordinate> artifacts, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleScriptBuilder scriptBuilder = new GradleScriptBuilder();
        Iterable $this$forEach$iv = artifacts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArtifactCoordinate it = (ArtifactCoordinate)element$iv;
            boolean bl = false;
            scriptBuilder.addArtifact(it.toString());
        }
        File scriptFile = this.writeGradleScriptToTempDirectory(scriptBuilder.build());
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"ExternalSystemTaskId.cre\u2026pe.EXECUTE_TASK, project)");
        ExternalSystemTaskId id = externalSystemTaskId;
        GradleExecutionSettings gradleExecutionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleExecutionSettings, (String)"GradleUtil.getOrCreateGr\u2026xecutionSettings(project)");
        GradleExecutionSettings settings = gradleExecutionSettings;
        boolean it = false;
        Map downloaded = new LinkedHashMap();
        this.taskManager.executeTasks(id, CollectionsKt.listOf((Object)"resolveArtifacts"), scriptFile.getPath(), settings, null, (ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(downloaded){
            final /* synthetic */ Map $downloaded;

            public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text2, boolean stdOut) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                if (stdOut && StringsKt.startsWith$default((String)text2, (String)"APP_INSPECTOR: ", (boolean)false, (int)2, null)) {
                    String string = text2;
                    int n = "APP_INSPECTOR: ".length();
                    boolean bl = false;
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    File file2 = new File(string2);
                    if (file2.exists()) {
                        String string3 = file2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
                        Path path2 = file2.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.toPath()");
                        this.$downloaded.put(string3, path2);
                    }
                }
            }
            {
                this.$downloaded = $captured_local_variable$0;
            }
        });
        Iterable $this$map$iv = artifacts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DownloadResult downloadResult;
            void artifact;
            ArtifactCoordinate artifactCoordinate = (ArtifactCoordinate)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if ((Path)downloaded.get(artifact.getFileName()) != null) {
                Path path2;
                boolean bl2 = false;
                boolean bl3 = false;
                Path jar = path2;
                boolean bl4 = false;
                downloadResult = new DownloadResult(DownloadResult.Status.SUCCESS, (ArtifactCoordinate)artifact, jar);
            } else {
                downloadResult = new DownloadResult(DownloadResult.Status.FAILURE, (ArtifactCoordinate)artifact, null);
            }
            DownloadResult downloadResult2 = downloadResult;
            collection2.add(downloadResult2);
        }
        return (List)destination$iv$iv;
    }

    private final File writeGradleScriptToTempDirectory(String content2) {
        String string = content2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] contentBytes = byArray;
        int contentLength = contentBytes.length;
        File file2 = FileUtil.findSequentFile((File)new File(FileUtil.getTempDirectory()), (String)"build", (String)"gradle", (Predicate)new Predicate(contentBytes, contentLength, content2){
            final /* synthetic */ byte[] $contentBytes;
            final /* synthetic */ int $contentLength;
            final /* synthetic */ String $content;

            public final boolean test(File file2) {
                boolean bl;
                try {
                    boolean bl2;
                    if (!file2.exists()) {
                        FileUtil.writeToFile((File)file2, (byte[])this.$contentBytes, (boolean)false);
                        file2.deleteOnExit();
                        bl2 = true;
                    } else {
                        bl2 = (long)this.$contentLength != file2.length() ? false : Intrinsics.areEqual((Object)this.$content, (Object)FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8));
                    }
                    bl = bl2;
                }
                catch (IOException ignore) {
                    bl = false;
                }
                return bl;
            }
            {
                this.$contentBytes = byArray;
                this.$contentLength = n;
                this.$content = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.findSequentFile\u2026      false\n      }\n    }");
        return file2;
    }

    public GradleArtifactDownloader(@NotNull GradleTaskManager taskManager) {
        Intrinsics.checkNotNullParameter((Object)taskManager, (String)"taskManager");
        this.taskManager = taskManager;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader$DownloadResult;", "", "status", "Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader$DownloadResult$Status;", "target", "Lcom/android/tools/idea/appinspection/inspector/api/launch/ArtifactCoordinate;", "artifactPath", "Ljava/nio/file/Path;", "(Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader$DownloadResult$Status;Lcom/android/tools/idea/appinspection/inspector/api/launch/ArtifactCoordinate;Ljava/nio/file/Path;)V", "getArtifactPath", "()Ljava/nio/file/Path;", "getStatus", "()Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader$DownloadResult$Status;", "getTarget", "()Lcom/android/tools/idea/appinspection/inspector/api/launch/ArtifactCoordinate;", "Status", "intellij.android.app-inspection.ide"})
    public static final class DownloadResult {
        @NotNull
        private final Status status;
        @NotNull
        private final ArtifactCoordinate target;
        @Nullable
        private final Path artifactPath;

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @NotNull
        public final ArtifactCoordinate getTarget() {
            return this.target;
        }

        @Nullable
        public final Path getArtifactPath() {
            return this.artifactPath;
        }

        public DownloadResult(@NotNull Status status, @NotNull ArtifactCoordinate target, @Nullable Path artifactPath) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.status = status;
            this.target = target;
            this.artifactPath = artifactPath;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/appinspection/ide/resolver/GradleArtifactDownloader$DownloadResult$Status;", "", "(Ljava/lang/String;I)V", "SUCCESS", "FAILURE", "intellij.android.app-inspection.ide"})
        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status SUCCESS;
            public static final /* enum */ Status FAILURE;
            private static final /* synthetic */ Status[] $VALUES;

            static {
                Status[] statusArray = new Status[2];
                Status[] statusArray2 = statusArray;
                statusArray[0] = SUCCESS = new Status();
                statusArray[1] = FAILURE = new Status();
                $VALUES = statusArray;
            }

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String string) {
                return Enum.valueOf(Status.class, string);
            }
        }
    }
}

