/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class PercentRenderer
extends ColoredTreeCellRenderer {
    private static final JBColor BAR_COLOR = new JBColor(new Color(16616764), new Color(15095053));
    private final PercentProvider myProvider;
    private Font myFont;
    private int myMaxPercentWidth;
    private double myFraction;

    public PercentRenderer(@NotNull PercentProvider provider2) {
        if (provider2 == null) {
            PercentRenderer.$$$reportNull$$$0(0);
        }
        this.myProvider = provider2;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            PercentRenderer.$$$reportNull$$$0(1);
        }
        this.myFraction = this.myProvider.getFraction(tree, value2, row);
        this.append(PercentRenderer.getPercent(this.myFraction), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    protected void doPaint(Graphics2D g) {
        Font font = this.getFont();
        if (font != this.myFont) {
            this.myFont = font;
            this.myMaxPercentWidth = this.getFontMetrics(font).stringWidth("888.8%");
        }
        String percent = PercentRenderer.getPercent(this.myFraction);
        int stringWidth = this.getFontMetrics(font).stringWidth(percent);
        this.doPaintText(g, this.myMaxPercentWidth - stringWidth, false);
        int xPadding = 5;
        int yPadding = 2;
        int offset2 = this.myMaxPercentWidth + xPadding;
        int width = (int)((double)(this.getWidth() - this.myMaxPercentWidth - xPadding * 2) * this.myFraction);
        Color color = g.getColor();
        g.setColor((Color)BAR_COLOR);
        g.fillRect(offset2, yPadding, width, this.getHeight() - yPadding * 2);
        g.setColor(color);
    }

    private static String getPercent(double fraction) {
        DecimalFormat formatter = new DecimalFormat("###.#");
        return String.format("%1$s%%", formatter.format(fraction * 100.0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/viewer/PercentRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface PercentProvider {
        public double getFraction(@NotNull JTree var1, @NotNull Object var2, int var3);
    }
}

