/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.TimedZipHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.Function;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkFileSystem
extends ArchiveFileSystem {
    public static final Set<String> EXTENSIONS = ImmutableSet.of((Object)"apk", (Object)"aar", (Object)"iapk", (Object)"zip", (Object)"aab");
    public static final String PROTOCOL = "apk";
    public static final String APK_SEPARATOR = "!/";
    private static final String APKZIP_EXT = "apkzip";
    private static final String APKZIP_SUFFIX = ".apkzip";
    private static final Key<Boolean> APKZIP_KEY = Key.create((String)"android.zip.within.apk");
    private final DiskQueryRelay<VirtualFile, FileAttributes> myAttrGetter = new DiskQueryRelay(x$0 -> super.getAttributes(x$0));
    private final DiskQueryRelay<VirtualFile, String[]> myChildrenGetter = new DiskQueryRelay(x$0 -> super.list(x$0));

    public static ApkFileSystem getInstance() {
        return (ApkFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ApkFileSystem.$$$reportNull$$$0(0);
        }
        return (FileAttributes)this.myAttrGetter.accessDiskWithCheckCanceled((Object)file2);
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ApkFileSystem.$$$reportNull$$$0(1);
        }
        String[] stringArray = (String[])this.myChildrenGetter.accessDiskWithCheckCanceled((Object)file2);
        if (stringArray == null) {
            ApkFileSystem.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            ApkFileSystem.$$$reportNull$$$0(3);
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)APK_SEPARATOR);
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            ApkFileSystem.$$$reportNull$$$0(5);
        }
        String string = localPath + APK_SEPARATOR;
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            ApkFileSystem.$$$reportNull$$$0(7);
        }
        ArchiveHandler archiveHandler = VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, (Function)(SystemInfo.isWindows ? TimedZipHandler::new : ZipHandler::new));
        if (archiveHandler == null) {
            ApkFileSystem.$$$reportNull$$$0(8);
        }
        return archiveHandler;
    }

    @NotNull
    public String getRelativePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ApkFileSystem.$$$reportNull$$$0(9);
        }
        String string = super.getRelativePath(file2);
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int apkSeparatorIndex;
        if (normalizedPath == null) {
            ApkFileSystem.$$$reportNull$$$0(11);
        }
        return (apkSeparatorIndex = normalizedPath.indexOf(APK_SEPARATOR)) > 0 ? normalizedPath.substring(0, apkSeparatorIndex + APK_SEPARATOR.length()) : "";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path2) {
        if (path2 == null) {
            ApkFileSystem.$$$reportNull$$$0(12);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path2);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path2) {
        if (path2 == null) {
            ApkFileSystem.$$$reportNull$$$0(13);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path2);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        if (path2 == null) {
            ApkFileSystem.$$$reportNull$$$0(14);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path2);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        byte[] bytes;
        if (file2 == null) {
            ApkFileSystem.$$$reportNull$$$0(15);
        }
        if (!this.isBinaryXml(file2, bytes = super.contentsToByteArray(file2))) {
            if (bytes == null) {
                ApkFileSystem.$$$reportNull$$$0(16);
            }
            return bytes;
        }
        byte[] byArray = BinaryXmlParser.decodeXml((String)file2.getName(), (byte[])bytes);
        if (byArray == null) {
            ApkFileSystem.$$$reportNull$$$0(17);
        }
        return byArray;
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            ApkFileSystem.$$$reportNull$$$0(18);
        }
        if (APKZIP_EXT.equals(local.getExtension()) && Boolean.TRUE.equals(local.getUserData(APKZIP_KEY))) {
            return true;
        }
        return EXTENSIONS.contains(local.getExtension());
    }

    @Nullable
    public VirtualFile extractAndGetContentRoot(VirtualFile file2) {
        File tempFile;
        try {
            tempFile = FileUtil.createTempFile((String)file2.getName(), (String)APKZIP_SUFFIX, (boolean)true);
        }
        catch (IOException e) {
            Logger.getInstance(ApkFileSystem.class).warn("IOException while extracting zip file from APK", (Throwable)e);
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(file2.contentsToByteArray());){
            Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.getInstance(ApkFileSystem.class).warn("IOException while copying contents of zip file to temp file", (Throwable)e);
            return null;
        }
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true);
        if (vfile == null) {
            return null;
        }
        vfile.putUserData(APKZIP_KEY, (Object)Boolean.TRUE);
        return ApkFileSystem.getInstance().getRootByLocal(vfile);
    }

    public boolean isBinaryXml(VirtualFile file2, byte[] bytes) {
        return ApkFileSystem.isBinaryXml(this.getRelativePath(file2), bytes);
    }

    public static boolean isBinaryXml(String relativePath, byte[] bytes) {
        boolean encodedXmlPath;
        if (!relativePath.endsWith(".xml")) {
            return false;
        }
        boolean bl = encodedXmlPath = relativePath.equals("AndroidManifest.xml") || relativePath.startsWith("res") && !relativePath.startsWith("res/raw");
        if (!encodedXmlPath) {
            return false;
        }
        short code = Shorts.fromBytes((byte)bytes[1], (byte)bytes[0]);
        return code == Chunk.Type.XML.code();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkFileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

