/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzeApkAction
extends DumbAwareAction {
    private static final String LAST_APK_PATH = "AnalyzeApkAction.lastApkPath";

    public AnalyzeApkAction() {
        super("Analyze APK...");
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AnalyzeApkAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            Logger.getInstance(AnalyzeApkAction.class).warn("Unable to obtain project from event");
            return;
        }
        e.getPresentation().setEnabledAndVisible(IdeInfo.getInstance().isAndroidStudio() || ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AnalyzeApkAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            Logger.getInstance(AnalyzeApkAction.class).warn("Unable to obtain project from event");
            return;
        }
        VirtualFile vf = AnalyzeApkAction.promptUserForApk(project);
        if (vf == null) {
            return;
        }
        OpenFileDescriptor fd = new OpenFileDescriptor(project, vf);
        FileEditorManager.getInstance((Project)project).openEditor(fd, true);
    }

    @Nullable
    private static VirtualFile promptUserForApk(Project project) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withDescription("Select APK to analyze").withFileFilter(file2 -> ApkFileSystem.EXTENSIONS.contains(file2.getExtension()));
        VirtualFile apk = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)AnalyzeApkAction.getLastSelectedApk(project));
        if (apk != null) {
            AnalyzeApkAction.saveLastSelectedApk(project, apk);
        }
        return apk;
    }

    @Nullable
    private static VirtualFile getLastSelectedApk(Project project) {
        File f;
        String lastApkPath = PropertiesComponent.getInstance((Project)project).getValue(LAST_APK_PATH);
        if (lastApkPath != null && (f = new File(lastApkPath)).exists()) {
            return VfsUtil.findFileByIoFile((File)f, (boolean)true);
        }
        return ProjectSystemUtil.getProjectSystem(project).getDefaultApkFile();
    }

    private static void saveLastSelectedApk(Project project, VirtualFile apk) {
        PropertiesComponent.getInstance((Project)project).setValue(LAST_APK_PATH, apk.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/android/tools/idea/apk/viewer/AnalyzeApkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

