/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;

public final class ApkDebugging {
    @NotNull
    public static final ProjectSystemId SYSTEM_ID = new ProjectSystemId("APK Import", "APK Project");
    @VisibleForTesting
    static final String APK_DEBUGGING_PROPERTY = "com.android.ide.apk.debugging";
    private static final boolean APK_DEBUGGING_ENABLED = SystemProperties.getBooleanProperty((String)"apk.importer.enabled", (boolean)false);

    private ApkDebugging() {
    }

    public static boolean isEnabled() {
        return true;
    }

    public static void markAsApkDebuggingProject(@NotNull Project project) {
        if (project == null) {
            ApkDebugging.$$$reportNull$$$0(0);
        }
        PropertiesComponent.getInstance((Project)project).setValue(APK_DEBUGGING_PROPERTY, true);
    }

    public static boolean isMarkedAsApkDebuggingProject(@NotNull Project project) {
        if (project == null) {
            ApkDebugging.$$$reportNull$$$0(1);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(APK_DEBUGGING_PROPERTY, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/apk/debugging/ApkDebugging";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsApkDebuggingProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkedAsApkDebuggingProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

