/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbDevicePairingModel;
import com.android.tools.idea.adb.wireless.AdbDevicePairingModelListener;
import com.android.tools.idea.adb.wireless.AdbDevicePairingService;
import com.android.tools.idea.adb.wireless.AdbDevicePairingView;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.PairingResult;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.QrCodeScanningController;
import com.android.tools.idea.adb.wireless.QrCodeScanningController$MyViewListener$WhenMappings;
import com.android.tools.idea.adb.wireless.ServiceType;
import com.android.tools.idea.adb.wireless.UIColors;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003'()B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0017H\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020\u0017R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/adb/wireless/QrCodeScanningController;", "Lcom/intellij/openapi/Disposable;", "service", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingService;", "view", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingView;", "edtExecutor", "Ljava/util/concurrent/Executor;", "parentDisposable", "(Lcom/android/tools/idea/adb/wireless/AdbDevicePairingService;Lcom/android/tools/idea/adb/wireless/AdbDevicePairingView;Ljava/util/concurrent/Executor;Lcom/intellij/openapi/Disposable;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "modelListener", "Lcom/android/tools/idea/adb/wireless/QrCodeScanningController$MyModelListener;", "pollingAlarm", "Lcom/intellij/util/Alarm;", "state", "Lcom/android/tools/idea/adb/wireless/QrCodeScanningController$State;", "viewListener", "Lcom/android/tools/idea/adb/wireless/QrCodeScanningController$MyViewListener;", "cancelIfDisposed", "", "dispose", "generateQrCode", "model", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingModel;", "isCancelled", "", "error", "", "pollMdnsServices", "startPairingDevice", "mdnsService", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "password", "", "startPairingProcess", "MyModelListener", "MyViewListener", "State", "intellij.android.adb"})
public final class QrCodeScanningController
implements Disposable {
    private final Logger LOG;
    private final FutureCallbackExecutor edtExecutor;
    private final Alarm pollingAlarm;
    private final MyModelListener modelListener;
    private final MyViewListener viewListener;
    private State state;
    private final AdbDevicePairingService service;
    private final AdbDevicePairingView view;

    public void dispose() {
        this.pollingAlarm.cancelAllRequests();
        this.view.getModel().removeListener(this.modelListener);
        this.view.removeListener(this.viewListener);
        this.state = State.Disposed;
    }

    public final void startPairingProcess() {
        this.view.showQrCodePairingStarted();
        this.generateQrCode(this.view.getModel());
        this.state = State.Polling;
        this.pollMdnsServices();
    }

    private final void generateQrCode(AdbDevicePairingModel model2) {
        ListenableFuture<QrCodeImage> futureQrCode = this.service.generateQrCode(UIColors.QR_CODE_BACKGROUND, UIColors.QR_CODE_FOREGROUND);
        this.edtExecutor.transform(futureQrCode, new FutureCallbackExecutor.ThrowableFunction(model2){
            final /* synthetic */ AdbDevicePairingModel $model;

            public final void apply(QrCodeImage it) {
                this.$model.setQrCodeImage(it);
            }
            {
                this.$model = adbDevicePairingModel;
            }
        });
    }

    private final void startPairingDevice(MdnsService mdnsService, String password) {
        this.state = State.Pairing;
        this.view.showQrCodePairingInProgress(mdnsService);
        ListenableFuture<PairingResult> futurePairing = this.service.pairMdnsService(mdnsService, password);
        FutureUtils.catching((ListenableFuture)FutureUtils.transform((ListenableFuture)FutureUtils.transformAsync((ListenableFuture)FutureUtils.transform(futurePairing, (Executor)((Executor)this.edtExecutor), (Function1)((Function1)new Function1<PairingResult, PairingResult>(this){
            final /* synthetic */ QrCodeScanningController this$0;

            @NotNull
            public final PairingResult invoke(@NotNull PairingResult pairingResult) {
                Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
                QrCodeScanningController.access$cancelIfDisposed(this.this$0);
                QrCodeScanningController.access$getView$p(this.this$0).showQrCodePairingWaitForDevice(pairingResult);
                return pairingResult;
            }
            {
                this.this$0 = qrCodeScanningController;
                super(1);
            }
        })), (Executor)((Executor)this.edtExecutor), (Function1)((Function1)new Function1<PairingResult, ListenableFuture<AdbOnlineDevice>>(this){
            final /* synthetic */ QrCodeScanningController this$0;

            @NotNull
            public final ListenableFuture<AdbOnlineDevice> invoke(@NotNull PairingResult pairingResult) {
                Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
                QrCodeScanningController.access$cancelIfDisposed(this.this$0);
                return QrCodeScanningController.access$getService$p(this.this$0).waitForDevice(pairingResult);
            }
            {
                this.this$0 = qrCodeScanningController;
                super(1);
            }
        })), (Executor)((Executor)this.edtExecutor), (Function1)((Function1)new Function1<AdbOnlineDevice, Unit>(this, mdnsService){
            final /* synthetic */ QrCodeScanningController this$0;
            final /* synthetic */ MdnsService $mdnsService;

            public final void invoke(@NotNull AdbOnlineDevice device) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                QrCodeScanningController.access$cancelIfDisposed(this.this$0);
                QrCodeScanningController.access$setState$p(this.this$0, State.PairingSuccess);
                QrCodeScanningController.access$getView$p(this.this$0).showQrCodePairingSuccess(this.$mdnsService, device);
            }
            {
                this.this$0 = qrCodeScanningController;
                this.$mdnsService = mdnsService;
                super(1);
            }
        })), (Executor)((Executor)this.edtExecutor), Throwable.class, (Function1)((Function1)new Function1<Throwable, Unit>(this, mdnsService){
            final /* synthetic */ QrCodeScanningController this$0;
            final /* synthetic */ MdnsService $mdnsService;

            public final void invoke(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (!QrCodeScanningController.access$isCancelled(this.this$0, error)) {
                    QrCodeScanningController.access$setState$p(this.this$0, State.PairingError);
                    QrCodeScanningController.access$getView$p(this.this$0).showQrCodePairingError(this.$mdnsService, error);
                }
            }
            {
                this.this$0 = qrCodeScanningController;
                this.$mdnsService = mdnsService;
                super(1);
            }
        }));
    }

    private final boolean isCancelled(Throwable error) {
        return error instanceof CancellationException;
    }

    private final void cancelIfDisposed() {
        if (this.state == State.Disposed) {
            throw (Throwable)new CancellationException("Object has been disposed");
        }
    }

    private final void pollMdnsServices() {
        if (this.state != State.Polling) {
            return;
        }
        ListenableFuture<List<MdnsService>> futureServices = this.service.scanMdnsServices();
        ListenableFuture listenableFuture = this.edtExecutor.transform(futureServices, new FutureCallbackExecutor.ThrowableFunction(this){
            final /* synthetic */ QrCodeScanningController this$0;

            public final void apply(List<MdnsService> services) {
                MdnsService it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                AdbDevicePairingModel adbDevicePairingModel = QrCodeScanningController.access$getView$p(this.this$0).getModel();
                List<MdnsService> list = services;
                Intrinsics.checkNotNullExpressionValue(list, (String)"services");
                Iterable iterable = list;
                AdbDevicePairingModel adbDevicePairingModel2 = adbDevicePairingModel;
                boolean $i$f$filter = false;
                void var4_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MdnsService)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getServiceType() == ServiceType.PinCode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                adbDevicePairingModel2.setPinCodeServices(list2);
                $this$filter$iv = services;
                adbDevicePairingModel2 = QrCodeScanningController.access$getView$p(this.this$0).getModel();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MdnsService)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getServiceType() == ServiceType.QrCode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                adbDevicePairingModel2.setQrCodeServices(list2);
            }
            {
                this.this$0 = qrCodeScanningController;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"edtExecutor.transform(fu\u2026erviceType.QrCode }\n    }");
        FutureUtils.finallySync((ListenableFuture)FutureUtils.catching((ListenableFuture)listenableFuture, (Executor)((Executor)this.edtExecutor), Throwable.class, (Function1)pollMdnsServices.2.INSTANCE), (Executor)((Executor)this.edtExecutor), (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ QrCodeScanningController this$0;

            public final void invoke() {
                if (!Disposer.isDisposed((Disposable)this.this$0)) {
                    QrCodeScanningController.access$getPollingAlarm$p(this.this$0).addRequest(new Runnable(this){
                        final /* synthetic */ pollMdnsServices.3 this$0;

                        public final void run() {
                            QrCodeScanningController.access$pollMdnsServices(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, 1000);
                }
            }
            {
                this.this$0 = qrCodeScanningController;
                super(0);
            }
        }));
    }

    public QrCodeScanningController(@NotNull AdbDevicePairingService service, @NotNull AdbDevicePairingView view, @NotNull Executor edtExecutor2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)edtExecutor2, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.service = service;
        this.view = view;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(QrCodeScanningController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger2;
        FutureCallbackExecutor futureCallbackExecutor = FutureCallbackExecutor.wrap((Executor)edtExecutor2);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor, (String)"FutureCallbackExecutor.wrap(edtExecutor)");
        this.edtExecutor = futureCallbackExecutor;
        this.pollingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.modelListener = new MyModelListener();
        this.viewListener = new MyViewListener();
        this.state = State.Init;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.view.addListener(this.viewListener);
        this.view.getModel().addListener(this.modelListener);
    }

    public static final /* synthetic */ void access$setState$p(QrCodeScanningController $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$cancelIfDisposed(QrCodeScanningController $this) {
        $this.cancelIfDisposed();
    }

    public static final /* synthetic */ AdbDevicePairingService access$getService$p(QrCodeScanningController $this) {
        return $this.service;
    }

    public static final /* synthetic */ boolean access$isCancelled(QrCodeScanningController $this, Throwable error) {
        return $this.isCancelled(error);
    }

    public static final /* synthetic */ Alarm access$getPollingAlarm$p(QrCodeScanningController $this) {
        return $this.pollingAlarm;
    }

    public static final /* synthetic */ void access$pollMdnsServices(QrCodeScanningController $this) {
        $this.pollMdnsServices();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/adb/wireless/QrCodeScanningController$State;", "", "(Ljava/lang/String;I)V", "Init", "Polling", "Pairing", "PairingError", "PairingSuccess", "Disposed", "intellij.android.adb"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Init;
        public static final /* enum */ State Polling;
        public static final /* enum */ State Pairing;
        public static final /* enum */ State PairingError;
        public static final /* enum */ State PairingSuccess;
        public static final /* enum */ State Disposed;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[6];
            State[] stateArray2 = stateArray;
            stateArray[0] = Init = new State();
            stateArray[1] = Polling = new State();
            stateArray[2] = Pairing = new State();
            stateArray[3] = PairingError = new State();
            stateArray[4] = PairingSuccess = new State();
            stateArray[5] = Disposed = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @UiThread
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/adb/wireless/QrCodeScanningController$MyViewListener;", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingView$Listener;", "(Lcom/android/tools/idea/adb/wireless/QrCodeScanningController;)V", "onClose", "", "onPinCodePairAction", "mdnsService", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "onScanAnotherQrCodeDeviceAction", "intellij.android.adb"})
    public final class MyViewListener
    implements AdbDevicePairingView.Listener {
        @Override
        public void onScanAnotherQrCodeDeviceAction() {
            switch (QrCodeScanningController$MyViewListener$WhenMappings.$EnumSwitchMapping$0[QrCodeScanningController.this.state.ordinal()]) {
                case 1: 
                case 2: {
                    QrCodeScanningController.this.startPairingProcess();
                    break;
                }
            }
        }

        @Override
        public void onPinCodePairAction(@NotNull MdnsService mdnsService) {
            Intrinsics.checkNotNullParameter((Object)mdnsService, (String)"mdnsService");
        }

        @Override
        public void onClose() {
        }
    }

    @UiThread
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/adb/wireless/QrCodeScanningController$MyModelListener;", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingModelListener;", "(Lcom/android/tools/idea/adb/wireless/QrCodeScanningController;)V", "pinCodeServicesDiscovered", "", "services", "", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "qrCodeGenerated", "newImage", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "qrCodeServicesDiscovered", "intellij.android.adb"})
    public final class MyModelListener
    implements AdbDevicePairingModelListener {
        @Override
        public void qrCodeGenerated(@NotNull QrCodeImage newImage) {
            Intrinsics.checkNotNullParameter((Object)newImage, (String)"newImage");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void qrCodeServicesDiscovered(@NotNull List<MdnsService> services) {
            block5: {
                Object v1;
                QrCodeImage qrCodeImage;
                boolean bl;
                block4: {
                    Intrinsics.checkNotNullParameter(services, (String)"services");
                    QrCodeScanningController.this.LOG.info(services.size() + " QR code connect services discovered");
                    Iterable $this$forEachIndexed$iv = services;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void it;
                        int n = index$iv++;
                        bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        MdnsService mdnsService = (MdnsService)item$iv;
                        int index2 = n;
                        boolean bl2 = false;
                        QrCodeScanningController.this.LOG.info("  QR code connect service #" + (index2 + 1) + ": name=" + it.getServiceName() + " - ip=" + it.getIpAddress() + " - port=" + it.getPort());
                    }
                    QrCodeImage qrCodeImage2 = QrCodeScanningController.this.view.getModel().getQrCodeImage();
                    if (qrCodeImage2 == null) break block5;
                    QrCodeImage qrCodeImage3 = qrCodeImage2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    qrCodeImage = qrCodeImage3;
                    boolean bl5 = false;
                    Iterable $this$firstOrNull$iv = services;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        MdnsService it = (MdnsService)element$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)it.getServiceName(), (Object)qrCodeImage.getServiceName())) continue;
                        v1 = element$iv;
                        break block4;
                    }
                    v1 = null;
                }
                MdnsService mdnsService = v1;
                if (mdnsService != null) {
                    MdnsService mdnsService2 = mdnsService;
                    bl = false;
                    boolean bl7 = false;
                    MdnsService it = mdnsService2;
                    boolean bl8 = false;
                    QrCodeScanningController.this.startPairingDevice(it, qrCodeImage.getPassword());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void pinCodeServicesDiscovered(@NotNull List<MdnsService> services) {
            Intrinsics.checkNotNullParameter(services, (String)"services");
            QrCodeScanningController.this.LOG.info(services.size() + " Pin code pairing services discovered");
            Iterable $this$forEachIndexed$iv = services;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                MdnsService mdnsService = (MdnsService)item$iv;
                int index2 = n;
                boolean bl2 = false;
                QrCodeScanningController.this.LOG.info("  Pin code pairing service #" + (index2 + 1) + ": name=" + it.getServiceName() + " - ip=" + it.getIpAddress() + " - port=" + it.getPort());
            }
        }
    }
}

