/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.JSingleDigitTextField;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

public class PinCodeInputPanel {
    public static final int PIN_CODE_DIGIT_COUNT = 6;
    @NotNull
    private JPanel myRootContainer;
    @NotNull
    private JBLabel myDeviceAddressLabel;
    @NotNull
    private JBLabel myPairingProgressLabel;
    @NotNull
    private AsyncProcessIcon myPairingProgressAsyncIcon;
    @NotNull
    private JBLabel myStatusIconLabel;
    @NotNull
    private JTextField myPinCodeDigit1;
    @NotNull
    private JTextField myPinCodeDigit2;
    @NotNull
    private JTextField myPinCodeDigit3;
    @NotNull
    private JTextField myPinCodeDigit4;
    @NotNull
    private JTextField myPinCodeDigit5;
    @NotNull
    private JTextField myPinCodeDigit6;
    @NotNull
    private final List<JTextField> myAllDigitTextFields;

    public PinCodeInputPanel() {
        this.$$$setupUI$$$();
        this.myPairingProgressLabel.setText("");
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myStatusIconLabel.setVisible(false);
        this.myAllDigitTextFields = Arrays.asList(this.myPinCodeDigit1, this.myPinCodeDigit2, this.myPinCodeDigit3, this.myPinCodeDigit4, this.myPinCodeDigit5, this.myPinCodeDigit6);
        for (int i2 = 0; i2 < this.myAllDigitTextFields.size(); ++i2) {
            this.myAllDigitTextFields.get(i2).setName("PinCode-Digit-" + i2);
        }
    }

    private void createUIComponents() {
        this.myPairingProgressAsyncIcon = new AsyncProcessIcon("pin code pairing progress");
        this.myPinCodeDigit1 = new JSingleDigitTextField();
        this.myPinCodeDigit2 = new JSingleDigitTextField();
        this.myPinCodeDigit3 = new JSingleDigitTextField();
        this.myPinCodeDigit4 = new JSingleDigitTextField();
        this.myPinCodeDigit5 = new JSingleDigitTextField();
        this.myPinCodeDigit6 = new JSingleDigitTextField();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootContainer;
        if (jPanel == null) {
            PinCodeInputPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPinCodeComponent() {
        JComponent jComponent = this.myAllDigitTextFields.get(0);
        if (jComponent == null) {
            PinCodeInputPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public String getPinCode() {
        StringBuilder sb = new StringBuilder();
        this.myAllDigitTextFields.forEach(textField -> {
            String text2 = textField.getText();
            if (text2 == null || text2.isEmpty()) {
                text2 = "0";
            }
            sb.append(text2);
        });
        String string = sb.toString();
        if (string == null) {
            PinCodeInputPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setDevice(@NotNull MdnsService service) {
        if (service == null) {
            PinCodeInputPanel.$$$reportNull$$$0(3);
        }
        this.myDeviceAddressLabel.setText(service.getDisplayString());
    }

    public void showProgress(@NotNull String text2) {
        if (text2 == null) {
            PinCodeInputPanel.$$$reportNull$$$0(4);
        }
        this.myStatusIconLabel.setVisible(false);
        this.myPairingProgressAsyncIcon.setVisible(true);
        this.myPairingProgressLabel.setText(text2);
    }

    public void showSuccess(@NotNull AdbOnlineDevice device) {
        if (device == null) {
            PinCodeInputPanel.$$$reportNull$$$0(5);
        }
        this.myStatusIconLabel.setIcon(StudioIcons.Common.SUCCESS);
        this.myStatusIconLabel.setVisible(true);
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myPairingProgressLabel.setText(String.format("%s connected", device.getDisplayString()));
    }

    public void showPairingError() {
        this.myStatusIconLabel.setIcon(StudioIcons.Common.ERROR);
        this.myStatusIconLabel.setVisible(true);
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myPairingProgressLabel.setText("There was an error pairing the device");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/adb/wireless/PinCodeInputPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPinCodeComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPinCode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/adb/wireless/PinCodeInputPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDevice";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showProgress";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showSuccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 20), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Enter the 6 digit code shown on the device at");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myDeviceAddressLabel = jBLabel3 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel3.getFont());
        if (font != null) {
            jBLabel3.setFont(font);
        }
        jBLabel3.setText("[xxx.xxx.xxx.xxx]");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText(" to pair.");
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 30), null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel3, new GridConstraints(4, 1, 1, 1, 0, 2, 3, 3, null, null, null));
        JTextField jTextField = this.myPinCodeDigit1;
        jTextField.setColumns(2);
        jTextField.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)jTextField, gridBagConstraints);
        JTextField jTextField2 = this.myPinCodeDigit2;
        jTextField2.setColumns(2);
        jTextField2.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jTextField2, gridBagConstraints2);
        JTextField jTextField3 = this.myPinCodeDigit3;
        jTextField3.setColumns(2);
        jTextField3.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jTextField3, gridBagConstraints3);
        JTextField jTextField4 = this.myPinCodeDigit4;
        jTextField4.setColumns(2);
        jTextField4.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jTextField4, gridBagConstraints4);
        JTextField jTextField5 = this.myPinCodeDigit5;
        jTextField5.setColumns(2);
        jTextField5.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jTextField5, gridBagConstraints5);
        JTextField jTextField6 = this.myPinCodeDigit6;
        jTextField6.setColumns(2);
        jTextField6.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 5;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jTextField6, gridBagConstraints6);
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPairingProgressLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("(some text)");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 4, 2, 0, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myPairingProgressAsyncIcon;
        jPanel5.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 3, null, null, null));
        this.myStatusIconLabel = jBLabel = new JBLabel();
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(2, 0), null));
        Spacer spacer6 = new Spacer();
        jPanel.add((Component)spacer6, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel.add((Component)spacer7, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

