/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.tools.idea.adb.wireless.EditorPaneUtils;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.PinCodeDevicePanel;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PinCodeContentPanel {
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myEmptyPanel;
    @NotNull
    private JPanel myDevicesPanel;
    @NotNull
    private JPanel myDevicesHeaderPanel;
    @NotNull
    private JPanel myDeviceList;
    @NotNull
    private JBScrollPane myDeviceListScrollPane;
    @NotNull
    List<PinCodeDevicePanel> myPanels;

    public PinCodeContentPanel() {
        this.$$$setupUI$$$();
        this.myPanels = new ArrayList<PinCodeDevicePanel>();
        this.myDeviceList.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myEmptyPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myDevicesHeaderPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myDeviceListScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myDeviceList.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        EditorPaneUtils.setTitlePanelBorder(this.myDevicesHeaderPanel);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootComponent;
        if (jPanel == null) {
            PinCodeContentPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void showDevices(@NotNull @NotNull List<@NotNull MdnsService> services, @NotNull Consumer<MdnsService> pinCodePairInvoked2) {
        if (services == null) {
            PinCodeContentPanel.$$$reportNull$$$0(1);
        }
        if (pinCodePairInvoked2 == null) {
            PinCodeContentPanel.$$$reportNull$$$0(2);
        }
        if (services.isEmpty()) {
            this.myEmptyPanel.setVisible(true);
            this.myDevicesPanel.setVisible(false);
            this.myDeviceList.removeAll();
            this.myDeviceList.revalidate();
            this.myDeviceList.repaint();
            this.myPanels.clear();
        } else {
            int i2;
            this.myEmptyPanel.setVisible(false);
            this.myDevicesPanel.setVisible(true);
            boolean needRepaint = false;
            for (MdnsService service : services) {
                if (PinCodeContentPanel.isPanelPresent(this.myPanels, service)) continue;
                PinCodeDevicePanel devicePanel = new PinCodeDevicePanel(service, () -> pinCodePairInvoked2.accept(service));
                this.myDeviceList.add(devicePanel.getComponent());
                this.myPanels.add(devicePanel);
                needRepaint = true;
            }
            ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
            int index2 = 0;
            for (PinCodeDevicePanel panel2 : this.myPanels) {
                if (PinCodeContentPanel.isPanelDeleted(services, panel2)) {
                    indicesToRemove.add(index2);
                }
                ++index2;
            }
            for (i2 = indicesToRemove.size() - 1; i2 >= 0; --i2) {
                int indexToRemove = (Integer)indicesToRemove.get(i2);
                this.myPanels.remove(indexToRemove);
                this.myDeviceList.remove(indexToRemove);
                needRepaint = true;
            }
            if (needRepaint) {
                this.myDeviceList.revalidate();
                this.myDeviceList.repaint();
            }
            assert (this.myPanels.size() == this.myDeviceList.getComponentCount());
            assert (services.size() == this.myDeviceList.getComponentCount());
            for (i2 = 0; i2 < this.myPanels.size(); ++i2) {
                assert (this.myPanels.get(i2).getComponent() == this.myDeviceList.getComponent(i2));
                assert (this.myPanels.get(i2).getMdnsService().equals(services.get(i2)));
            }
        }
    }

    private static boolean isPanelDeleted(@NotNull List<MdnsService> services, @NotNull PinCodeDevicePanel panel2) {
        if (services == null) {
            PinCodeContentPanel.$$$reportNull$$$0(3);
        }
        if (panel2 == null) {
            PinCodeContentPanel.$$$reportNull$$$0(4);
        }
        return services.stream().noneMatch(service -> service.equals(panel2.getMdnsService()));
    }

    private static boolean isPanelPresent(@NotNull List<PinCodeDevicePanel> panels, @NotNull MdnsService device) {
        if (panels == null) {
            PinCodeContentPanel.$$$reportNull$$$0(5);
        }
        if (device == null) {
            PinCodeContentPanel.$$$reportNull$$$0(6);
        }
        return panels.stream().anyMatch(panel2 -> panel2.getMdnsService().equals(device));
    }

    private void createUIComponents() {
        this.myDeviceListScrollPane = new JBScrollPane(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/adb/wireless/PinCodeContentPanel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinCodePairInvoked";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/adb/wireless/PinCodeContentPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showDevices";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPanelDeleted";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPanelPresent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myRootComponent = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        this.myDevicesPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDevicesHeaderPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Available devices");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = this.myDeviceListScrollPane;
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeviceList = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootComponent;
    }
}

