/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.tools.idea.adb.wireless.UIColors;
import com.android.utils.HtmlBuilder;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u000b\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"createHtmlEditorPane", "Ljavax/swing/JEditorPane;", "setBottomPanelBorder", "", "panel", "Ljavax/swing/JComponent;", "setPanelBorder", "topPixels", "", "bottomPixels", "setTitlePanelBorder", "setHtml", "htmlBuilder", "Lcom/android/utils/HtmlBuilder;", "textColor", "Ljava/awt/Color;", "intellij.android.adb"})
@JvmName(name="EditorPaneUtils")
public final class EditorPaneUtils {
    @NotNull
    public static final JEditorPane createHtmlEditorPane() {
        JEditorPane jEditorPane = SwingHelper.createHtmlViewer((boolean)true, null, (Color)((Color)JBColor.WHITE), (Color)((Color)JBColor.BLACK));
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"SwingHelper.createHtmlVi\u2026lor.WHITE, JBColor.BLACK)");
        JEditorPane viewer = jEditorPane;
        viewer.setOpaque(false);
        viewer.setFocusable(false);
        UIUtil.doNotScrollToCaret((JTextComponent)viewer);
        viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                URL url = e.getURL();
                if (url != null) {
                    BrowserUtil.browse((URL)url);
                }
            }
        });
        return viewer;
    }

    public static final void setHtml(@NotNull JEditorPane $this$setHtml, @NotNull HtmlBuilder htmlBuilder, @Nullable Color textColor) {
        Intrinsics.checkNotNullParameter((Object)$this$setHtml, (String)"$this$setHtml");
        Intrinsics.checkNotNullParameter((Object)htmlBuilder, (String)"htmlBuilder");
        SwingHelper.setHtml((JEditorPane)$this$setHtml, (String)htmlBuilder.getHtml(), (Color)textColor);
    }

    public static final void setTitlePanelBorder(@NotNull JComponent panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        EditorPaneUtils.setPanelBorder(panel2, 0, 1);
    }

    public static final void setBottomPanelBorder(@NotNull JComponent panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        EditorPaneUtils.setPanelBorder(panel2, 1, 0);
    }

    private static final void setPanelBorder(JComponent panel2, int topPixels, int bottomPixels) {
        Border line2 = (Border)new CustomLineBorder(UIColors.ONE_PIXEL_DIVIDER, topPixels, 0, bottomPixels, 0);
        Border c = new CompoundBorder(line2, (Border)JBUI.Borders.empty((int)5, (int)10));
        panel2.setBorder(c);
        panel2.setMinimumSize((Dimension)new JBDimension(0, 30));
    }
}

