/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutRemainder;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.wireless.AdbCommandException;
import com.android.tools.idea.adb.wireless.AdbCommandResult;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.AdbServiceWrapper;
import com.android.tools.idea.adb.wireless.AdbServiceWrapperImpl;
import com.android.tools.idea.adb.wireless.ExternalCommand;
import com.android.tools.idea.adb.wireless.PairingResult;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u001cH\u0002J\u0018\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/adb/wireless/AdbServiceWrapperImpl;", "Lcom/android/tools/idea/adb/wireless/AdbServiceWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "nanoTimeProvider", "Lcom/android/ddmlib/TimeoutRemainder$SystemNanoTimeProvider;", "taskExecutor", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "(Lcom/intellij/openapi/project/Project;Lcom/android/ddmlib/TimeoutRemainder$SystemNanoTimeProvider;Lcom/google/common/util/concurrent/ListeningExecutorService;)V", "ADB_DEVICE_CONNECT_MILLIS", "", "ADB_TIMEOUT_MILLIS", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getTaskExecutor", "()Lcom/google/common/util/concurrent/ListeningExecutorService;", "createAdbOnlineDevice", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "device", "Lcom/android/ddmlib/IDevice;", "rem", "Lcom/android/ddmlib/TimeoutRemainder;", "executeCommand", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/tools/idea/adb/wireless/AdbCommandResult;", "args", "", "", "stdin", "getAdbLocation", "Ljava/io/File;", "sameDevice", "", "pairingResult", "Lcom/android/tools/idea/adb/wireless/PairingResult;", "sameIpAddress", "ipAddress", "Ljava/net/InetAddress;", "sameMdnsService", "mdnsServiceId", "waitForDevice", "debugBridge", "Lcom/android/ddmlib/AndroidDebugBridge;", "waitForOnlineDevice", "intellij.android.adb"})
public final class AdbServiceWrapperImpl
implements AdbServiceWrapper {
    private final long ADB_TIMEOUT_MILLIS;
    private final long ADB_DEVICE_CONNECT_MILLIS;
    private final Logger LOG;
    private final Project project;
    private final TimeoutRemainder.SystemNanoTimeProvider nanoTimeProvider;
    @NotNull
    private final ListeningExecutorService taskExecutor;

    @Override
    @NotNull
    public ListenableFuture<AdbCommandResult> executeCommand(@NotNull List<String> args, @NotNull String stdin) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        return FutureUtils.transform(this.getAdbLocation(), (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<File, AdbCommandResult>(this, stdin, args){
            final /* synthetic */ AdbServiceWrapperImpl this$0;
            final /* synthetic */ String $stdin;
            final /* synthetic */ List $args;

            @NotNull
            public final AdbCommandResult invoke(@NotNull File adbFile) {
                Intrinsics.checkNotNullParameter((Object)adbFile, (String)"adbFile");
                String string = this.$stdin;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string2 = string;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                ByteArrayInputStream stdinStream = new ByteArrayInputStream(byArray);
                ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream();
                ByteArrayOutputStream stderrStream = new ByteArrayOutputStream();
                String string4 = adbFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"adbFile.absolutePath");
                int exitValue = new ExternalCommand(string4).execute(this.$args, stdinStream, stdoutStream, stderrStream, AdbServiceWrapperImpl.access$getADB_TIMEOUT_MILLIS$p(this.this$0), TimeUnit.MILLISECONDS);
                ProcessOutput processOutput = new ProcessOutput();
                processOutput.appendStdout(stdoutStream.toString("UTF-8"));
                processOutput.appendStderr(stderrStream.toString("UTF-8"));
                List list = processOutput.getStdoutLines();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"processOutput.stdoutLines");
                List list2 = processOutput.getStderrLines();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"processOutput.stderrLines");
                return new AdbCommandResult(exitValue, list, list2);
            }
            {
                this.this$0 = adbServiceWrapperImpl;
                this.$stdin = string;
                this.$args = list;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<AdbOnlineDevice> waitForOnlineDevice(@NotNull PairingResult pairingResult) {
        Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
        return FutureUtils.transform((ListenableFuture)FutureUtils.transformAsync(this.getAdbLocation(), (Executor)((Executor)this.taskExecutor), (Function1)waitForOnlineDevice.1.INSTANCE), (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<AndroidDebugBridge, AdbOnlineDevice>(this, pairingResult){
            final /* synthetic */ AdbServiceWrapperImpl this$0;
            final /* synthetic */ PairingResult $pairingResult;

            @NotNull
            public final AdbOnlineDevice invoke(AndroidDebugBridge debugBridge) {
                AndroidDebugBridge androidDebugBridge = debugBridge;
                Intrinsics.checkNotNullExpressionValue((Object)androidDebugBridge, (String)"debugBridge");
                return AdbServiceWrapperImpl.access$waitForDevice(this.this$0, androidDebugBridge, this.$pairingResult);
            }
            {
                this.this$0 = adbServiceWrapperImpl;
                this.$pairingResult = pairingResult;
                super(1);
            }
        }));
    }

    private final ListenableFuture<File> getAdbLocation() {
        return FutureUtils.executeAsync((Executor)((Executor)this.taskExecutor), (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ AdbServiceWrapperImpl this$0;

            @NotNull
            public final File invoke() {
                Object object;
                AdbFileProvider adbProvider = AdbFileProvider.Companion.fromProject(AdbServiceWrapperImpl.access$getProject$p(this.this$0));
                if (adbProvider == null) {
                    AdbServiceWrapperImpl.access$getLOG$p(this.this$0).warn("AdbFileProvider is not correctly set up (see AdbFileProviderInitializer)");
                }
                if ((object = adbProvider) == null || (object = ((AdbFileProvider)object).getAdbFile()) == null) {
                    throw (Throwable)new IllegalStateException("The path to the ADB command is not available");
                }
                return object;
            }
            {
                this.this$0 = adbServiceWrapperImpl;
                super(0);
            }
        }));
    }

    private final AdbOnlineDevice waitForDevice(AndroidDebugBridge debugBridge, PairingResult pairingResult) {
        TimeoutRemainder rem = new TimeoutRemainder(this.nanoTimeProvider, this.ADB_DEVICE_CONNECT_MILLIS, TimeUnit.MILLISECONDS);
        while (true) {
            IDevice device;
            block4: {
                IDevice iDevice;
                IDevice[] $this$firstOrNull$iv;
                Intrinsics.checkNotNullExpressionValue((Object)debugBridge.getDevices(), (String)"debugBridge.devices");
                boolean $i$f$firstOrNull = false;
                IDevice[] iDeviceArray = $this$firstOrNull$iv;
                int n = iDeviceArray.length;
                for (int j = 0; j < n; ++j) {
                    IDevice element$iv;
                    IDevice it = element$iv = iDeviceArray[j];
                    boolean bl = false;
                    IDevice iDevice2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)iDevice2, (String)"it");
                    if (!(iDevice2.isOnline() && this.sameDevice(it, pairingResult))) continue;
                    iDevice = element$iv;
                    break block4;
                }
                iDevice = device = null;
            }
            if (device != null) {
                return this.createAdbOnlineDevice(device, rem);
            }
            if (rem.getRemainingUnits() <= 0L) {
                throw (Throwable)new AdbCommandException("Device did not connect within specified timeout", -1, CollectionsKt.emptyList());
            }
            Thread.sleep(50L);
        }
    }

    private final AdbOnlineDevice createAdbOnlineDevice(IDevice device, TimeoutRemainder rem) {
        Future futureProp = device.getSystemProperty("ro.product.model");
        futureProp.get(rem.getRemainingUnits(), TimeUnit.MILLISECONDS);
        if (!device.arePropertiesSet()) {
            throw (Throwable)new AdbCommandException("Device did not connect within specified timeout", -1, CollectionsKt.emptyList());
        }
        String string = device.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
        Map map2 = device.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"device.properties");
        return new AdbOnlineDevice(string, map2);
    }

    private final boolean sameDevice(IDevice device, PairingResult pairingResult) {
        return this.sameIpAddress(device, pairingResult.getIpAddress()) || this.sameMdnsService(device, pairingResult.getMdnsServiceId());
    }

    private final boolean sameMdnsService(IDevice device, String mdnsServiceId) {
        String string = device.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
        return StringsKt.startsWith$default((String)string, (String)mdnsServiceId, (boolean)false, (int)2, null);
    }

    private final boolean sameIpAddress(IDevice device, InetAddress ipAddress) {
        String string = device.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
        List comps = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        return comps.size() == 2 && Intrinsics.areEqual((Object)((String)comps.get(0)), (Object)ipAddress.getHostAddress());
    }

    @NotNull
    public final ListeningExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public AdbServiceWrapperImpl(@NotNull Project project, @NotNull TimeoutRemainder.SystemNanoTimeProvider nanoTimeProvider, @NotNull ListeningExecutorService taskExecutor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)nanoTimeProvider, (String)"nanoTimeProvider");
        Intrinsics.checkNotNullParameter((Object)taskExecutor2, (String)"taskExecutor");
        this.project = project;
        this.nanoTimeProvider = nanoTimeProvider;
        this.taskExecutor = taskExecutor2;
        this.ADB_TIMEOUT_MILLIS = 30000L;
        this.ADB_DEVICE_CONNECT_MILLIS = 30000L;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(AdbServiceWrapperImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger2;
    }

    public static final /* synthetic */ long access$getADB_TIMEOUT_MILLIS$p(AdbServiceWrapperImpl $this) {
        return $this.ADB_TIMEOUT_MILLIS;
    }

    public static final /* synthetic */ AdbOnlineDevice access$waitForDevice(AdbServiceWrapperImpl $this, AndroidDebugBridge debugBridge, PairingResult pairingResult) {
        return $this.waitForDevice(debugBridge, pairingResult);
    }

    public static final /* synthetic */ Project access$getProject$p(AdbServiceWrapperImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ Logger access$getLOG$p(AdbServiceWrapperImpl $this) {
        return $this.LOG;
    }
}

