/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbCommandException;
import com.android.tools.idea.adb.wireless.AdbCommandResult;
import com.android.tools.idea.adb.wireless.AdbDevice;
import com.android.tools.idea.adb.wireless.AdbDevicePairingService;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.AdbServiceWrapper;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.MdnsSupportState;
import com.android.tools.idea.adb.wireless.PairingResult;
import com.android.tools.idea.adb.wireless.QrCodeGenerator;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.RandomProvider;
import com.android.tools.idea.adb.wireless.ServiceType;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.LineSeparator;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0010H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0014\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00190\u0010H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00102\u0006\u0010'\u001a\u00020!H\u0016R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/adb/wireless/AdbDevicePairingServiceImpl;", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingService;", "randomProvider", "Lcom/android/tools/idea/adb/wireless/RandomProvider;", "adbService", "Lcom/android/tools/idea/adb/wireless/AdbServiceWrapper;", "taskExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/adb/wireless/RandomProvider;Lcom/android/tools/idea/adb/wireless/AdbServiceWrapper;Ljava/util/concurrent/Executor;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "studioServiceNamePrefix", "", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "checkMdnsSupport", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/tools/idea/adb/wireless/MdnsSupportState;", "createPairingString", "service", "password", "createRandomString", "charCount", "", "devices", "", "Lcom/android/tools/idea/adb/wireless/AdbDevice;", "generateQrCode", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "backgroundColor", "Ljava/awt/Color;", "foregroundColor", "pairMdnsService", "Lcom/android/tools/idea/adb/wireless/PairingResult;", "mdnsService", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "scanMdnsServices", "waitForDevice", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "pairingResult", "intellij.android.adb"})
public final class AdbDevicePairingServiceImpl
implements AdbDevicePairingService {
    private final Logger LOG;
    private final FutureCallbackExecutor taskExecutor;
    private final String studioServiceNamePrefix;
    private final RandomProvider randomProvider;
    private final AdbServiceWrapper adbService;

    @Override
    @NotNull
    public ListenableFuture<MdnsSupportState> checkMdnsSupport() {
        this.LOG.info("Checking if mDNS is supported (`adb mdns check` command)");
        ListenableFuture futureResult = AdbServiceWrapper.DefaultImpls.executeCommand$default(this.adbService, CollectionsKt.listOf((Object[])new String[]{"mdns", "check"}), null, 2, null);
        return FutureUtils.transform((ListenableFuture)FutureUtils.catching((ListenableFuture)FutureUtils.transform((ListenableFuture)futureResult, (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<AdbCommandResult, MdnsSupportState>(this){
            final /* synthetic */ AdbDevicePairingServiceImpl this$0;

            @NotNull
            public final MdnsSupportState invoke(@NotNull AdbCommandResult result2) {
                MdnsSupportState mdnsSupportState;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (result2.getErrorCode() != 0) {
                    boolean isUnknownCommand;
                    block10: {
                        boolean bl;
                        AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).warn("`adb mdns check` returned a non-zero error code (" + result2.getErrorCode() + ')');
                        Iterable $this$any$iv = result2.getStderr();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String line2 = (String)element$iv;
                                boolean bl2 = false;
                                CharSequence charSequence = line2;
                                Regex regex = new Regex("unknown.*command");
                                boolean bl3 = false;
                                if (!regex.containsMatchIn(charSequence)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = isUnknownCommand = false;
                        }
                    }
                    mdnsSupportState = isUnknownCommand ? MdnsSupportState.AdbVersionTooLow : MdnsSupportState.AdbInvocationError;
                } else if (result2.getStdout().isEmpty()) {
                    AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).warn("`adb mdns check` returned an empty output (why?)");
                    mdnsSupportState = MdnsSupportState.AdbInvocationError;
                } else {
                    boolean bl;
                    block11: {
                        Iterable $this$any$iv = result2.getStdout();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl4 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"mdns daemon version", (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    mdnsSupportState = bl ? MdnsSupportState.Supported : MdnsSupportState.NotSupported;
                }
                return mdnsSupportState;
            }
            {
                this.this$0 = adbDevicePairingServiceImpl;
                super(1);
            }
        })), (Executor)((Executor)this.taskExecutor), Throwable.class, (Function1)((Function1)new Function1<Throwable, MdnsSupportState>(this){
            final /* synthetic */ AdbDevicePairingServiceImpl this$0;

            @NotNull
            public final MdnsSupportState invoke(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).warn("Error executing `adb mdns check`", t);
                return MdnsSupportState.AdbInvocationError;
            }
            {
                this.this$0 = adbDevicePairingServiceImpl;
                super(1);
            }
        })), (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<MdnsSupportState, MdnsSupportState>(this){
            final /* synthetic */ AdbDevicePairingServiceImpl this$0;

            @NotNull
            public final MdnsSupportState invoke(@NotNull MdnsSupportState supportState) {
                Intrinsics.checkNotNullParameter((Object)((Object)supportState), (String)"supportState");
                AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).info("Checking if mDNS is supportState result: " + (Object)((Object)supportState));
                return supportState;
            }
            {
                this.this$0 = adbDevicePairingServiceImpl;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<QrCodeImage> generateQrCode(@NotNull Color backgroundColor, @NotNull Color foregroundColor) {
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)foregroundColor, (String)"foregroundColor");
        ListenableFuture listenableFuture = this.taskExecutor.executeAsync(new Callable(this, backgroundColor, foregroundColor){
            final /* synthetic */ AdbDevicePairingServiceImpl this$0;
            final /* synthetic */ Color $backgroundColor;
            final /* synthetic */ Color $foregroundColor;

            public final QrCodeImage call() {
                String serviceName = AdbDevicePairingServiceImpl.access$getStudioServiceNamePrefix$p(this.this$0) + AdbDevicePairingServiceImpl.access$createRandomString(this.this$0, 10);
                String password = AdbDevicePairingServiceImpl.access$createRandomString(this.this$0, 12);
                String pairingString = AdbDevicePairingServiceImpl.access$createPairingString(this.this$0, serviceName, password);
                BufferedImage image = QrCodeGenerator.encodeQrCodeToImage(pairingString, this.$backgroundColor, this.$foregroundColor);
                return new QrCodeImage(serviceName, password, pairingString, image);
            }
            {
                this.this$0 = adbDevicePairingServiceImpl;
                this.$backgroundColor = color;
                this.$foregroundColor = color2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.executeAsyn\u2026iringString, image)\n    }");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<List<AdbDevice>> devices() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(emptyList())");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<List<MdnsService>> scanMdnsServices() {
        ListenableFuture futureResult = AdbServiceWrapper.DefaultImpls.executeCommand$default(this.adbService, CollectionsKt.listOf((Object[])new String[]{"mdns", "services"}), null, 2, null);
        return FutureUtils.transform((ListenableFuture)futureResult, (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<AdbCommandResult, List<? extends MdnsService>>(this){
            final /* synthetic */ AdbDevicePairingServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MdnsService> invoke(@NotNull AdbCommandResult result2) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                Regex lineRegex = new Regex("([^\\t]+)\\t*_adb-tls-pairing._tcp.\\t*([^:]+):([0-9]+)");
                if (result2.getErrorCode() != 0) {
                    throw (Throwable)new AdbCommandException("Error discovering services", result2.getErrorCode(), result2.getStderr());
                }
                if (result2.getStdout().isEmpty()) {
                    throw (Throwable)new AdbCommandException("Empty output from \"adb mdns services\" command", -1, result2.getStderr());
                }
                Iterable $this$mapNotNull$iv = CollectionsKt.drop((Iterable)result2.getStdout(), (int)1);
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    MdnsService mdnsService;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String line2 = (String)element$iv$iv;
                    boolean bl2 = false;
                    MatchResult matchResult = Regex.find$default((Regex)lineRegex, (CharSequence)line2, (int)0, (int)2, null);
                    if (matchResult != null) {
                        MdnsService mdnsService2;
                        MatchResult matchResult2;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        MatchResult it = matchResult2;
                        boolean bl5 = false;
                        try {
                            String serviceName = (String)it.getGroupValues().get(1);
                            InetAddress ipAddress = InetAddress.getByName((String)it.getGroupValues().get(2));
                            String string = (String)it.getGroupValues().get(3);
                            boolean bl6 = false;
                            int port = Integer.parseInt(string);
                            ServiceType serviceType = StringsKt.startsWith$default((String)serviceName, (String)AdbDevicePairingServiceImpl.access$getStudioServiceNamePrefix$p(this.this$0), (boolean)false, (int)2, null) ? ServiceType.QrCode : ServiceType.PinCode;
                            InetAddress inetAddress = ipAddress;
                            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"ipAddress");
                            mdnsService2 = new MdnsService(serviceName, serviceType, inetAddress, port);
                        }
                        catch (Exception ignored) {
                            AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).warn("mDNS service entry ignored due do invalid characters: " + line2);
                            mdnsService2 = null;
                        }
                        mdnsService = mdnsService2;
                    } else {
                        mdnsService = null;
                    }
                    if (mdnsService == null) continue;
                    MdnsService mdnsService3 = mdnsService;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    MdnsService it$iv$iv = mdnsService3;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = adbDevicePairingServiceImpl;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<PairingResult> pairMdnsService(@NotNull MdnsService mdnsService, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)mdnsService, (String)"mdnsService");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.LOG.info("Start mDNS pairing: " + mdnsService);
        String deviceAddress = mdnsService.getIpAddress().getHostAddress() + ':' + mdnsService.getPort();
        StringBuilder stringBuilder = new StringBuilder().append(password);
        LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)lineSeparator, (String)"LineSeparator.getSystemLineSeparator()");
        String passwordInput = stringBuilder.append(lineSeparator.getSeparatorString()).toString();
        ListenableFuture<AdbCommandResult> futureResult = this.adbService.executeCommand(CollectionsKt.listOf((Object[])new String[]{"pair", deviceAddress}), passwordInput);
        return FutureUtils.transform(futureResult, (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<AdbCommandResult, PairingResult>(this){
            final /* synthetic */ AdbDevicePairingServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PairingResult invoke(@NotNull AdbCommandResult result2) {
                MatchResult matchResult;
                Object object;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).info("mDNS pairing exited with code " + result2.getErrorCode());
                Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)result2.getStdout(), (int)5);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void line2;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    object = (String)item$iv;
                    int index2 = n;
                    boolean bl2 = false;
                    AdbDevicePairingServiceImpl.access$getLOG$p(this.this$0).info("  stdout line #" + index2 + ": " + (String)line2);
                }
                if (result2.getErrorCode() != 0) {
                    throw (Throwable)new AdbCommandException("Error pairing device", result2.getErrorCode(), result2.getStderr());
                }
                if (result2.getStdout().isEmpty()) {
                    throw (Throwable)new AdbCommandException("Empty output from \"adb pair\" command", -1, result2.getStderr());
                }
                Regex lineRegex = new Regex("Successfully paired to ([^:]*):([0-9]*) \\[guid=([^\\]]*)\\]");
                MatchResult matchResult2 = matchResult = Regex.find$default((Regex)lineRegex, (CharSequence)result2.getStdout().get(0), (int)0, (int)2, null);
                if (matchResult2 != null) {
                    MatchResult matchResult3 = matchResult2;
                    boolean bl = false;
                    boolean bl3 = false;
                    MatchResult it = matchResult3;
                    boolean bl4 = false;
                    try {
                        InetAddress ipAddress = InetAddress.getByName((String)it.getGroupValues().get(1));
                        String index2 = (String)it.getGroupValues().get(2);
                        boolean bl5 = false;
                        int port = Integer.parseInt(index2);
                        String serviceGuid = (String)it.getGroupValues().get(3);
                        InetAddress inetAddress = ipAddress;
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"ipAddress");
                        object = new PairingResult(inetAddress, port, serviceGuid);
                    }
                    catch (Exception e) {
                        throw (Throwable)new InvalidDataException("Pairing result is invalid", (Throwable)e);
                    }
                } else {
                    throw (Throwable)new InvalidDataException("Pairing result is invalid");
                }
                return object;
            }
            {
                this.this$0 = adbDevicePairingServiceImpl;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<AdbOnlineDevice> waitForDevice(@NotNull PairingResult pairingResult) {
        Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
        return this.adbService.waitForOnlineDevice(pairingResult);
    }

    private final String createPairingString(String service, String password) {
        return "WIFI:T:ADB;S:" + service + ";P:" + password + ";;";
    }

    /*
     * WARNING - void declaration
     */
    private final String createRandomString(int charCount) {
        String charSet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-+*/<>{}";
        StringBuilder sb = new StringBuilder();
        int n = 1;
        int n2 = charCount;
        if (n <= n2) {
            while (true) {
                void i2;
                char c = charSet.charAt(this.randomProvider.nextInt(charSet.length()));
                sb.append(c);
                if (i2 == n2) break;
                ++i2;
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public AdbDevicePairingServiceImpl(@NotNull RandomProvider randomProvider2, @NotNull AdbServiceWrapper adbService2, @NotNull Executor taskExecutor2) {
        Intrinsics.checkNotNullParameter((Object)randomProvider2, (String)"randomProvider");
        Intrinsics.checkNotNullParameter((Object)adbService2, (String)"adbService");
        Intrinsics.checkNotNullParameter((Object)taskExecutor2, (String)"taskExecutor");
        this.randomProvider = randomProvider2;
        this.adbService = adbService2;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(AdbDevicePairingServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger2;
        FutureCallbackExecutor futureCallbackExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor2);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor, (String)"FutureCallbackExecutor.wrap(taskExecutor)");
        this.taskExecutor = futureCallbackExecutor;
        this.studioServiceNamePrefix = "studio-";
    }

    public static final /* synthetic */ Logger access$getLOG$p(AdbDevicePairingServiceImpl $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ String access$getStudioServiceNamePrefix$p(AdbDevicePairingServiceImpl $this) {
        return $this.studioServiceNamePrefix;
    }

    public static final /* synthetic */ String access$createRandomString(AdbDevicePairingServiceImpl $this, int charCount) {
        return $this.createRandomString(charCount);
    }

    public static final /* synthetic */ String access$createPairingString(AdbDevicePairingServiceImpl $this, String service, String password) {
        return $this.createPairingString(service, password);
    }
}

