/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.tools.idea.adb.AdbOptionsService;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class AdbConfigurableUi
implements ConfigurableUi<AdbOptionsService> {
    private JPanel myPanel;
    private JBLabel myExistingAdbServerPortLabel;
    private JBCheckBox myUseLibusbBackendCheckbox;
    private JBIntSpinner myExistingAdbServerPortSpinner;
    private JRadioButton myAutomaticallyStartAndManageServerRadioButton;
    private JRadioButton myUseExistingManuallyManagedServerRadioButton;

    public AdbConfigurableUi() {
        this.$$$setupUI$$$();
    }

    public boolean isModified(@NotNull AdbOptionsService settings) {
        if (settings == null) {
            AdbConfigurableUi.$$$reportNull$$$0(0);
        }
        return this.myUseLibusbBackendCheckbox.isSelected() != settings.shouldUseLibusb() || this.myUseExistingManuallyManagedServerRadioButton.isSelected() != settings.shouldUseUserManagedAdb() || this.getUserManagedAdbPortNumber() != settings.getUserManagedAdbPort();
    }

    public void reset(@NotNull AdbOptionsService settings) {
        if (settings == null) {
            AdbConfigurableUi.$$$reportNull$$$0(1);
        }
        this.myUseLibusbBackendCheckbox.setSelected(settings.shouldUseLibusb());
        if (settings.shouldUseUserManagedAdb()) {
            this.myUseExistingManuallyManagedServerRadioButton.setSelected(true);
        } else {
            this.myAutomaticallyStartAndManageServerRadioButton.setSelected(true);
        }
        this.myExistingAdbServerPortSpinner.setValue((Object)settings.getUserManagedAdbPort());
        this.setPortNumberUiEnabled(settings.shouldUseUserManagedAdb());
    }

    public void apply(@NotNull AdbOptionsService settings) throws ConfigurationException {
        if (settings == null) {
            AdbConfigurableUi.$$$reportNull$$$0(2);
        }
        settings.setAdbConfigs(this.myUseLibusbBackendCheckbox.isSelected(), this.myUseExistingManuallyManagedServerRadioButton.isSelected(), this.getUserManagedAdbPortNumber());
    }

    public static boolean hasComponents() {
        return AdbConfigurableUi.hasUseLibusbBackendCheckbox() || AdbConfigurableUi.hasAdbServerLifecycleManagementComponents();
    }

    @NotNull
    public JComponent getComponent() {
        assert (AdbConfigurableUi.hasComponents());
        if (!AdbConfigurableUi.hasUseLibusbBackendCheckbox()) {
            this.myPanel.remove((Component)this.myUseLibusbBackendCheckbox);
        }
        if (!AdbConfigurableUi.hasAdbServerLifecycleManagementComponents()) {
            this.myPanel.remove((Component)this.myExistingAdbServerPortSpinner);
            this.myPanel.remove(this.myAutomaticallyStartAndManageServerRadioButton);
            this.myPanel.remove(this.myUseExistingManuallyManagedServerRadioButton);
        }
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AdbConfigurableUi.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myExistingAdbServerPortSpinner = new JBIntSpinner(5038, 5038, 65535);
        this.myExistingAdbServerPortLabel = new JBLabel();
        this.myAutomaticallyStartAndManageServerRadioButton = new JRadioButton();
        this.myAutomaticallyStartAndManageServerRadioButton.addActionListener(event -> this.setPortNumberUiEnabled(false));
        this.myUseExistingManuallyManagedServerRadioButton = new JRadioButton();
        this.myUseExistingManuallyManagedServerRadioButton.addActionListener(event -> this.setPortNumberUiEnabled(true));
    }

    private void setPortNumberUiEnabled(boolean enabled) {
        this.myExistingAdbServerPortSpinner.setEnabled(enabled);
        this.myExistingAdbServerPortLabel.setEnabled(enabled);
    }

    private int getUserManagedAdbPortNumber() {
        return this.myExistingAdbServerPortSpinner.getNumber();
    }

    private static boolean hasUseLibusbBackendCheckbox() {
        return SystemInfo.isMac || SystemInfo.isLinux;
    }

    private static boolean hasAdbServerLifecycleManagementComponents() {
        return (Boolean)StudioFlags.ADB_SERVER_MANAGEMENT_MODE_SETTINGS_VISIBLE.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/adb/AdbConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/adb/AdbConfigurableUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseLibusbBackendCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(true);
        jBCheckBox.setText("Use libusb backend");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JRadioButton jRadioButton = this.myAutomaticallyStartAndManageServerRadioButton;
        jRadioButton.setText("Automatically start and manage server");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton2 = this.myUseExistingManuallyManagedServerRadioButton;
        ((Component)jRadioButton2).setEnabled(true);
        jRadioButton2.setText("Use existing manually managed server");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = this.myExistingAdbServerPortLabel;
        jBLabel.setText(" Existing ADB server port:");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null, 2));
        JBIntSpinner jBIntSpinner = this.myExistingAdbServerPortSpinner;
        jBIntSpinner.setMax(65535);
        jBIntSpinner.setMin(5038);
        jBIntSpinner.setNumber(5038);
        jBIntSpinner.setOpaque(false);
        jPanel2.add((Component)jBIntSpinner, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("ADB server lifecycle management");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

