/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.annotations;

import com.android.tools.idea.actions.annotations.InferSupportAnnotations;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferSupportAnnotationsAction
extends BaseAnalysisAction {
    static final boolean ENABLED = Boolean.valueOf(System.getProperty("studio.infer.annotations"));
    static final int MAX_PASSES = 3;
    @NonNls
    private static final String INFER_SUPPORT_ANNOTATIONS = "Infer Support Annotations";
    private static final int MAX_ANNOTATIONS_WITHOUT_PREVIEW = 5;
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    public InferSupportAnnotationsAction() {
        super(INFER_SUPPORT_ANNOTATIONS, INFER_SUPPORT_ANNOTATIONS);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(0);
        }
        if (!ENABLED) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (event.getProject() == null || !ProjectFacetManager.getInstance((Project)event.getProject()).hasFacets(AndroidFacet.ID)) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(event);
        Project project = event.getProject();
        if (project == null || !GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(false);
        }
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope2) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(2);
        }
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return;
        }
        int[] fileCount2 = new int[]{0};
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = InferSupportAnnotationsAction.findUsages(project, scope2, fileCount2[0]);
        if (usageInfos == null) {
            return;
        }
        Map<Module, PsiFile> modules = InferSupportAnnotationsAction.findModulesFromUsage(usageInfos);
        if (!this.checkModules(project, scope2, modules)) {
            return;
        }
        if (usageInfos.length < 5) {
            ApplicationManager.getApplication().invokeLater(InferSupportAnnotationsAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)));
        } else {
            InferSupportAnnotationsAction.showUsageView(project, usageInfos, scope2);
        }
    }

    private static Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        HashMap<Module, PsiFile> modules = new HashMap<Module, PsiFile>();
        for (UsageInfo info2 : infos) {
            PsiElement element2 = info2.getElement();
            assert (element2 != null);
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
            if (module2 == null) continue;
            PsiFile file2 = element2.getContainingFile();
            modules.put(module2, file2);
        }
        return modules;
    }

    private static UsageInfo[] findUsages(final @NotNull Project project, @NotNull AnalysisScope scope2, final int fileCount2) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(4);
        }
        final InferSupportAnnotations inferrer = new InferSupportAnnotations(false, project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        Runnable searchForUsages = () -> scope2.accept(new PsiElementVisitor(){
            int myFileCount = 0;

            public void visitFile(@NotNull PsiFile file2) {
                Document document;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ++this.myFileCount;
                VirtualFile virtualFile = file2.getVirtualFile();
                FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                if (document == null || virtualFile.getFileType().isBinary()) {
                    return;
                }
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    progressIndicator.setFraction((double)this.myFileCount / (double)(3 * fileCount2));
                }
                if (file2 instanceof PsiJavaFile) {
                    inferrer.collect(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$1", "visitFile"));
            }
        });
        Runnable multipass = () -> {
            for (int i2 = 0; i2 < 3; ++i2) {
                searchForUsages.run();
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(multipass, INFER_SUPPORT_ANNOTATIONS, true, project)) {
                return null;
            }
        } else {
            multipass.run();
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        inferrer.collect(usages, scope2);
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(@NotNull Project project, @NotNull AnalysisScope scope2, @NotNull Map<Module, PsiFile> modules) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(6);
        }
        if (modules == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(7);
        }
        HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module2 : modules.keySet()) {
            GradleBuildModel buildModel;
            AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(module2);
            if (info2 != null && info2.getBuildSdkVersion() != null && info2.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module2);
            }
            if ((buildModel = GradleBuildModel.get((Module)module2)) == null) {
                Logger.getInstance(InferSupportAnnotationsAction.class).warn("Unable to find Gradle build model for module " + AndroidRootUtil.getModuleDirPath(module2));
                continue;
            }
            boolean dependencyFound = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module2), false);
                for (ArtifactDependencyModel dependency : dependenciesModel.artifacts(configurationName)) {
                    String notation = dependency.compactNotation();
                    if (!notation.startsWith("com.android.support:appcompat-v7") && !notation.startsWith("androidx.appcompat:appcompat") && !notation.startsWith("com.android.support:support-v4") && !notation.startsWith("androidx.legacy:legacy-support-v4") && !notation.startsWith("androidx.annotation:annotation") && !notation.startsWith("com.android.support:support-annotations")) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module2);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format(Locale.US, "Infer Support Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_SUPPORT_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message2 = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.getMavenArtifactId(), StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message2, (String)"Infer Nullity Annotations", (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
                    RepositoryUrlManager manager = RepositoryUrlManager.get();
                    GoogleMavenArtifactId annotation = MigrateToAndroidxUtil.isAndroidx(project) ? GoogleMavenArtifactId.ANDROIDX_SUPPORT_ANNOTATIONS : GoogleMavenArtifactId.SUPPORT_ANNOTATIONS;
                    String annotationsLibraryCoordinate = manager.getArtifactStringCoordinate(annotation, true);
                    for (Module module2 : modulesWithoutAnnotations) {
                        InferSupportAnnotationsAction.addDependency(module2, annotationsLibraryCoordinate);
                    }
                    this.syncAndRestartAnalysis(project, scope2);
                });
            }
            finally {
                action2.finish();
            }
        }
        return false;
    }

    private void syncAndRestartAnalysis(final @NotNull Project project, final @NotNull AnalysisScope scope2) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(9);
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                if (syncResult != null && syncResult.isSuccessful()) {
                    InferSupportAnnotationsAction.this.restartAnalysis(project, scope2);
                }
            }

            public void onFailure(@Nullable Throwable t) {
                throw new RuntimeException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static Runnable applyRunnable(Project project, Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(INFER_SUPPORT_ANNOTATIONS);
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(INFER_SUPPORT_ANNOTATIONS).run(() -> {
                    UsageInfo[] infos = (UsageInfo[])computable.compute();
                    if (infos.length > 0) {
                        LinkedHashSet elements = new LinkedHashSet();
                        for (UsageInfo info2 : infos) {
                            PsiFile containingFile;
                            VirtualFile virtualFile;
                            PsiElement element2 = info2.getElement();
                            if (element2 == null || (virtualFile = (containingFile = element2.getContainingFile()).getVirtualFile()).getFileType().isBinary()) continue;
                            ContainerUtil.addIfNotNull(elements, (Object)containingFile);
                        }
                        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                            return;
                        }
                        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, INFER_SUPPORT_ANNOTATIONS, false);
                        progressTask.setMinIterationTime(200L);
                        progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                        ProgressManager.getInstance().run((Task)progressTask);
                    } else {
                        InferSupportAnnotations.nothingFoundMessage(project);
                    }
                });
            }
            finally {
                action2.finish();
            }
        };
    }

    private void restartAnalysis(Project project, AnalysisScope scope2) {
        ApplicationManager.getApplication().invokeLater(() -> this.analyze(project, scope2));
    }

    private static void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope2) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(10);
        }
        if (scope2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(11);
        }
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, InferSupportAnnotationsAction.rerunFactory(project, scope2));
        Runnable refactoringRunnable2 = InferSupportAnnotationsAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(UsageInfo.EMPTY_ARRAY);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable2, INFER_SUPPORT_ANNOTATIONS, canNotMakeString, INFER_SUPPORT_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope2) {
        if (project == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(13);
        }
        Factory factory2 = () -> new UsageInfoSearcherAdapter(){

            @NotNull
            protected UsageInfo[] findUsages() {
                UsageInfo[] usageInfoArray = (UsageInfo[])ObjectUtils.notNull((Object)InferSupportAnnotationsAction.findUsages(project, scope2, scope2.getFileCount()), (Object)UsageInfo.EMPTY_ARRAY);
                if (usageInfoArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return usageInfoArray;
            }

            public void generate(@NotNull Processor<? super Usage> processor) {
                if (processor == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.processUsages(processor, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findUsages";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "generate";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (factory2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(14);
        }
        return factory2;
    }

    private static void addDependency(@NotNull Module module2, @Nullable String libraryCoordinate) {
        if (module2 == null) {
            InferSupportAnnotationsAction.$$$reportNull$$$0(15);
        }
        if (StringUtil.isNotEmpty((String)libraryCoordinate)) {
            ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
                GradleBuildModel buildModel = GradleBuildModel.get((Module)module2);
                if (buildModel != null) {
                    String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module2), false);
                    buildModel.dependencies().addArtifact(name, libraryCoordinate);
                    buildModel.applyChanges();
                }
            });
        }
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog2) {
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return super.getAdditionalActionSettings(project, dialog2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotationsAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "rerunFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "syncAndRestartAnalysis";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rerunFactory";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AnnotateTask
    implements SequentialTask {
        private final Project myProject;
        private UsageInfo[] myInfos;
        private final SequentialModalProgressTask myTask;
        private int myCount = 0;
        private final int myTotal;

        public AnnotateTask(Project project, SequentialModalProgressTask progressTask, UsageInfo[] infos) {
            this.myProject = project;
            this.myInfos = infos;
            this.myTask = progressTask;
            this.myTotal = infos.length;
        }

        public boolean isDone() {
            return this.myCount > this.myTotal - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.myTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.myCount / (double)this.myTotal);
            }
            InferSupportAnnotations.apply(this.myProject, this.myInfos[this.myCount++]);
            boolean done = this.isDone();
            if (this.isDone()) {
                try {
                    this.showReport();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return done;
        }

        public void showReport() {
            String report2 = InferSupportAnnotations.generateReport(this.myInfos);
            String fileName = "Annotation Inference Report";
            ScratchFileService.Option option = ScratchFileService.Option.create_new_always;
            VirtualFile f = ScratchRootType.getInstance().createScratchFile(this.myProject, fileName, (Language)PlainTextLanguage.INSTANCE, report2, option);
            if (f != null) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(f, true);
            }
        }
    }
}

