/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.utils.concurrency.CachedAsyncSupplier;
import com.google.common.collect.Maps;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenProjectFileChooserDescriptorWithAsyncIcon
extends OpenProjectFileChooserDescriptor
implements Disposable {
    private final Map<VirtualFile, Icon> myIconCache = Maps.newConcurrentMap();

    public OpenProjectFileChooserDescriptorWithAsyncIcon() {
        super(true);
    }

    public Icon getIcon(VirtualFile file2) {
        return this.myIconCache.computeIfAbsent(file2, key -> {
            Icon placeholder = OpenProjectFileChooserDescriptorWithAsyncIcon.dressIcon((VirtualFile)key, (Icon)IconUtil.getIcon((VirtualFile)key, (int)2, null));
            CachedAsyncSupplier asyncIconSupplier = new CachedAsyncSupplier(() -> Disposer.isDisposed((Disposable)this) ? placeholder : super.getIcon(key), AndroidIoManager.getInstance().getBackgroundDiskIoExecutor());
            AsyncIcon icon2 = new AsyncIcon(placeholder, (CachedAsyncSupplier<Icon>)asyncIconSupplier);
            return icon2;
        });
    }

    public void dispose() {
        this.myIconCache.clear();
    }

    private static class AsyncIcon
    implements Icon {
        @NotNull
        private final Icon myPlaceholderIcon;
        @NotNull
        private final CachedAsyncSupplier<Icon> myIconAsyncSupplier;

        AsyncIcon(@NotNull Icon placeholderIcon, @NotNull CachedAsyncSupplier<Icon> iconAsyncSupplier) {
            if (placeholderIcon == null) {
                AsyncIcon.$$$reportNull$$$0(0);
            }
            if (iconAsyncSupplier == null) {
                AsyncIcon.$$$reportNull$$$0(1);
            }
            this.myPlaceholderIcon = placeholderIcon;
            this.myIconAsyncSupplier = iconAsyncSupplier;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getIcon().getIconHeight();
        }

        private final Icon getIcon() {
            Icon icon2 = (Icon)this.myIconAsyncSupplier.getNow();
            return icon2 != null ? icon2 : this.myPlaceholderIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "placeholderIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iconAsyncSupplier";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/actions/OpenProjectFileChooserDescriptorWithAsyncIcon$AsyncIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

