/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.actions.OpenProjectFileChooserDescriptorWithAsyncIcon;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import java.io.File;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidOpenFileAction
extends DumbAwareAction {
    public AndroidOpenFileAction() {
        this("Open...");
    }

    public AndroidOpenFileAction(@NotNull String text2) {
        if (text2 == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(0);
        }
        super(text2);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Actions.MenuOpen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(2);
        }
        Disposable disposable2 = Disposer.newDisposable();
        try {
            VirtualFile explicitPreferredDirectory;
            Project project = e.getProject();
            boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
            OpenProjectFileChooserDescriptorWithAsyncIcon descriptor2 = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
            descriptor2.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, showFiles);
            Disposer.register((Disposable)disposable2, (Disposable)descriptor2);
            VirtualFile virtualFile = explicitPreferredDirectory = project != null && !project.isDefault() ? project.getBaseDir() : null;
            if (explicitPreferredDirectory == null) {
                explicitPreferredDirectory = StringUtil.isNotEmpty((String)GeneralSettings.getInstance().getDefaultProjectDirectory()) ? VfsUtil.findFileByIoFile((File)new File(GeneralSettings.getInstance().getDefaultProjectDirectory()), (boolean)true) : VfsUtil.getUserHomeDir();
            }
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)explicitPreferredDirectory, files2 -> {
                ValidationIssue issue2 = AndroidOpenFileAction.validateFiles(files2, (FileChooserDescriptor)descriptor2);
                if (issue2.result.getSeverity() != Validator.Severity.OK) {
                    boolean isError = issue2.result.getSeverity() == Validator.Severity.ERROR;
                    String title = isError ? IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]) : "Warning Opening Project";
                    Messages.showInfoMessage((Project)project, (String)issue2.result.getMessage(), (String)title);
                    if (isError) {
                        return;
                    }
                }
                AndroidOpenFileAction.doOpenFile(e, files2);
            });
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    @VisibleForTesting
    @NotNull
    static ValidationIssue validateFiles(List<VirtualFile> files2, FileChooserDescriptor descriptor2) {
        for (VirtualFile file2 : files2) {
            if (descriptor2.isFileSelectable(file2)) continue;
            Validator.Result result2 = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("title.cannot.open.file", file2.getPresentableUrl()));
            return new ValidationIssue(result2, file2);
        }
        return new ValidationIssue(Validator.Result.OK, null);
    }

    private static void doOpenFile(@NotNull AnActionEvent e, @NotNull List<VirtualFile> result2) {
        if (e == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        for (VirtualFile file2 : result2) {
            if (file2.isDirectory()) {
                if (project != null && !project.isDefault() && file2.equals(project.getBaseDir())) {
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    return;
                }
                if (ProjectAttachProcessor.canAttachToProject()) {
                    Project openedProject = PlatformProjectOpenProcessor.doOpenProject((VirtualFile)file2, (Project)project, (int)-1, null, EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class));
                    FileChooserUtil.setLastOpenedFile((Project)openedProject, (Path)file2.toNioPath());
                } else {
                    AndroidOpenFileAction.openOrImportProject(file2.toNioPath(), project);
                }
                return;
            }
            if ((project == null || !file2.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile((VirtualFile)file2) && AndroidOpenFileAction.openOrImportProject(file2.toNioPath(), project)) {
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file2, (Project)project);
            if (type == null) {
                return;
            }
            if (project != null) {
                OpenFileAction.openFile((VirtualFile)file2, (Project)project);
                continue;
            }
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor == null) continue;
            processor.doOpenProject(file2, null, false);
        }
    }

    private static boolean openOrImportProject(@NotNull Path file2, @Nullable Project project) {
        Project opened;
        if (file2 == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(5);
        }
        if ((opened = ProjectUtil.openOrImport((Path)file2, (Project)project, (boolean)false)) != null) {
            FileChooserUtil.setLastOpenedFile((Project)opened, (Path)file2);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/actions/AndroidOpenFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openOrImportProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptorWithAsyncIcon {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        public ProjectOrFileChooserDescriptor() {
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptorWithAsyncIcon {
        public ProjectOnlyFileChooserDescriptor() {
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }

    @VisibleForTesting
    static final class ValidationIssue {
        @NotNull
        Validator.Result result;
        @Nullable
        VirtualFile file;

        public ValidationIssue(@NotNull Validator.Result result2, @Nullable VirtualFile file2) {
            if (result2 == null) {
                ValidationIssue.$$$reportNull$$$0(0);
            }
            this.result = result2;
            this.file = file2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/AndroidOpenFileAction$ValidationIssue", "<init>"));
        }
    }
}

