/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.impl;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.componenttree.api.ViewNodeType;
import com.android.tools.componenttree.impl.TreeImpl;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0015\u0016B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/componenttree/impl/ViewTreeCellRenderer;", "T", "Ljavax/swing/tree/TreeCellRenderer;", "type", "Lcom/android/tools/componenttree/api/ViewNodeType;", "(Lcom/android/tools/componenttree/api/ViewNodeType;)V", "renderer", "Lcom/android/tools/componenttree/impl/ViewTreeCellRenderer$ColoredViewRenderer;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "ColoredViewRenderer", "Companion", "intellij.android.layout-ui"})
public final class ViewTreeCellRenderer<T>
implements TreeCellRenderer {
    private final ColoredViewRenderer renderer;
    private final ViewNodeType<T> type;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.renderer.reset();
        Object t = this.type.getClazz().cast(value2);
        if (t == null) {
            return (Component)((Object)this.renderer);
        }
        Object node2 = t;
        JTree jTree = tree;
        if (!(jTree instanceof TreeImpl)) {
            jTree = null;
        }
        this.renderer.setCurrentTree((TreeImpl)((Object)jTree));
        this.renderer.setCurrentRow(row);
        this.renderer.setSelectedValue(selected);
        this.renderer.setFocusedValue(tree.hasFocus() && selected);
        this.renderer.setId(ViewTreeCellRenderer.Companion.stripId(this.type.idOf(node2)));
        this.renderer.setTagName(StringsKt.substringAfterLast$default((String)this.type.tagNameOf(node2), (char)'.', null, (int)2, null));
        this.renderer.setTextValue(this.type.textValueOf(node2));
        this.renderer.setTreeIcon(this.type.iconOf(node2));
        this.renderer.setEnabledValue(this.type.isEnabled(node2));
        this.renderer.generate();
        return (Component)((Object)this.renderer);
    }

    public ViewTreeCellRenderer(@NotNull ViewNodeType<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.renderer = new ColoredViewRenderer();
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00101\u001a\u000202H\u0007J*\u00103\u001a\u00020\u00142\b\u00104\u001a\u0004\u0018\u00010\u001d2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\bH\u0002J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u00105\u001a\u000206H\u0002J\u0006\u0010<\u001a\u000202J\u0010\u0010<\u001a\u0002022\u0006\u00108\u001a\u00020\bH\u0002J\b\u0010=\u001a\u00020\u001dH\u0002J\u0010\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020@H\u0014J\u0006\u0010A\u001a\u000202J\b\u0010B\u001a\u00020\u0014H\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001c\u0010(\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006C"}, d2={"Lcom/android/tools/componenttree/impl/ViewTreeCellRenderer$ColoredViewRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "()V", "baseFontMetrics", "Ljava/awt/FontMetrics;", "kotlin.jvm.PlatformType", "boldFontMetrics", "currentRow", "", "getCurrentRow", "()I", "setCurrentRow", "(I)V", "currentTree", "Lcom/android/tools/componenttree/impl/TreeImpl;", "getCurrentTree", "()Lcom/android/tools/componenttree/impl/TreeImpl;", "setCurrentTree", "(Lcom/android/tools/componenttree/impl/TreeImpl;)V", "enabledValue", "", "getEnabledValue", "()Z", "setEnabledValue", "(Z)V", "focusedValue", "getFocusedValue", "setFocusedValue", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "selectedValue", "getSelectedValue", "setSelectedValue", "tagName", "getTagName", "setTagName", "textValue", "getTextValue", "setTextValue", "treeIcon", "Ljavax/swing/Icon;", "getTreeIcon", "()Ljavax/swing/Icon;", "setTreeIcon", "(Ljavax/swing/Icon;)V", "adjustForPainting", "", "append", "text", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "metrics", "maxWidth", "deriveFont", "Ljava/awt/Font;", "font", "generate", "generateTooltip", "paintComponent", "g", "Ljava/awt/Graphics;", "reset", "shouldPaintBackground", "intellij.android.layout-ui"})
    public static final class ColoredViewRenderer
    extends SimpleColoredRenderer {
        @Nullable
        private TreeImpl currentTree;
        private int currentRow = -1;
        private boolean selectedValue;
        private boolean focusedValue;
        @Nullable
        private String id;
        @NotNull
        private String tagName = "";
        @Nullable
        private String textValue;
        @Nullable
        private Icon treeIcon;
        private boolean enabledValue = true;
        private final FontMetrics baseFontMetrics = this.getFontMetrics(UIUtil.getLabelFont());
        private final FontMetrics boldFontMetrics;

        @Nullable
        public final TreeImpl getCurrentTree() {
            return this.currentTree;
        }

        public final void setCurrentTree(@Nullable TreeImpl treeImpl) {
            this.currentTree = treeImpl;
        }

        public final int getCurrentRow() {
            return this.currentRow;
        }

        public final void setCurrentRow(int n) {
            this.currentRow = n;
        }

        public final boolean getSelectedValue() {
            return this.selectedValue;
        }

        public final void setSelectedValue(boolean bl) {
            this.selectedValue = bl;
        }

        public final boolean getFocusedValue() {
            return this.focusedValue;
        }

        public final void setFocusedValue(boolean bl) {
            this.focusedValue = bl;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        public final void setId(@Nullable String string) {
            this.id = string;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public final void setTagName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.tagName = string;
        }

        @Nullable
        public final String getTextValue() {
            return this.textValue;
        }

        public final void setTextValue(@Nullable String string) {
            this.textValue = string;
        }

        @Nullable
        public final Icon getTreeIcon() {
            return this.treeIcon;
        }

        public final void setTreeIcon(@Nullable Icon icon2) {
            this.treeIcon = icon2;
        }

        public final boolean getEnabledValue() {
            return this.enabledValue;
        }

        public final void setEnabledValue(boolean bl) {
            this.enabledValue = bl;
        }

        protected boolean shouldPaintBackground() {
            return false;
        }

        public final void reset() {
            this.clear();
            this.currentTree = null;
            this.currentRow = -1;
            this.id = null;
            this.tagName = "";
            this.textValue = null;
        }

        public final void generate() {
            this.generate(0);
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.currentTree != null) {
                this.adjustForPainting();
            }
            super.paintComponent(g);
        }

        private final void generate(int maxWidth) {
            block7: {
                boolean bl;
                boolean bl2;
                CharSequence charSequence;
                SimpleTextAttributes attributes;
                block6: {
                    block5: {
                        this.clear();
                        this.setIcon(this.treeIcon);
                        this.setToolTipText(this.generateTooltip());
                        SimpleTextAttributes simpleTextAttributes = attributes = !this.enabledValue ? SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes");
                        FontMetrics fontMetrics = this.boldFontMetrics;
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"boldFontMetrics");
                        if (!this.append(this.id, simpleTextAttributes, fontMetrics, maxWidth)) {
                            return;
                        }
                        if (this.id == null) break block5;
                        charSequence = this.textValue;
                        bl2 = false;
                        bl = false;
                        if (!(charSequence == null || charSequence.length() == 0)) break block6;
                    }
                    String tagText = this.id != null ? " - " + this.tagName : this.tagName;
                    SimpleTextAttributes simpleTextAttributes = attributes = !this.enabledValue ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes");
                    FontMetrics fontMetrics = this.baseFontMetrics;
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"baseFontMetrics");
                    if (!this.append(tagText, simpleTextAttributes, fontMetrics, maxWidth)) {
                        return;
                    }
                }
                attributes = !this.selectedValue || !this.enabledValue ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                String string = this.textValue;
                if (string == null || (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) == null) break block7;
                charSequence = string;
                bl2 = false;
                bl = false;
                CharSequence it = charSequence;
                boolean bl3 = false;
                String string2 = " - \"" + (String)it + '\"';
                SimpleTextAttributes simpleTextAttributes = attributes;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes");
                FontMetrics fontMetrics = this.baseFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"baseFontMetrics");
                this.append(string2, simpleTextAttributes, fontMetrics, maxWidth);
            }
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        public final void adjustForPainting() {
            Icon icon2;
            int maxWidth = this.getWidth() - this.getX();
            if (this.getPreferredSize().width > maxWidth) {
                TreeImpl treeImpl = this.currentTree;
                if (treeImpl == null || !treeImpl.isRowCurrentlyExpanded(this.currentRow)) {
                    this.generate(maxWidth);
                }
            }
            this.setForeground(UIUtil.getTreeForeground((boolean)this.selectedValue, (boolean)this.focusedValue));
            this.setBackground(UIUtil.getTreeBackground((boolean)this.selectedValue, (boolean)this.focusedValue));
            ColoredViewRenderer coloredViewRenderer = this;
            Icon icon3 = this.treeIcon;
            if (icon3 != null) {
                void it;
                Icon icon4 = icon3;
                boolean bl = false;
                boolean bl2 = false;
                Icon icon5 = icon4;
                ColoredViewRenderer coloredViewRenderer2 = coloredViewRenderer;
                boolean bl3 = false;
                Icon icon6 = this.focusedValue ? ColoredIconGenerator.generateWhiteIcon((Icon)it) : it;
                coloredViewRenderer = coloredViewRenderer2;
                icon2 = icon6;
            } else {
                icon2 = null;
            }
            coloredViewRenderer.setIcon(icon2);
            this.setTransparentIconBackground(true);
        }

        private final boolean append(String text2, SimpleTextAttributes attributes, FontMetrics metrics, int maxWidth) {
            String string = text2;
            if (string == null) {
                return true;
            }
            String actual = string;
            boolean unchanged = true;
            if (maxWidth > 0) {
                int availableSpace = maxWidth - this.getPreferredSize().width;
                if (metrics.stringWidth(actual) > availableSpace) {
                    String string2 = AdtUiUtils.shrinkToFit((String)text2, (FontMetrics)metrics, (float)availableSpace);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"AdtUiUtils.shrinkToFit(t\u2026availableSpace.toFloat())");
                    actual = string2;
                    unchanged = Intrinsics.areEqual((Object)actual, (Object)text2) ^ true;
                }
            }
            this.append(actual, attributes);
            return unchanged;
        }

        private final String generateTooltip() {
            CharSequence charSequence;
            boolean bl;
            CharSequence charSequence2;
            if (this.id == null) {
                charSequence2 = this.textValue;
                bl = false;
                charSequence = charSequence2;
                if (charSequence == null) {
                    charSequence = "";
                }
            } else if (this.textValue == null) {
                charSequence2 = this.id;
                bl = false;
                charSequence = charSequence2;
                if (charSequence == null) {
                    charSequence = "";
                }
            } else {
                charSequence = this.id + ": \"" + this.textValue + '\"';
            }
            String text2 = charSequence;
            charSequence2 = text2;
            bl = false;
            if (charSequence2.length() == 0) {
                return this.tagName;
            }
            return StringsKt.trimIndent((String)("\n        <html>\n          " + this.tagName + "<br/>\n          " + text2 + "\n        </html>\n        "));
        }

        private final Font deriveFont(Font font, SimpleTextAttributes attributes) {
            if (font.getStyle() == attributes.getFontStyle() && !attributes.isSmaller()) {
                return font;
            }
            float size = attributes.isSmaller() ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : font.getSize2D();
            Font font2 = font.deriveFont(attributes.getFontStyle(), size);
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font.deriveFont(attributes.fontStyle, size)");
            return font2;
        }

        public ColoredViewRenderer() {
            Font font = UIUtil.getLabelFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"UIUtil.getLabelFont()");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES");
            this.boldFontMetrics = this.getFontMetrics(this.deriveFont(font, simpleTextAttributes));
            this.setFont(UIUtil.getLabelFont());
            this.setIpad((Insets)JBUI.emptyInsets());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/componenttree/impl/ViewTreeCellRenderer$Companion;", "", "()V", "computeSearchString", "", "T", "type", "Lcom/android/tools/componenttree/api/ViewNodeType;", "node", "(Lcom/android/tools/componenttree/api/ViewNodeType;Ljava/lang/Object;)Ljava/lang/String;", "stripId", "id", "intellij.android.layout-ui"})
    public static final class Companion {
        @NotNull
        public final <T> String computeSearchString(@NotNull ViewNodeType<T> type, T node2) {
            String str;
            block3: {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                String id = type.idOf(node2);
                String textValue = type.textValueOf(node2);
                String string = this.stripId(id);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = str = "";
                }
                if (id == null || textValue == null) {
                    if (id != null) {
                        str = str + " - ";
                    }
                    str = str + StringsKt.substringAfterLast$default((String)type.tagNameOf(node2), (char)'.', null, (int)2, null);
                }
                String string3 = textValue;
                if (string3 == null) break block3;
                string = string3;
                bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                str = str + " - \"" + it + '\"';
            }
            return str;
        }

        private final String stripId(String id) {
            String string = id;
            return string != null ? StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

