/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface CriticalPathChartLegend {
    public static final ChartColor OTHER_TASKS_COLOR = new ChartColor(new Color(10674174));
    public static final Color OTHER_TASKS_TEXT_COLOR = Color.BLACK;
    public static final ChartColor androidPluginColor = new ChartColor(new Color(10674174));
    public static final ChartColor externalPluginColor = new ChartColor(new Color(38901));
    public static final ChartColor buildsrcPluginColor = new ChartColor(new Color(10980313));
    public static final ChartColor[] categoricalGooglePalette = new ChartColor[]{new ChartColor(new Color(9941440)), new ChartColor(new Color(10674174)), new ChartColor(new Color(16227438)), new ChartColor(new Color(7660168)), new ChartColor(new Color(10980313)), new ChartColor(new Color(15101850)), new ChartColor(new Color(5432783)), new ChartColor(new Color(14666911)), new ChartColor(new Color(37844)), new ChartColor(new Color(1412991)), new ChartColor(new Color(8539103)), new ChartColor(new Color(12670746)), new ChartColor(new Color(3365529)), new ChartColor(new Color(11381816)), new ChartColor(new Color(12073102)), new ChartColor(new Color(1735423))};
    public static final PluginColorPalette pluginColorPalette = new PluginColorPalette();

    public static ChartColor resolveTaskColor(TaskUiData taskData) {
        switch (taskData.getSourceType()) {
            case BUILD_SRC: {
                return buildsrcPluginColor;
            }
            case ANDROID_PLUGIN: {
                return androidPluginColor;
            }
            case THIRD_PARTY: {
                return externalPluginColor;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + taskData.getSourceType());
    }

    public static class PluginColorPalette {
        private int paletteCursor = 0;
        private Map<String, ChartColor> pluginToColorMapping = new HashMap<String, ChartColor>();

        public void reset() {
            this.paletteCursor = 0;
            this.pluginToColorMapping.clear();
        }

        @NotNull
        public ChartColor getColor(@NotNull String name) {
            if (name == null) {
                PluginColorPalette.$$$reportNull$$$0(0);
            }
            ChartColor chartColor = this.pluginToColorMapping.computeIfAbsent(name, key -> categoricalGooglePalette[Math.min(this.paletteCursor++, categoricalGooglePalette.length)]);
            if (chartColor == null) {
                PluginColorPalette.$$$reportNull$$$0(1);
            }
            return chartColor;
        }

        @NotNull
        public ChartColor getOneColorForAll(@NotNull ArrayList<CriticalPathPluginUiData> aggregatedPlugins) {
            if (aggregatedPlugins == null) {
                PluginColorPalette.$$$reportNull$$$0(2);
            }
            ChartColor otherPluginsGroupColor = this.getColor("Other");
            aggregatedPlugins.forEach(plugin -> this.pluginToColorMapping.put(plugin.getName(), otherPluginsGroupColor));
            ChartColor chartColor = otherPluginsGroupColor;
            if (chartColor == null) {
                PluginColorPalette.$$$reportNull$$$0(3);
            }
            return chartColor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/build/attribution/ui/panels/CriticalPathChartLegend$PluginColorPalette";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aggregatedPlugins";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/build/attribution/ui/panels/CriticalPathChartLegend$PluginColorPalette";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOneColorForAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColor";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getOneColorForAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ChartColor {
        public final Color baseColor;
        public final Color selectionColor;

        public ChartColor(Color baseColor) {
            this.baseColor = baseColor;
            this.selectionColor = new Color(baseColor.getRed() / 2, baseColor.getGreen() / 2, baseColor.getBlue() / 2);
        }
    }
}

