/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.model.TaskDetailsPageType;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModelImpl$WhenMappings;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreeNode;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TasksTreeStructure;
import com.google.common.annotations.VisibleForTesting;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0006H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020)H\u0016J\b\u0010<\u001a\u00020\u0019H\u0002J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020\"H\u0016J\u0012\u0010?\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020)H\u0016J\u001c\u0010C\u001a\u00020\u00192\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u0015H\u0016J\u0010\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020GH\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R`\u0010\u001a\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00152#\u0010\u0014\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00158\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001e\u0010*\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020)@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000fR\u0014\u0010/\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000fR\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/android/build/attribution/ui/model/TasksDataPageModelImpl;", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;)V", "value", "Lcom/android/build/attribution/ui/model/TasksFilter;", "filter", "getFilter", "()Lcom/android/build/attribution/ui/model/TasksFilter;", "setFilter", "(Lcom/android/build/attribution/ui/model/TasksFilter;)V", "filteredTimeString", "", "getFilteredTimeString", "()Ljava/lang/String;", "isEmpty", "", "()Z", "modelChanged", "<set-?>", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "treeStructureChanged", "", "modelUpdatedListener", "getModelUpdatedListener$annotations", "()V", "getModelUpdatedListener", "()Lkotlin/jvm/functions/Function1;", "getReportData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "selectedGrouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "getSelectedGrouping", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "selectedNode", "Lcom/android/build/attribution/ui/model/TasksTreeNode;", "getSelectedNode", "()Lcom/android/build/attribution/ui/model/TasksTreeNode;", "Lcom/android/build/attribution/ui/model/TasksPageId;", "selectedPageId", "setSelectedPageId", "(Lcom/android/build/attribution/ui/model/TasksPageId;)V", "totalTimeString", "getTotalTimeString", "treeHeaderText", "getTreeHeaderText", "treeRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getTreeRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "treeStructure", "Lcom/android/build/attribution/ui/model/TasksTreeStructure;", "applyFilter", "newFilter", "getNodeDescriptorById", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "pageId", "notifyModelChanges", "selectGrouping", "newSelectedGrouping", "selectNode", "tasksTreeNode", "selectPageById", "tasksPageId", "setModelUpdatedListener", "listener", "warningsSuffixFromCount", "warningCount", "", "intellij.android.build-attribution"})
public final class TasksDataPageModelImpl
implements TasksDataPageModel {
    @Nullable
    private Function1<? super Boolean, Unit> modelUpdatedListener;
    @NotNull
    private TasksFilter filter;
    private boolean modelChanged;
    private boolean treeStructureChanged;
    private TasksPageId selectedPageId;
    private final TasksTreeStructure treeStructure;
    @NotNull
    private final BuildAttributionReportUiData reportData;

    @VisibleForTesting
    public static /* synthetic */ void getModelUpdatedListener$annotations() {
    }

    @Nullable
    public final Function1<Boolean, Unit> getModelUpdatedListener() {
        return this.modelUpdatedListener;
    }

    @Override
    @NotNull
    public TasksDataPageModel.Grouping getSelectedGrouping() {
        return this.selectedPageId.getGrouping();
    }

    @Override
    @NotNull
    public String getTreeHeaderText() {
        String string;
        switch (TasksDataPageModelImpl$WhenMappings.$EnumSwitchMapping$0[this.getSelectedGrouping().ordinal()]) {
            case 1: {
                string = "Tasks determining build duration" + " - Total: " + this.getTotalTimeString() + ", Filtered: " + this.getFilteredTimeString() + this.warningsSuffixFromCount(this.treeStructure.getTreeStats().getVisibleWarnings());
                break;
            }
            case 2: {
                string = "Plugins with tasks determining build duration" + " - Total: " + this.getTotalTimeString() + ", Filtered: " + this.getFilteredTimeString() + this.warningsSuffixFromCount(this.treeStructure.getTreeStats().getVisibleWarnings());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String getTotalTimeString() {
        return BuildAttributionUIUtilKt.durationString(this.treeStructure.getTreeStats().getTotalTasksTimeMs());
    }

    private final String getFilteredTimeString() {
        return BuildAttributionUIUtilKt.durationString(this.treeStructure.getTreeStats().getFilteredTasksTimeMs());
    }

    private final String warningsSuffixFromCount(int warningCount) {
        String string;
        switch (warningCount) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = " - 1 Warning";
                break;
            }
            default: {
                string = " - " + warningCount + " Warnings";
            }
        }
        return string;
    }

    @Override
    @NotNull
    public DefaultMutableTreeNode getTreeRoot() {
        return this.treeStructure.getTreeRoot();
    }

    @Override
    @Nullable
    public TasksTreeNode getSelectedNode() {
        return this.treeStructure.getPageIdToNode().get(this.selectedPageId);
    }

    @Override
    @NotNull
    public TasksFilter getFilter() {
        return this.filter;
    }

    private void setFilter(TasksFilter value2) {
        this.filter = value2;
        this.treeStructure.updateStructure(this.getSelectedGrouping(), value2);
        this.treeStructureChanged = true;
        this.modelChanged = true;
    }

    @Override
    public boolean isEmpty() {
        return this.getReportData().getCriticalPathTasks().getSize() == 0;
    }

    private final void setSelectedPageId(TasksPageId value2) {
        TasksPageId newSelectedPageId;
        TasksDataPageModel.Grouping newSelectedGrouping = value2.getGrouping();
        if (newSelectedGrouping != this.selectedPageId.getGrouping()) {
            this.treeStructure.updateStructure(newSelectedGrouping, this.getFilter());
            this.treeStructureChanged = true;
            this.modelChanged = true;
        }
        TasksPageId tasksPageId = newSelectedPageId = this.treeStructure.getPageIdToNode().containsKey(value2) ? value2 : TasksPageId.Companion.emptySelection(newSelectedGrouping);
        if (Intrinsics.areEqual((Object)newSelectedPageId, (Object)this.selectedPageId) ^ true) {
            this.selectedPageId = newSelectedPageId;
            this.modelChanged = true;
        }
    }

    @Override
    public void selectGrouping(@NotNull TasksDataPageModel.Grouping newSelectedGrouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)newSelectedGrouping), (String)"newSelectedGrouping");
        TasksPageId currentPageId = this.selectedPageId;
        TasksPageId newSelectedPageId = currentPageId.getPageType() == TaskDetailsPageType.PLUGIN_DETAILS && newSelectedGrouping == TasksDataPageModel.Grouping.BY_PLUGIN ? TasksPageId.Companion.emptySelection(newSelectedGrouping) : TasksPageId.copy$default(currentPageId, newSelectedGrouping, null, null, 6, null);
        this.setSelectedPageId(newSelectedPageId);
        this.notifyModelChanges();
    }

    @Override
    public void selectNode(@Nullable TasksTreeNode tasksTreeNode) {
        TasksDataPageModel.Grouping currentGrouping = this.getSelectedGrouping();
        Object object = tasksTreeNode;
        if (object == null || (object = ((TasksTreeNode)object).getDescriptor()) == null || (object = ((TasksTreePresentableNodeDescriptor)object).getPageId()) == null) {
            object = TasksPageId.Companion.emptySelection(currentGrouping);
        }
        this.setSelectedPageId((TasksPageId)object);
        this.notifyModelChanges();
    }

    @Override
    public void selectPageById(@NotNull TasksPageId tasksPageId) {
        Intrinsics.checkNotNullParameter((Object)tasksPageId, (String)"tasksPageId");
        this.setSelectedPageId(tasksPageId);
        this.notifyModelChanges();
    }

    @Override
    public void applyFilter(@NotNull TasksFilter newFilter) {
        Intrinsics.checkNotNullParameter((Object)newFilter, (String)"newFilter");
        this.setFilter(newFilter);
        this.notifyModelChanges();
    }

    @Override
    public void setModelUpdatedListener(@NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.modelUpdatedListener = listener2;
    }

    @Override
    @Nullable
    public TasksTreePresentableNodeDescriptor getNodeDescriptorById(@NotNull TasksPageId pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        TasksTreeNode tasksTreeNode = this.treeStructure.getPageIdToNode().get(pageId);
        return tasksTreeNode != null ? tasksTreeNode.getDescriptor() : null;
    }

    private final void notifyModelChanges() {
        if (this.modelChanged) {
            Function1<? super Boolean, Unit> function1 = this.modelUpdatedListener;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.treeStructureChanged);
            }
            this.treeStructureChanged = false;
            this.modelChanged = false;
        }
    }

    @Override
    @NotNull
    public BuildAttributionReportUiData getReportData() {
        return this.reportData;
    }

    /*
     * WARNING - void declaration
     */
    public TasksDataPageModelImpl(@NotNull BuildAttributionReportUiData reportData) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        this.reportData = reportData;
        this.filter = TasksFilter.Companion.default();
        this.selectedPageId = TasksPageId.Companion.emptySelection(TasksDataPageModel.Grouping.UNGROUPED);
        TasksTreeStructure tasksTreeStructure = new TasksTreeStructure(this.getReportData());
        boolean bl = false;
        boolean bl2 = false;
        TasksTreeStructure tasksTreeStructure2 = tasksTreeStructure;
        TasksDataPageModelImpl tasksDataPageModelImpl = this;
        boolean bl3 = false;
        $this$apply.updateStructure(this.getSelectedGrouping(), this.getFilter());
        Unit unit = Unit.INSTANCE;
        tasksDataPageModelImpl.treeStructure = tasksTreeStructure;
    }
}

