/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.TaskDetailsNodeDescriptor$WhenMappings;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TimeDistributionBuilder;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.android.build.attribution.ui.view.BuildAnalyzerTreeNodePresentation;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0011\u001a\u00060\u0012R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/android/build/attribution/ui/model/TaskDetailsNodeDescriptor;", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "grouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "timeDistributionBuilder", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;", "(Lcom/android/build/attribution/ui/data/TaskUiData;Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;)V", "analyticsPageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getAnalyticsPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "chartItemColor", "Ljava/awt/Color;", "getChartItemColor", "()Ljava/awt/Color;", "filteredTaskTime", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder$TimeEntry;", "getFilteredTaskTime", "()Lcom/android/build/attribution/ui/model/TimeDistributionBuilder$TimeEntry;", "pageId", "Lcom/android/build/attribution/ui/model/TasksPageId;", "getPageId", "()Lcom/android/build/attribution/ui/model/TasksPageId;", "presentation", "Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getPresentation", "()Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "relativeWeight", "", "getRelativeWeight", "()D", "getTaskData", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "intellij.android.build-attribution"})
public final class TaskDetailsNodeDescriptor
extends TasksTreePresentableNodeDescriptor {
    @NotNull
    private final TasksPageId pageId;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType analyticsPageType;
    @NotNull
    private final TimeDistributionBuilder.TimeEntry filteredTaskTime;
    @NotNull
    private final TaskUiData taskData;

    @Override
    @NotNull
    public TasksPageId getPageId() {
        return this.pageId;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getAnalyticsPageType() {
        return this.analyticsPageType;
    }

    @NotNull
    public final TimeDistributionBuilder.TimeEntry getFilteredTaskTime() {
        return this.filteredTaskTime;
    }

    @Override
    @NotNull
    public BuildAnalyzerTreeNodePresentation getPresentation() {
        return new BuildAnalyzerTreeNodePresentation(this.taskData.getTaskPath(), null, this.filteredTaskTime.toRightAlignedNodeDurationText(), this.taskData.getHasWarning() ? BuildAnalyzerTreeNodePresentation.NodeIconState.WARNING_ICON : BuildAnalyzerTreeNodePresentation.NodeIconState.EMPTY_PLACEHOLDER, 2, null);
    }

    @Override
    public double getRelativeWeight() {
        return this.filteredTaskTime.toTimeWithPercentage().getPercentage();
    }

    @Override
    @NotNull
    public Color getChartItemColor() {
        Color color = CriticalPathChartLegend.resolveTaskColor((TaskUiData)this.taskData).baseColor;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"CriticalPathChartLegend.\u2026Color(taskData).baseColor");
        return color;
    }

    @NotNull
    public final TaskUiData getTaskData() {
        return this.taskData;
    }

    public TaskDetailsNodeDescriptor(@NotNull TaskUiData taskData, @NotNull TasksDataPageModel.Grouping grouping, @NotNull TimeDistributionBuilder timeDistributionBuilder) {
        BuildAttributionUiEvent.Page.PageType pageType;
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter((Object)((Object)grouping), (String)"grouping");
        Intrinsics.checkNotNullParameter((Object)timeDistributionBuilder, (String)"timeDistributionBuilder");
        super(null);
        this.taskData = taskData;
        this.pageId = TasksPageId.Companion.task(this.taskData, grouping);
        switch (TaskDetailsNodeDescriptor$WhenMappings.$EnumSwitchMapping$0[grouping.ordinal()]) {
            case 1: {
                pageType = BuildAttributionUiEvent.Page.PageType.CRITICAL_PATH_TASK_PAGE;
                break;
            }
            case 2: {
                pageType = BuildAttributionUiEvent.Page.PageType.PLUGIN_CRITICAL_PATH_TASK_PAGE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.analyticsPageType = pageType;
        this.filteredTaskTime = timeDistributionBuilder.registerTimeEntry(this.taskData.getExecutionTime().getTimeMs());
    }
}

