/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data.builder;

import com.android.build.attribution.analyzers.AnalyzersUtilKt;
import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.data.builder.TaskIssueUiDataContainer;
import com.android.build.attribution.ui.data.builder.TaskUiDataContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskUiDataContainer;", "", "buildAnalysisResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "issuesContainer", "Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "criticalPathDuration", "", "(Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;J)V", "getIssuesContainer", "()Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "tasksCache", "", "Lcom/android/build/attribution/data/TaskData;", "Lcom/android/build/attribution/ui/data/TaskUiData;", "tasksDeterminingBuildDuration", "", "totalBuildTimeMs", "getByTaskData", "task", "intellij.android.build-attribution"})
public final class TaskUiDataContainer {
    private final Map<TaskData, TaskUiData> tasksCache;
    private final Set<TaskData> tasksDeterminingBuildDuration;
    private final long totalBuildTimeMs;
    @NotNull
    private final TaskIssueUiDataContainer issuesContainer;
    private final long criticalPathDuration;

    @NotNull
    public final TaskUiData getByTaskData(@NotNull TaskData task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        TaskUiData taskUiData = this.tasksCache.computeIfAbsent(task2, new Function(this, task2){
            final /* synthetic */ TaskUiDataContainer this$0;
            final /* synthetic */ TaskData $task;

            @NotNull
            public final TaskUiData apply(@NotNull TaskData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new TaskUiData(this){
                    @NotNull
                    private final String pluginName;
                    @NotNull
                    private final PluginSourceType sourceType;
                    @NotNull
                    private final String module;
                    @NotNull
                    private final String name;
                    @NotNull
                    private final String taskPath;
                    @NotNull
                    private final String taskType;
                    @NotNull
                    private final TimeWithPercentage executionTime;
                    private final boolean executedIncrementally;
                    @NotNull
                    private final String executionMode;
                    private final boolean onLogicalCriticalPath;
                    private final boolean onExtendedCriticalPath;
                    @NotNull
                    private final List<String> reasonsToRun;
                    final /* synthetic */ getByTaskData.1 this$0;

                    @NotNull
                    public String getPluginName() {
                        return this.pluginName;
                    }

                    @NotNull
                    public PluginSourceType getSourceType() {
                        return this.sourceType;
                    }

                    @NotNull
                    public String getModule() {
                        return this.module;
                    }

                    @NotNull
                    public String getName() {
                        return this.name;
                    }

                    @NotNull
                    public String getTaskPath() {
                        return this.taskPath;
                    }

                    @NotNull
                    public String getTaskType() {
                        return this.taskType;
                    }

                    @NotNull
                    public TimeWithPercentage getExecutionTime() {
                        return this.executionTime;
                    }

                    public boolean getExecutedIncrementally() {
                        return this.executedIncrementally;
                    }

                    @NotNull
                    public String getExecutionMode() {
                        return this.executionMode;
                    }

                    public boolean getOnLogicalCriticalPath() {
                        return this.onLogicalCriticalPath;
                    }

                    public boolean getOnExtendedCriticalPath() {
                        return this.onExtendedCriticalPath;
                    }

                    @NotNull
                    public List<String> getReasonsToRun() {
                        return this.reasonsToRun;
                    }

                    @NotNull
                    public List<TaskIssueUiData> getIssues() {
                        return this.this$0.this$0.getIssuesContainer().issuesForTask(this.this$0.$task);
                    }
                    {
                        this.this$0 = this$0;
                        this.pluginName = this.this$0.$task.getOriginPlugin().getDisplayName();
                        this.sourceType = AnalyzersUtilKt.isAndroidPlugin(this.this$0.$task.getOriginPlugin()) ? PluginSourceType.ANDROID_PLUGIN : (AnalyzersUtilKt.isKotlinPlugin(this.this$0.$task.getOriginPlugin()) ? PluginSourceType.ANDROID_PLUGIN : (AnalyzersUtilKt.isGradlePlugin(this.this$0.$task.getOriginPlugin()) ? PluginSourceType.ANDROID_PLUGIN : (AnalyzersUtilKt.isJavaPlugin(this.this$0.$task.getOriginPlugin()) ? PluginSourceType.ANDROID_PLUGIN : (this.this$0.$task.getOriginPlugin().getPluginType() == PluginData.PluginType.BUILDSRC_PLUGIN || this.this$0.$task.getOriginPlugin().getPluginType() == PluginData.PluginType.SCRIPT ? PluginSourceType.BUILD_SRC : PluginSourceType.THIRD_PARTY))));
                        this.module = this.this$0.$task.getProjectPath();
                        this.name = this.this$0.$task.getTaskName();
                        this.taskPath = this.this$0.$task.getTaskPath();
                        this.taskType = this.this$0.$task.getTaskType();
                        this.executionTime = new TimeWithPercentage(this.this$0.$task.getExecutionTime(), TaskUiDataContainer.access$getCriticalPathDuration$p(this$0.this$0));
                        this.executedIncrementally = this.this$0.$task.getExecutionMode() == TaskData.TaskExecutionMode.INCREMENTAL;
                        this.executionMode = this.this$0.$task.getExecutionMode().name();
                        this.onLogicalCriticalPath = this.this$0.$task.isOnTheCriticalPath();
                        this.onExtendedCriticalPath = TaskUiDataContainer.access$getTasksDeterminingBuildDuration$p(this$0.this$0).contains(this.this$0.$task);
                        this.reasonsToRun = this.this$0.$task.getExecutionReasons();
                    }

                    public boolean getHasWarning() {
                        return TaskUiData.DefaultImpls.getHasWarning(this);
                    }

                    public boolean getHasInfo() {
                        return TaskUiData.DefaultImpls.getHasInfo(this);
                    }
                };
            }
            {
                this.this$0 = taskUiDataContainer;
                this.$task = taskData;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskUiData, (String)"tasksCache.computeIfAbse\u2026esForTask(task)\n    }\n  }");
        return taskUiData;
    }

    @NotNull
    public final TaskIssueUiDataContainer getIssuesContainer() {
        return this.issuesContainer;
    }

    public TaskUiDataContainer(@NotNull BuildEventsAnalysisResult buildAnalysisResult, @NotNull TaskIssueUiDataContainer issuesContainer, long criticalPathDuration) {
        Intrinsics.checkNotNullParameter((Object)buildAnalysisResult, (String)"buildAnalysisResult");
        Intrinsics.checkNotNullParameter((Object)issuesContainer, (String)"issuesContainer");
        this.issuesContainer = issuesContainer;
        this.criticalPathDuration = criticalPathDuration;
        this.tasksCache = new HashMap();
        this.tasksDeterminingBuildDuration = CollectionsKt.toHashSet((Iterable)buildAnalysisResult.getTasksDeterminingBuildDuration());
        this.totalBuildTimeMs = buildAnalysisResult.getTotalBuildTimeMs();
    }

    public static final /* synthetic */ long access$getCriticalPathDuration$p(TaskUiDataContainer $this) {
        return $this.criticalPathDuration;
    }

    public static final /* synthetic */ Set access$getTasksDeterminingBuildDuration$p(TaskUiDataContainer $this) {
        return $this.tasksDeterminingBuildDuration;
    }
}

