/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data.builder;

import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.data.AlwaysRunTaskData;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.data.TasksSharingOutputData;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.InterTaskIssueUiData;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.data.builder.TaskIssueUiDataContainer;
import com.android.build.attribution.ui.data.builder.TaskUiDataContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0010\u001a\u00020\u000bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "", "buildAnalysisResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "(Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;)V", "issuesByPlugin", "", "Lcom/android/build/attribution/data/PluginData;", "", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "issuesByTask", "Lcom/android/build/attribution/data/TaskData;", "issuesByType", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "addNewIssue", "", "taskData", "issueUiData", "allIssueGroups", "", "Lcom/android/build/attribution/ui/data/TaskIssuesGroup;", "issuesForTask", "pluginIssueGroups", "pluginData", "populate", "tasksUiDataContainer", "Lcom/android/build/attribution/ui/data/builder/TaskUiDataContainer;", "toTaskIssueGroup", "issueType", "issuesList", "AlwaysRunNoOutputIssue", "AlwaysRunUpToDateOverride", "TaskSetupIssue", "intellij.android.build-attribution"})
public final class TaskIssueUiDataContainer {
    private final Map<TaskData, List<TaskIssueUiData>> issuesByTask;
    private final Map<TaskIssueType, List<TaskIssueUiData>> issuesByType;
    private final Map<PluginData, List<TaskIssueUiData>> issuesByPlugin;
    private final BuildEventsAnalysisResult buildAnalysisResult;

    /*
     * WARNING - void declaration
     */
    public final void populate(@NotNull TaskUiDataContainer tasksUiDataContainer) {
        Intrinsics.checkNotNullParameter((Object)tasksUiDataContainer, (String)"tasksUiDataContainer");
        Iterable $this$forEach$iv = this.buildAnalysisResult.getAlwaysRunTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AlwaysRunTaskData it = (AlwaysRunTaskData)element$iv;
            boolean bl = false;
            this.addNewIssue(it.getTaskData(), it.getRerunReason() == AlwaysRunTaskData.Reason.UP_TO_DATE_WHEN_FALSE ? (TaskIssueUiData)new AlwaysRunUpToDateOverride(tasksUiDataContainer.getByTaskData(it.getTaskData())) : (TaskIssueUiData)new AlwaysRunNoOutputIssue(tasksUiDataContainer.getByTaskData(it.getTaskData())));
        }
        $this$forEach$iv = this.buildAnalysisResult.getTasksSharingOutput();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TasksSharingOutputData taskSharingIssue = (TasksSharingOutputData)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = taskSharingIssue.getTaskList();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object element$iv32;
                TaskIssueUiDataContainer taskIssueUiDataContainer;
                TaskData taskData;
                TaskUiData taskUiData;
                TaskUiDataContainer taskUiDataContainer;
                block4: {
                    void $this$first$iv;
                    TaskData task2 = (TaskData)element$iv2;
                    boolean bl2 = false;
                    Iterable iterable = taskSharingIssue.getTaskList();
                    taskUiDataContainer = tasksUiDataContainer;
                    taskUiData = tasksUiDataContainer.getByTaskData(task2);
                    taskData = task2;
                    taskIssueUiDataContainer = this;
                    boolean $i$f$first = false;
                    for (Object element$iv32 : $this$first$iv) {
                        TaskData it = (TaskData)element$iv32;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it, (Object)task2) ^ true)) continue;
                        break block4;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv32;
                String string = taskSharingIssue.getOutputFilePath();
                TaskUiData taskUiData2 = taskUiDataContainer.getByTaskData((TaskData)t);
                TaskUiData taskUiData3 = taskUiData;
                taskIssueUiDataContainer.addNewIssue(taskData, new TaskSetupIssue(taskUiData3, taskUiData2, string));
            }
        }
    }

    private final void addNewIssue(TaskData taskData, TaskIssueUiData issueUiData) {
        this.issuesByTask.computeIfAbsent(taskData, addNewIssue.1.INSTANCE).add(issueUiData);
        this.issuesByPlugin.computeIfAbsent(taskData.getOriginPlugin(), addNewIssue.2.INSTANCE).add(issueUiData);
        this.issuesByType.computeIfAbsent(issueUiData.getType(), addNewIssue.3.INSTANCE).add(issueUiData);
    }

    @NotNull
    public final List<TaskIssueUiData> issuesForTask(@NotNull TaskData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        List list = this.issuesByTask.get(taskData);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TaskIssuesGroup> allIssueGroups() {
        void $this$mapTo$iv$iv;
        Map<TaskIssueType, List<TaskIssueUiData>> $this$map$iv = this.issuesByType;
        boolean $i$f$map = false;
        Map<TaskIssueType, List<TaskIssueUiData>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void issueType;
            void $dstr$issueType$issuesList;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            void var12_13 = $dstr$issueType$issuesList;
            boolean bl3 = false;
            TaskIssueType taskIssueType = (TaskIssueType)((Object)var12_13.getKey());
            var12_13 = $dstr$issueType$issuesList;
            bl3 = false;
            List issuesList = (List)var12_13.getValue();
            TaskIssuesGroup taskIssuesGroup = this.toTaskIssueGroup((TaskIssueType)issueType, issuesList);
            collection2.add(taskIssuesGroup);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl4 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskIssuesGroup it = (TaskIssuesGroup)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getType().ordinal());
                it = (TaskIssuesGroup)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getType().ordinal();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    private final TaskIssuesGroup toTaskIssueGroup(TaskIssueType issueType, List<? extends TaskIssueUiData> issuesList) {
        return new TaskIssuesGroup(this, issueType, issuesList){
            @NotNull
            private final TaskIssueType type;
            @NotNull
            private final List<TaskIssueUiData> issues;
            @NotNull
            private final TimeWithPercentage timeContribution;
            final /* synthetic */ TaskIssueUiDataContainer this$0;
            final /* synthetic */ TaskIssueType $issueType;
            final /* synthetic */ List $issuesList;

            @NotNull
            public TaskIssueType getType() {
                return this.type;
            }

            @NotNull
            public List<TaskIssueUiData> getIssues() {
                return this.issues;
            }

            @NotNull
            public TimeWithPercentage getTimeContribution() {
                return this.timeContribution;
            }
            {
                Collection<Long> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this.this$0 = this$0;
                this.$issueType = $captured_local_variable$1;
                this.$issuesList = $captured_local_variable$2;
                this.type = $captured_local_variable$1;
                Iterable $this$sortedByDescending$iv = $captured_local_variable$2;
                boolean $i$f$sortedByDescending = false;
                boolean bl = false;
                this.issues = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        TaskIssueUiData it = (TaskIssueUiData)b;
                        boolean bl2 = false;
                        Comparable comparable = it.getTask().getExecutionTime();
                        it = (TaskIssueUiData)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        TimeWithPercentage timeWithPercentage = it.getTask().getExecutionTime();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)timeWithPercentage);
                    }
                });
                $this$sortedByDescending$iv = this.getIssues();
                toTaskIssueGroup.1 var13_8 = this;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TaskIssueUiData taskIssueUiData = (TaskIssueUiData)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    Long l = it.getTask().getExecutionTime().getTimeMs();
                    collection2.add(l);
                }
                collection2 = (List)destination$iv$iv;
                long l = TaskIssueUiDataContainer.access$getBuildAnalysisResult$p(this$0).getTotalBuildTimeMs();
                long l2 = CollectionsKt.sumOfLong((Iterable)collection2);
                var13_8.timeContribution = new TimeWithPercentage(l2, l);
            }

            public int getSize() {
                return TaskIssuesGroup.DefaultImpls.getSize(this);
            }

            public int getWarningCount() {
                return TaskIssuesGroup.DefaultImpls.getWarningCount(this);
            }

            public int getInfoCount() {
                return TaskIssuesGroup.DefaultImpls.getInfoCount(this);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TaskIssuesGroup> pluginIssueGroups(@NotNull PluginData pluginData) {
        void $this$mapTo$iv$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pluginData, (String)"pluginData");
        Map<PluginData, List<TaskIssueUiData>> map2 = this.issuesByPlugin;
        List list = CollectionsKt.emptyList();
        boolean bl = false;
        Map<PluginData, List<TaskIssueUiData>> map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        Iterable $this$groupBy$iv = map3.getOrDefault(pluginData, list);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            TaskIssueUiData it = (TaskIssueUiData)element$iv$iv;
            boolean bl2 = false;
            key$iv$iv = it.getType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        boolean bl4 = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            void issueType;
            void $dstr$issueType$issuesList;
            key$iv$iv = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl5 = false;
            void var13_20 = $dstr$issueType$issuesList;
            boolean bl6 = false;
            answer$iv$iv$iv = (TaskIssueType)((Object)var13_20.getKey());
            var13_20 = $dstr$issueType$issuesList;
            bl6 = false;
            List issuesList = (List)var13_20.getValue();
            TaskIssuesGroup taskIssuesGroup = this.toTaskIssueGroup((TaskIssueType)issueType, issuesList);
            object.add(taskIssuesGroup);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl7 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskIssuesGroup it = (TaskIssuesGroup)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getType().ordinal());
                it = (TaskIssuesGroup)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getType().ordinal();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    public TaskIssueUiDataContainer(@NotNull BuildEventsAnalysisResult buildAnalysisResult) {
        Intrinsics.checkNotNullParameter((Object)buildAnalysisResult, (String)"buildAnalysisResult");
        this.buildAnalysisResult = buildAnalysisResult;
        this.issuesByTask = new HashMap();
        this.issuesByType = new EnumMap(TaskIssueType.class);
        this.issuesByPlugin = new HashMap();
    }

    public static final /* synthetic */ BuildEventsAnalysisResult access$getBuildAnalysisResult$p(TaskIssueUiDataContainer $this) {
        return $this.buildAnalysisResult;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer$TaskSetupIssue;", "Lcom/android/build/attribution/ui/data/InterTaskIssueUiData;", "task", "Lcom/android/build/attribution/ui/data/TaskUiData;", "connectedTask", "outputFolder", "", "(Lcom/android/build/attribution/ui/data/TaskUiData;Lcom/android/build/attribution/ui/data/TaskUiData;Ljava/lang/String;)V", "bugReportBriefDescription", "getBugReportBriefDescription", "()Ljava/lang/String;", "bugReportTitle", "getBugReportTitle", "buildSrcRecommendation", "getBuildSrcRecommendation", "getConnectedTask", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "explanation", "getExplanation", "helpLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getHelpLink", "()Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getOutputFolder", "getTask", "type", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "getType", "()Lcom/android/build/attribution/ui/data/TaskIssueType;", "intellij.android.build-attribution"})
    public static final class TaskSetupIssue
    implements InterTaskIssueUiData {
        @NotNull
        private final TaskIssueType type;
        @NotNull
        private final String bugReportTitle;
        @NotNull
        private final String bugReportBriefDescription;
        @NotNull
        private final String explanation;
        @NotNull
        private final BuildAnalyzerBrowserLinks helpLink;
        @NotNull
        private final String buildSrcRecommendation;
        @NotNull
        private final TaskUiData task;
        @NotNull
        private final TaskUiData connectedTask;
        @NotNull
        private final String outputFolder;

        @Override
        @NotNull
        public TaskIssueType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getBugReportTitle() {
            return this.bugReportTitle;
        }

        @Override
        @NotNull
        public String getBugReportBriefDescription() {
            return this.bugReportBriefDescription;
        }

        @Override
        @NotNull
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        @NotNull
        public BuildAnalyzerBrowserLinks getHelpLink() {
            return this.helpLink;
        }

        @Override
        @NotNull
        public String getBuildSrcRecommendation() {
            return this.buildSrcRecommendation;
        }

        @Override
        @NotNull
        public TaskUiData getTask() {
            return this.task;
        }

        @Override
        @NotNull
        public TaskUiData getConnectedTask() {
            return this.connectedTask;
        }

        @NotNull
        public final String getOutputFolder() {
            return this.outputFolder;
        }

        public TaskSetupIssue(@NotNull TaskUiData task2, @NotNull TaskUiData connectedTask, @NotNull String outputFolder) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            Intrinsics.checkNotNullParameter((Object)connectedTask, (String)"connectedTask");
            Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
            this.task = task2;
            this.connectedTask = connectedTask;
            this.outputFolder = outputFolder;
            this.type = TaskIssueType.TASK_SETUP_ISSUE;
            this.bugReportTitle = this.getType().getUiName();
            this.bugReportBriefDescription = "Task declares the same output directory as task " + this.getConnectedTask().getName() + " from " + (this.getConnectedTask().getSourceType() == PluginSourceType.BUILD_SRC ? "build script" : this.getConnectedTask().getPluginName()) + ": '" + this.outputFolder + "'.";
            this.explanation = "\nThis task declares the same output directory as task '" + this.getConnectedTask().getTaskPath() + "': " + BuildAttributionUIUtilKt.wrapPathToSpans(this.outputFolder) + "\nAs a result, these tasks are not able to take advantage of incremental build optimizations,\nand might need to run with each subsequent build.\n";
            this.helpLink = BuildAnalyzerBrowserLinks.DUPLICATE_OUTPUT_FOLDER_ISSUE;
            this.buildSrcRecommendation = "Edit the plugin(s) to ensure each task specifies a unique output directory.";
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer$AlwaysRunNoOutputIssue;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "task", "Lcom/android/build/attribution/ui/data/TaskUiData;", "(Lcom/android/build/attribution/ui/data/TaskUiData;)V", "bugReportBriefDescription", "", "getBugReportBriefDescription", "()Ljava/lang/String;", "bugReportTitle", "getBugReportTitle", "buildSrcRecommendation", "getBuildSrcRecommendation", "explanation", "getExplanation", "helpLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getHelpLink", "()Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getTask", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "type", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "getType", "()Lcom/android/build/attribution/ui/data/TaskIssueType;", "intellij.android.build-attribution"})
    public static final class AlwaysRunNoOutputIssue
    implements TaskIssueUiData {
        @NotNull
        private final TaskIssueType type;
        @NotNull
        private final String bugReportTitle;
        @NotNull
        private final String bugReportBriefDescription;
        @NotNull
        private final String explanation;
        @NotNull
        private final BuildAnalyzerBrowserLinks helpLink;
        @NotNull
        private final String buildSrcRecommendation;
        @NotNull
        private final TaskUiData task;

        @Override
        @NotNull
        public TaskIssueType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getBugReportTitle() {
            return this.bugReportTitle;
        }

        @Override
        @NotNull
        public String getBugReportBriefDescription() {
            return this.bugReportBriefDescription;
        }

        @Override
        @NotNull
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        @NotNull
        public BuildAnalyzerBrowserLinks getHelpLink() {
            return this.helpLink;
        }

        @Override
        @NotNull
        public String getBuildSrcRecommendation() {
            return this.buildSrcRecommendation;
        }

        @Override
        @NotNull
        public TaskUiData getTask() {
            return this.task;
        }

        public AlwaysRunNoOutputIssue(@NotNull TaskUiData task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            this.task = task2;
            this.type = TaskIssueType.ALWAYS_RUN_TASKS;
            this.bugReportTitle = this.getType().getUiName() + " No Output Declared";
            this.bugReportBriefDescription = "Task runs on every build because it declares no outputs.";
            this.explanation = "This task runs on every build because it declares no outputs, which it must do in order to support incremental builds.";
            this.helpLink = BuildAnalyzerBrowserLinks.NO_OUTPUTS_DECLARED_ISSUE;
            this.buildSrcRecommendation = "Annotate the task output fields with one of: OutputDirectory, OutputDirectories, OutputFile, OutputFiles";
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer$AlwaysRunUpToDateOverride;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "task", "Lcom/android/build/attribution/ui/data/TaskUiData;", "(Lcom/android/build/attribution/ui/data/TaskUiData;)V", "bugReportBriefDescription", "", "getBugReportBriefDescription", "()Ljava/lang/String;", "bugReportTitle", "getBugReportTitle", "buildSrcRecommendation", "getBuildSrcRecommendation", "explanation", "getExplanation", "helpLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getHelpLink", "()Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getTask", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "type", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "getType", "()Lcom/android/build/attribution/ui/data/TaskIssueType;", "intellij.android.build-attribution"})
    public static final class AlwaysRunUpToDateOverride
    implements TaskIssueUiData {
        @NotNull
        private final TaskIssueType type;
        @NotNull
        private final String bugReportTitle;
        @NotNull
        private final String bugReportBriefDescription;
        @NotNull
        private final String explanation;
        @NotNull
        private final BuildAnalyzerBrowserLinks helpLink;
        @NotNull
        private final String buildSrcRecommendation;
        @NotNull
        private final TaskUiData task;

        @Override
        @NotNull
        public TaskIssueType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getBugReportTitle() {
            return this.bugReportTitle;
        }

        @Override
        @NotNull
        public String getBugReportBriefDescription() {
            return this.bugReportBriefDescription;
        }

        @Override
        @NotNull
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        @NotNull
        public BuildAnalyzerBrowserLinks getHelpLink() {
            return this.helpLink;
        }

        @Override
        @NotNull
        public String getBuildSrcRecommendation() {
            return this.buildSrcRecommendation;
        }

        @Override
        @NotNull
        public TaskUiData getTask() {
            return this.task;
        }

        public AlwaysRunUpToDateOverride(@NotNull TaskUiData task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            this.task = task2;
            this.type = TaskIssueType.ALWAYS_RUN_TASKS;
            this.bugReportTitle = this.getType().getUiName() + " Up-To-Date Override";
            this.bugReportBriefDescription = "This task might be setting its up-to-date check to always return false.";
            this.explanation = "\nThis task might be setting its up-to-date check to always return <code>false</code>,\nwhich means that it must regenerate its output during every build.\nFor example, the task might set the following: <code>outputs.upToDateWhen { false }</code>.\nTo optimize task execution with up-to-date checks, remove the <code>upToDateWhen</code> enclosure.\n";
            this.helpLink = BuildAnalyzerBrowserLinks.UP_TO_DATE_EQUALS_FALSE_ISSUE;
            this.buildSrcRecommendation = "Ensure that you don't automatically override up-to-date checks.";
        }
    }
}

