/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.TaskIssueReportGenerator;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.ide.common.repository.GradleVersion;
import com.intellij.util.text.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002J\f\u0010\u0016\u001a\u00020\u0006*\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/attribution/ui/data/TaskIssueReportGenerator;", "", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "platformInformationProvider", "Lkotlin/Function0;", "", "agpVersionsProvider", "", "Lcom/android/ide/common/repository/GradleVersion;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "findOtherTaskOccurrencesWithIssues", "Lcom/android/build/attribution/ui/data/TaskUiData;", "taskData", "generateAgpVersionsString", "generateBuildInformationText", "generateFoundIssuesText", "generateHeaderText", "pluginName", "generatePlatformInformationText", "generateReportText", "generateTaskExecutionText", "commonString", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "isSameTask", "", "other", "intellij.android.build-attribution"})
public final class TaskIssueReportGenerator {
    private final BuildAttributionReportUiData reportData;
    private final Function0<String> platformInformationProvider;
    private final Function0<List<GradleVersion>> agpVersionsProvider;

    @NotNull
    public final String generateReportText(@NotNull TaskUiData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        String string = '\n' + this.generateHeaderText(taskData.getPluginName()) + "\n\n" + this.generateFoundIssuesText(taskData) + "\n\nPlugin: " + taskData.getPluginName() + "\nTask: " + taskData.getName() + "\nTask type: " + taskData.getTaskType() + '\n' + this.generateTaskExecutionText(taskData) + "\n====Build information:====\n" + this.generateBuildInformationText() + "\n====Platform information:====\n" + this.generatePlatformInformationText() + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String generateHeaderText(String pluginName) {
        String date = new SimpleDateFormat("HH:mm, MMM dd, yyyy", Locale.US).format(new Date(this.reportData.getBuildSummary().getBuildFinishedTimestamp()));
        return "At " + date + ", Android Studio detected the following issue(s) with Gradle plugin " + pluginName;
    }

    private final String generateFoundIssuesText(TaskUiData taskData) {
        return CollectionsKt.joinToString$default((Iterable)taskData.getIssues(), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)generateFoundIssuesText.1.INSTANCE, (int)30, null);
    }

    private final String generateBuildInformationText() {
        String string = "\nExecution date: " + DateFormatUtil.formatDateTime((long)this.reportData.getBuildSummary().getBuildFinishedTimestamp()) + "\nTotal build duration: " + BuildAttributionUIUtilKt.durationString(this.reportData.getBuildSummary().getTotalBuildDuration()) + "\nConfiguration time: " + this.commonString(this.reportData.getBuildSummary().getConfigurationDuration()) + "\nCritical path tasks time: " + this.commonString(this.reportData.getBuildSummary().getCriticalPathDuration()) + "\nCritical path tasks size: " + this.reportData.getCriticalPathTasks().getSize() + "\nAGP versions: " + this.generateAgpVersionsString() + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String generatePlatformInformationText() {
        String string = (String)this.platformInformationProvider.invoke();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String generateTaskExecutionText(TaskUiData taskData) {
        long l;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        List<TaskUiData> occurrences = this.findOtherTaskOccurrencesWithIssues(taskData);
        Object $this$sumByLong$iv = occurrences;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        Object object = $this$sumByLong$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object element$iv = object.next();
            TaskUiData taskUiData = (TaskUiData)element$iv;
            l = sum$iv;
            boolean bl6 = false;
            long l2 = it.getExecutionTime().getTimeMs();
            sum$iv = l + l2;
        }
        l = sum$iv;
        long l3 = this.reportData.getBuildSummary().getCriticalPathDuration().getTimeMs();
        long l4 = l;
        TimeWithPercentage timeSum = new TimeWithPercentage(l4, l3);
        $this$sumByLong$iv = $this$buildString;
        String string = "Issues for the same task were detected in " + occurrences.size() + " module(s), total execution time was " + this.commonString(timeSum) + ", by module:";
        boolean bl7 = false;
        StringBuilder stringBuilder2 = ((StringBuilder)$this$sumByLong$iv).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        for (TaskUiData task2 : occurrences) {
            String line2 = "Execution mode: " + task2.getExecutionMode() + ", " + "time: " + this.commonString(task2.getExecutionTime()) + ", " + "determines build duration: " + task2.getOnExtendedCriticalPath() + ", " + "on critical path: " + task2.getOnLogicalCriticalPath() + ", " + CollectionsKt.joinToString$default((Iterable)task2.getIssues(), null, (CharSequence)"issues: ", null, (int)0, null, (Function1)generateTaskExecutionText.1.line.1.INSTANCE, (int)29, null);
            StringBuilder stringBuilder3 = $this$buildString;
            object = "  " + line2;
            boolean bl8 = false;
            StringBuilder stringBuilder4 = stringBuilder3.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final String generateAgpVersionsString() {
        Iterable iterable = (Iterable)this.agpVersionsProvider.invoke();
        Comparator comparator2 = Comparator.reverseOrder();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Comparator.reverseOrder()");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)iterable, comparator2), null, null, null, (int)5, null, (Function1)generateAgpVersionsString.1.INSTANCE, (int)23, null);
    }

    private final List<TaskUiData> findOtherTaskOccurrencesWithIssues(TaskUiData taskData) {
        Sequence $this$sortedByDescending$iv = SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.reportData.getIssues()), (Function1)findOtherTaskOccurrencesWithIssues.1.INSTANCE), (Function1)findOtherTaskOccurrencesWithIssues.2.INSTANCE), (Function1)((Function1)new Function1<TaskUiData, Boolean>(this, taskData){
            final /* synthetic */ TaskIssueReportGenerator this$0;
            final /* synthetic */ TaskUiData $taskData;

            public final boolean invoke(@NotNull TaskUiData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TaskIssueReportGenerator.access$isSameTask(this.this$0, it, this.$taskData);
            }
            {
                this.this$0 = taskIssueReportGenerator;
                this.$taskData = taskUiData;
                super(1);
            }
        })));
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskUiData it = (TaskUiData)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getExecutionTime().getTimeMs());
                it = (TaskUiData)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getExecutionTime().getTimeMs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        }));
    }

    private final String commonString(TimeWithPercentage $this$commonString) {
        return BuildAttributionUIUtilKt.durationString($this$commonString) + " (" + BuildAttributionUIUtilKt.percentageString($this$commonString) + ')';
    }

    private final boolean isSameTask(TaskUiData $this$isSameTask, TaskUiData other) {
        return Intrinsics.areEqual((Object)$this$isSameTask.getName(), (Object)other.getName()) && Intrinsics.areEqual((Object)$this$isSameTask.getPluginName(), (Object)other.getPluginName());
    }

    public TaskIssueReportGenerator(@NotNull BuildAttributionReportUiData reportData, @NotNull Function0<String> platformInformationProvider, @NotNull Function0<? extends List<? extends GradleVersion>> agpVersionsProvider) {
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter(platformInformationProvider, (String)"platformInformationProvider");
        Intrinsics.checkNotNullParameter(agpVersionsProvider, (String)"agpVersionsProvider");
        this.reportData = reportData;
        this.platformInformationProvider = platformInformationProvider;
        this.agpVersionsProvider = agpVersionsProvider;
    }

    public static final /* synthetic */ boolean access$isSameTask(TaskIssueReportGenerator $this, TaskUiData $this$access_u24isSameTask, TaskUiData other) {
        return $this.isSameTask($this$access_u24isSameTask, other);
    }
}

