/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.BuildAttributionStateReporter;
import com.android.build.attribution.BuildAttributionStateReporterImpl;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.BuildAttributionUiManagerImpl;
import com.android.build.attribution.ui.BuildFailureViewComponentContainer;
import com.android.build.attribution.ui.NewViewComponentContainer;
import com.android.build.attribution.ui.OpenRequest;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.TaskIssueReporterImpl;
import com.android.build.attribution.ui.data.AnnotationProcessorsReport;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.BuildSummary;
import com.android.build.attribution.ui.data.ConfigurationUiData;
import com.android.build.attribution.ui.data.CriticalPathPluginsUiData;
import com.android.build.attribution.ui.data.CriticalPathTasksUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.BuildContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020\u001cH\u0002J\b\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020&2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020&0/H\u0002J\u0010\u00100\u001a\u00020&2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020&H\u0002J\u0010\u00104\u001a\u00020&2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020&2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00108\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u000202H\u0016J\b\u00109\u001a\u00020&H\u0003J\f\u0010:\u001a\u00020&*\u00020\u000eH\u0002R&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/build/attribution/ui/BuildAttributionUiManagerImpl;", "Lcom/android/build/attribution/ui/BuildAttributionUiManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildAttributionView", "Lcom/intellij/openapi/ui/ComponentContainer;", "getBuildAttributionView$annotations", "()V", "getBuildAttributionView", "()Lcom/intellij/openapi/ui/ComponentContainer;", "setBuildAttributionView", "(Lcom/intellij/openapi/ui/ComponentContainer;)V", "buildContent", "Lcom/intellij/ui/content/Content;", "getBuildContent$annotations", "getBuildContent", "()Lcom/intellij/ui/content/Content;", "setBuildContent", "(Lcom/intellij/ui/content/Content;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "contentManagerListener", "com/android/build/attribution/ui/BuildAttributionUiManagerImpl$contentManagerListener$1", "Lcom/android/build/attribution/ui/BuildAttributionUiManagerImpl$contentManagerListener$1;", "openRequest", "Lcom/android/build/attribution/ui/OpenRequest;", "reportUiData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "stateReporter", "Lcom/android/build/attribution/BuildAttributionStateReporterImpl;", "getStateReporter", "()Lcom/android/build/attribution/BuildAttributionStateReporterImpl;", "stateReporter$delegate", "Lkotlin/Lazy;", "uiAnalytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "cleanUp", "", "createNewTab", "createNewView", "dispose", "failedBuildReportData", "hasDataToShow", "", "invokeLaterIfNotDisposed", "runnable", "Lkotlin/Function0;", "onBuildFailure", "buildSessionId", "", "onContentClosed", "openTab", "eventSource", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$TabOpenEventSource;", "requestOpenTabWhenDataReady", "showNewReport", "updateReportUI", "replaceContentView", "intellij.android.build-attribution"})
public final class BuildAttributionUiManagerImpl
implements BuildAttributionUiManager {
    @Nullable
    private ComponentContainer buildAttributionView;
    @Nullable
    private Content buildContent;
    @NotNull
    private final Lazy stateReporter$delegate;
    private ContentManager contentManager;
    private OpenRequest openRequest;
    private final contentManagerListener.1 contentManagerListener;
    private final BuildAttributionUiAnalytics uiAnalytics;
    private BuildAttributionReportUiData reportUiData;
    private final Project project;

    @VisibleForTesting
    public static /* synthetic */ void getBuildAttributionView$annotations() {
    }

    @Nullable
    public final ComponentContainer getBuildAttributionView() {
        return this.buildAttributionView;
    }

    public final void setBuildAttributionView(@Nullable ComponentContainer componentContainer) {
        this.buildAttributionView = componentContainer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBuildContent$annotations() {
    }

    @Nullable
    public final Content getBuildContent() {
        return this.buildContent;
    }

    public final void setBuildContent(@Nullable Content content2) {
        this.buildContent = content2;
    }

    @Override
    @NotNull
    public BuildAttributionStateReporterImpl getStateReporter() {
        Lazy lazy = this.stateReporter$delegate;
        BuildAttributionUiManagerImpl buildAttributionUiManagerImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BuildAttributionStateReporterImpl)lazy.getValue();
    }

    @Override
    public void showNewReport(@NotNull BuildAttributionReportUiData reportUiData, @NotNull String buildSessionId) {
        Intrinsics.checkNotNullParameter((Object)reportUiData, (String)"reportUiData");
        Intrinsics.checkNotNullParameter((Object)buildSessionId, (String)"buildSessionId");
        this.reportUiData = reportUiData;
        this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this, buildSessionId){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            final /* synthetic */ String $buildSessionId;

            public final void invoke() {
                BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).newReportSessionId(this.$buildSessionId);
                BuildAttributionUiManagerImpl.access$updateReportUI(this.this$0);
                this.this$0.getStateReporter().setStateDataExist();
            }
            {
                this.this$0 = buildAttributionUiManagerImpl;
                this.$buildSessionId = string;
                super(0);
            }
        }));
    }

    @Override
    public void onBuildFailure(@NotNull String buildSessionId) {
        Intrinsics.checkNotNullParameter((Object)buildSessionId, (String)"buildSessionId");
        this.reportUiData = this.failedBuildReportData();
        this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this, buildSessionId){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            final /* synthetic */ String $buildSessionId;

            public final void invoke() {
                BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).newReportSessionId(this.$buildSessionId);
                BuildAttributionUiManagerImpl.access$updateReportUI(this.this$0);
            }
            {
                this.this$0 = buildAttributionUiManagerImpl;
                this.$buildSessionId = string;
                super(0);
            }
        }));
    }

    private final BuildAttributionReportUiData failedBuildReportData() {
        return new BuildAttributionReportUiData(){

            public boolean getSuccessfulBuild() {
                return false;
            }

            @NotNull
            public BuildSummary getBuildSummary() {
                throw (Throwable)new UnsupportedOperationException("Shouldn't be called on this object");
            }

            @NotNull
            public CriticalPathTasksUiData getCriticalPathTasks() {
                throw (Throwable)new UnsupportedOperationException("Shouldn't be called on this object");
            }

            @NotNull
            public CriticalPathPluginsUiData getCriticalPathPlugins() {
                throw (Throwable)new UnsupportedOperationException("Shouldn't be called on this object");
            }

            @NotNull
            public List<TaskIssuesGroup> getIssues() {
                throw (Throwable)new UnsupportedOperationException("Shouldn't be called on this object");
            }

            @NotNull
            public ConfigurationUiData getConfigurationTime() {
                throw (Throwable)new UnsupportedOperationException("Shouldn't be called on this object");
            }

            @NotNull
            public AnnotationProcessorsReport getAnnotationProcessors() {
                throw (Throwable)new UnsupportedOperationException("Shouldn't be called on this object");
            }

            public int getTotalIssuesCount() {
                return BuildAttributionReportUiData.DefaultImpls.getTotalIssuesCount(this);
            }
        };
    }

    @UiThread
    private final void updateReportUI() {
        Content content2 = this.buildContent;
        if (content2 != null && content2.isValid()) {
            this.createNewView();
            this.replaceContentView(content2);
        } else {
            BuildAttributionReportUiData buildAttributionReportUiData = this.reportUiData;
            if (buildAttributionReportUiData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"reportUiData");
            }
            if (buildAttributionReportUiData.getSuccessfulBuild()) {
                this.createNewView();
                this.createNewTab();
            }
        }
    }

    private final void createNewView() {
        ComponentContainer componentContainer = this.buildAttributionView;
        if (componentContainer != null) {
            ComponentContainer componentContainer2 = componentContainer;
            boolean bl = false;
            boolean bl2 = false;
            ComponentContainer existingView = componentContainer2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)((Disposable)existingView));
        }
        BuildAttributionReportUiData buildAttributionReportUiData = this.reportUiData;
        if (buildAttributionReportUiData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportUiData");
        }
        if (buildAttributionReportUiData.getSuccessfulBuild()) {
            BuildAttributionReportUiData buildAttributionReportUiData2 = this.reportUiData;
            if (buildAttributionReportUiData2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"reportUiData");
            }
            TaskIssueReporterImpl issueReporter = new TaskIssueReporterImpl(buildAttributionReportUiData2, this.project, this.uiAnalytics);
            BuildAttributionReportUiData buildAttributionReportUiData3 = this.reportUiData;
            if (buildAttributionReportUiData3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"reportUiData");
            }
            this.buildAttributionView = new NewViewComponentContainer(buildAttributionReportUiData3, this.project, issueReporter, this.uiAnalytics);
        } else {
            this.buildAttributionView = new BuildFailureViewComponentContainer();
        }
    }

    private final void replaceContentView(Content $this$replaceContentView) {
        block0: {
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer == null) break block0;
            ComponentContainer componentContainer2 = componentContainer;
            boolean bl = false;
            boolean bl2 = false;
            ComponentContainer view = componentContainer2;
            boolean bl3 = false;
            $this$replaceContentView.getComponent().removeAll();
            $this$replaceContentView.getComponent().add((Component)view.getComponent(), "Center");
            Disposer.register((Disposable)((Disposable)$this$replaceContentView), (Disposable)((Disposable)view));
            this.uiAnalytics.buildReportReplaced();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createNewTab() {
        block1: {
            void content2;
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer == null) break block1;
            ComponentContainer componentContainer2 = componentContainer;
            boolean bl = false;
            boolean bl2 = false;
            ComponentContainer view = componentContainer2;
            boolean bl3 = false;
            ContentImpl contentImpl = new ContentImpl((JComponent)new BorderLayoutPanel(), "Build Analyzer", true);
            boolean bl4 = false;
            boolean bl5 = false;
            ContentImpl contentImpl2 = contentImpl;
            BuildAttributionUiManagerImpl buildAttributionUiManagerImpl = this;
            boolean bl6 = false;
            content2.getComponent().add((Component)view.getComponent(), "Center");
            Disposer.register((Disposable)this, (Disposable)((Disposable)content2));
            Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)view));
            Disposer.register((Disposable)((Disposable)content2), (Disposable)new Disposable(view, this){
                final /* synthetic */ ComponentContainer $view$inlined;
                final /* synthetic */ BuildAttributionUiManagerImpl this$0;
                {
                    this.$view$inlined = componentContainer;
                    this.this$0 = buildAttributionUiManagerImpl;
                }

                public final void dispose() {
                    BuildAttributionUiManagerImpl.access$onContentClosed(this.this$0);
                }
            });
            ((BuildContentManager)this.project.getService(BuildContentManager.class)).addContent((Content)content2);
            this.uiAnalytics.tabCreated();
            ContentManager contentManager = this.contentManager = content2.getManager();
            if (contentManager != null) {
                contentManager.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
            }
            Unit unit = Unit.INSTANCE;
            buildAttributionUiManagerImpl.buildContent = (Content)contentImpl;
        }
    }

    private final void onContentClosed() {
        this.uiAnalytics.tabClosed();
        this.cleanUp();
    }

    private final void cleanUp() {
        ContentManager contentManager = this.contentManager;
        if (contentManager != null) {
            contentManager.removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        }
        this.contentManager = null;
        this.buildAttributionView = null;
        this.buildContent = null;
    }

    @Override
    public void openTab(@NotNull BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventSource), (String)"eventSource");
        if (this.hasDataToShow()) {
            this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this, eventSource){
                final /* synthetic */ BuildAttributionUiManagerImpl this$0;
                final /* synthetic */ BuildAttributionUiAnalytics.TabOpenEventSource $eventSource;

                public final void invoke() {
                    Content content2 = this.this$0.getBuildContent();
                    if (content2 == null || !content2.isValid()) {
                        BuildAttributionUiManagerImpl.access$createNewView(this.this$0);
                        BuildAttributionUiManagerImpl.access$createNewTab(this.this$0);
                    }
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).registerOpenEventSource(this.$eventSource);
                    ContentManager contentManager = BuildAttributionUiManagerImpl.access$getContentManager$p(this.this$0);
                    Intrinsics.checkNotNull((Object)contentManager);
                    Content content3 = this.this$0.getBuildContent();
                    Intrinsics.checkNotNull((Object)content3);
                    contentManager.setSelectedContent(content3, true, true);
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(BuildAttributionUiManagerImpl.access$getProject$p(this.this$0)).getToolWindow("Build");
                    Intrinsics.checkNotNull((Object)toolWindow);
                    toolWindow.show((Runnable)openTab.1.INSTANCE);
                }
                {
                    this.this$0 = buildAttributionUiManagerImpl;
                    this.$eventSource = tabOpenEventSource;
                    super(0);
                }
            }));
        }
    }

    @Override
    public void requestOpenTabWhenDataReady(@NotNull BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventSource), (String)"eventSource");
        if (this.getStateReporter().currentState() == BuildAttributionStateReporter.State.REPORT_DATA_READY) {
            this.openTab(eventSource);
        } else {
            this.openRequest = OpenRequest.Companion.requestFrom(eventSource);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasDataToShow() {
        if (this.reportUiData == null) return false;
        BuildAttributionReportUiData buildAttributionReportUiData = this.reportUiData;
        if (buildAttributionReportUiData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportUiData");
        }
        if (!buildAttributionReportUiData.getSuccessfulBuild()) return false;
        return true;
    }

    public void dispose() {
        this.cleanUp();
    }

    private final void invokeLaterIfNotDisposed(Function0<Unit> runnable2) {
        Application application = ApplicationManager.getApplication();
        Object object = runnable2;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            };
        }
        application.invokeLater((Runnable)object, new Condition(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;

            public final boolean value(Object it) {
                return BuildAttributionUiManagerImpl.access$getProject$p(this.this$0).isDisposed();
            }
            {
                this.this$0 = buildAttributionUiManagerImpl;
            }
        });
    }

    public BuildAttributionUiManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.stateReporter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildAttributionStateReporterImpl>(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;

            @NotNull
            public final BuildAttributionStateReporterImpl invoke() {
                return new BuildAttributionStateReporterImpl(BuildAttributionUiManagerImpl.access$getProject$p(this.this$0), this.this$0);
            }
            {
                this.this$0 = buildAttributionUiManagerImpl;
                super(0);
            }
        }));
        this.openRequest = OpenRequest.Companion.getNO_REQUEST();
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getContent() != this.this$0.getBuildContent()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).tabOpened();
                } else if (event.getOperation() == ContentManagerEvent.ContentOperation.remove) {
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).tabHidden();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.uiAnalytics = new BuildAttributionUiAnalytics(this.project, (Function0<? extends Dimension>)((Function0)new Function0<Dimension>(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;

            @Nullable
            public final Dimension invoke() {
                Object object = this.this$0.getBuildAttributionView();
                return object != null && (object = object.getComponent()) != null ? ((Component)object).getSize() : null;
            }
            {
                this.this$0 = buildAttributionUiManagerImpl;
                super(0);
            }
        }));
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(BuildAttributionStateReporter.Companion.getFEATURE_STATE_TOPIC(), (Object)new BuildAttributionStateReporter.Notifier(){

            @Override
            public void stateUpdated(@NotNull BuildAttributionStateReporter.State newState) {
                Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
                if (newState == BuildAttributionStateReporter.State.REPORT_DATA_READY && openRequest.getShouldOpen()) {
                    this.openTab(openRequest.getEventSource());
                    openRequest = OpenRequest.Companion.getNO_REQUEST();
                }
            }
        });
    }

    public static final /* synthetic */ BuildAttributionUiAnalytics access$getUiAnalytics$p(BuildAttributionUiManagerImpl $this) {
        return $this.uiAnalytics;
    }

    public static final /* synthetic */ void access$updateReportUI(BuildAttributionUiManagerImpl $this) {
        $this.updateReportUI();
    }

    public static final /* synthetic */ void access$onContentClosed(BuildAttributionUiManagerImpl $this) {
        $this.onContentClosed();
    }

    public static final /* synthetic */ void access$createNewView(BuildAttributionUiManagerImpl $this) {
        $this.createNewView();
    }

    public static final /* synthetic */ void access$createNewTab(BuildAttributionUiManagerImpl $this) {
        $this.createNewTab();
    }

    public static final /* synthetic */ ContentManager access$getContentManager$p(BuildAttributionUiManagerImpl $this) {
        return $this.contentManager;
    }

    public static final /* synthetic */ void access$setContentManager$p(BuildAttributionUiManagerImpl $this, ContentManager contentManager) {
        $this.contentManager = contentManager;
    }

    public static final /* synthetic */ Project access$getProject$p(BuildAttributionUiManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ BuildAttributionReportUiData access$getReportUiData$p(BuildAttributionUiManagerImpl $this) {
        BuildAttributionReportUiData buildAttributionReportUiData = $this.reportUiData;
        if (buildAttributionReportUiData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportUiData");
        }
        return buildAttributionReportUiData;
    }

    public static final /* synthetic */ void access$setReportUiData$p(BuildAttributionUiManagerImpl $this, BuildAttributionReportUiData buildAttributionReportUiData) {
        $this.reportUiData = buildAttributionReportUiData;
    }
}

