/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0011\u001a\u000f\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0005*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0011\u001a\u000f\u0010\u0013\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0005*\u00020\u0011\u00a8\u0006\u0014"}, d2={"durationString", "", "timeMs", "", "durationStringHtml", "Lorg/jetbrains/annotations/NotNull;", "htmlTextLabelWithFixedLines", "Ljavax/swing/JEditorPane;", "htmlBodyContent", "htmlTextLabelWithLinesWrap", "warningIcon", "Ljavax/swing/Icon;", "warningsCountString", "warningsCount", "", "wrapPathToSpans", "text", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "percentageString", "percentageStringHtml", "intellij.android.build-attribution"})
public final class BuildAttributionUIUtilKt {
    @NotNull
    public static final String durationString(@NotNull TimeWithPercentage $this$durationString) {
        Intrinsics.checkNotNullParameter((Object)$this$durationString, (String)"$this$durationString");
        return BuildAttributionUIUtilKt.durationString($this$durationString.getTimeMs());
    }

    @NotNull
    public static final String durationStringHtml(@NotNull TimeWithPercentage $this$durationStringHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$durationStringHtml, (String)"$this$durationStringHtml");
        return BuildAttributionUIUtilKt.durationStringHtml($this$durationStringHtml.getTimeMs());
    }

    @NotNull
    public static final String percentageString(@NotNull TimeWithPercentage $this$percentageString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$percentageString, (String)"$this$percentageString");
        if ($this$percentageString.getPercentage() >= 0.1) {
            String string2 = "%.1f%%";
            Object[] objectArray = new Object[]{$this$percentageString.getPercentage()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        } else {
            string = "<0.1%";
        }
        return string;
    }

    @NotNull
    public static final String percentageStringHtml(@NotNull TimeWithPercentage $this$percentageStringHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$percentageStringHtml, (String)"$this$percentageStringHtml");
        String string = StringUtil.escapeXmlEntities((String)BuildAttributionUIUtilKt.percentageString($this$percentageStringHtml));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.escapeXmlEntities(percentageString())");
        return string;
    }

    @NotNull
    public static final String durationString(long timeMs) {
        String string;
        if (timeMs == 0L) {
            string = "0.0s";
        } else if (timeMs < 100L) {
            string = "<0.1s";
        } else {
            String string2 = "%.1fs";
            Object[] objectArray = new Object[]{(double)timeMs / (double)1000};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        }
        return string;
    }

    @NotNull
    public static final String durationStringHtml(long timeMs) {
        String string = StringUtil.escapeXmlEntities((String)BuildAttributionUIUtilKt.durationString(timeMs));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.escapeXmlEnti\u2026s(durationString(timeMs))");
        return string;
    }

    @NotNull
    public static final String warningsCountString(int warningsCount) {
        String string;
        switch (warningsCount) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "1 warning";
                break;
            }
            default: {
                string = warningsCount + " warnings";
            }
        }
        return string;
    }

    @NotNull
    public static final Icon warningIcon() {
        Icon icon2 = AllIcons.General.BalloonWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.General.BalloonWarning");
        return icon2;
    }

    @NotNull
    public static final JEditorPane htmlTextLabelWithLinesWrap(@NotNull String htmlBodyContent) {
        Intrinsics.checkNotNullParameter((Object)htmlBodyContent, (String)"htmlBodyContent");
        JEditorPane jEditorPane = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"SwingHelper.createHtmlVi\u2026r(true, null, null, null)");
        JEditorPane jEditorPane2 = jEditorPane;
        boolean bl = false;
        boolean bl2 = false;
        JEditorPane $this$apply = jEditorPane2;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        SwingHelper.setHtml((JEditorPane)$this$apply, (String)htmlBodyContent, null);
        return jEditorPane2;
    }

    @NotNull
    public static final JEditorPane htmlTextLabelWithFixedLines(@NotNull String htmlBodyContent) {
        Intrinsics.checkNotNullParameter((Object)htmlBodyContent, (String)"htmlBodyContent");
        JEditorPane jEditorPane = SwingHelper.createHtmlViewer((boolean)false, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"SwingHelper.createHtmlVi\u2026(false, null, null, null)");
        JEditorPane jEditorPane2 = jEditorPane;
        boolean bl = false;
        boolean bl2 = false;
        JEditorPane $this$apply = jEditorPane2;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        SwingHelper.setHtml((JEditorPane)$this$apply, (String)htmlBodyContent, null);
        return jEditorPane2;
    }

    @NotNull
    public static final String wrapPathToSpans(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return "<p>" + StringsKt.replace$default((String)text2, (String)"/", (String)"<span>/</span>", (boolean)false, (int)4, null) + "</p>";
    }
}

