/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.data.PluginBuildData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.data.TaskData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010*\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00132\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130\u0014H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130\u0014H\u0002J\u0016\u0010,\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u0014H\u0002J,\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\u00142\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001302H\u0002J&\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130\u00142\u0006\u00106\u001a\u000204H\u0002J,\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u00142\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001302H\u0002J\b\u00108\u001a\u00020(H\u0016J\b\u00109\u001a\u00020(H\u0016J\b\u0010:\u001a\u00020(H\u0016J\u0010\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020=H\u0016R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR6\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00140\u0012j\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR!\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0017j\b\u0012\u0004\u0012\u00020\u0013`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u001fj\b\u0012\u0004\u0012\u00020\u0013` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006>"}, d2={"Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "warningsFilter", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/BuildAttributionWarningsFilter;Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "<set-?>", "", "buildFinishedTimestamp", "getBuildFinishedTimestamp", "()J", "buildStartedTimestamp", "getBuildStartedTimestamp", "dependenciesMap", "Ljava/util/HashMap;", "Lcom/android/build/attribution/data/TaskData;", "", "Lkotlin/collections/HashMap;", "pluginsDeterminingBuildDuration", "Ljava/util/ArrayList;", "Lcom/android/build/attribution/data/PluginBuildData;", "Lkotlin/collections/ArrayList;", "getPluginsDeterminingBuildDuration", "()Ljava/util/ArrayList;", "tasksDeterminingBuildDuration", "getTasksDeterminingBuildDuration", "tasksSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getWarningsFilter", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "calculateCriticalPathStartingFromTask", "startTask", "criticalPathFromTaskMap", "", "calculatePluginsDeterminingBuildDuration", "", "calculateTasksCriticalPathBasedOnDependencies", "calculateTasksCriticalPathBasedOnExecution", "tasks", "calculateTasksDeterminingBuildDuration", "tasksCriticalPath", "getCriticalPathOfTasksStrictlyInTimeRange", "startTime", "endTime", "taskListSortedByStartTimeIterator", "", "getIndexOfFirstTaskStartingAtOrAfterTimestamp", "", "timestamp", "searchStartIndex", "getTasksStrictlyInTimeRange", "onBuildFailure", "onBuildStart", "onBuildSuccess", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "intellij.android.build-attribution"})
public final class CriticalPathAnalyzer
extends BaseAnalyzer
implements BuildEventsAnalyzer {
    private final HashSet<TaskData> tasksSet;
    private final HashMap<TaskData, List<TaskData>> dependenciesMap;
    @NotNull
    private final ArrayList<TaskData> tasksDeterminingBuildDuration;
    @NotNull
    private final ArrayList<PluginBuildData> pluginsDeterminingBuildDuration;
    private long buildStartedTimestamp;
    private long buildFinishedTimestamp;
    @NotNull
    private final BuildAttributionWarningsFilter warningsFilter;

    @NotNull
    public final ArrayList<TaskData> getTasksDeterminingBuildDuration() {
        return this.tasksDeterminingBuildDuration;
    }

    @NotNull
    public final ArrayList<PluginBuildData> getPluginsDeterminingBuildDuration() {
        return this.pluginsDeterminingBuildDuration;
    }

    public final long getBuildStartedTimestamp() {
        return this.buildStartedTimestamp;
    }

    public final long getBuildFinishedTimestamp() {
        return this.buildFinishedTimestamp;
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof FinishEvent) {
            OperationResult operationResult = ((FinishEvent)event).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)operationResult, (String)"event.result");
            this.buildStartedTimestamp = RangesKt.coerceAtMost((long)this.buildStartedTimestamp, (long)operationResult.getStartTime());
            OperationResult operationResult2 = ((FinishEvent)event).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)operationResult2, (String)"event.result");
            this.buildFinishedTimestamp = RangesKt.coerceAtLeast((long)this.buildFinishedTimestamp, (long)operationResult2.getEndTime());
        }
        if (event instanceof TaskFinishEvent && ((TaskFinishEvent)event).getResult() instanceof TaskSuccessResult) {
            TaskData task2 = this.getTask((TaskFinishEvent)event);
            ArrayList<TaskData> dependenciesList = new ArrayList<TaskData>();
            TaskOperationDescriptor taskOperationDescriptor = ((TaskFinishEvent)event).getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)taskOperationDescriptor, (String)"event.descriptor");
            Set set = taskOperationDescriptor.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"event.descriptor.dependencies");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskData taskData;
                OperationDescriptor dependency = (OperationDescriptor)element$iv;
                boolean bl = false;
                if (!(dependency instanceof TaskOperationDescriptor)) continue;
                String string = ((TaskOperationDescriptor)dependency).getTaskPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.taskPath");
                if (this.getTask(string) == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                TaskData it = taskData;
                boolean bl4 = false;
                dependenciesList.add(it);
            }
            this.tasksSet.add(task2);
            ((Map)this.dependenciesMap).put(task2, dependenciesList);
        }
    }

    private final long calculateCriticalPathStartingFromTask(TaskData startTask, Map<TaskData, Long> criticalPathFromTaskMap) {
        Long l = criticalPathFromTaskMap.get(startTask);
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            return it;
        }
        long criticalPathDuration = 0L;
        List<TaskData> list = this.dependenciesMap.get(startTask);
        Intrinsics.checkNotNull(list);
        Intrinsics.checkNotNullExpressionValue(list, (String)"dependenciesMap[startTask]!!");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskData dependency = (TaskData)element$iv;
            boolean bl = false;
            long l3 = criticalPathDuration;
            long l4 = this.calculateCriticalPathStartingFromTask(dependency, criticalPathFromTaskMap);
            boolean bl4 = false;
            criticalPathDuration = Math.max(l3, l4);
        }
        criticalPathFromTaskMap.put(startTask, criticalPathDuration += startTask.getExecutionTime());
        return criticalPathDuration;
    }

    private final List<TaskData> calculateTasksCriticalPathBasedOnDependencies() {
        ArrayList<TaskData> tasksCriticalPath = new ArrayList<TaskData>();
        HashMap criticalPathFromTaskMap = new HashMap();
        TaskData startTask = null;
        long currentCriticalPathDuration = -1L;
        Iterable $this$forEach$iv = this.tasksSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskData it = (TaskData)element$iv;
            boolean bl = false;
            long criticalPathFromTask = this.calculateCriticalPathStartingFromTask(it, criticalPathFromTaskMap);
            if (currentCriticalPathDuration >= criticalPathFromTask) continue;
            currentCriticalPathDuration = criticalPathFromTask;
            startTask = it;
        }
        while (startTask != null) {
            TaskData taskData = startTask;
            Intrinsics.checkNotNull((Object)taskData);
            tasksCriticalPath.add(taskData);
            TaskData nextTask = null;
            currentCriticalPathDuration = -1L;
            TaskData taskData2 = startTask;
            Intrinsics.checkNotNull((Object)taskData2);
            List<TaskData> list = this.dependenciesMap.get(taskData2);
            Intrinsics.checkNotNull(list);
            Intrinsics.checkNotNullExpressionValue(list, (String)"dependenciesMap[startTask!!]!!");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TaskData dependency = (TaskData)element$iv;
                boolean bl = false;
                Object v = criticalPathFromTaskMap.get(dependency);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"criticalPathFromTaskMap[dependency]!!");
                long criticalPathFromTask = ((Number)v).longValue();
                if (currentCriticalPathDuration >= criticalPathFromTask) continue;
                currentCriticalPathDuration = criticalPathFromTask;
                nextTask = dependency;
            }
            startTask = nextTask;
        }
        CollectionsKt.reverse((List)tasksCriticalPath);
        return tasksCriticalPath;
    }

    private final int getIndexOfFirstTaskStartingAtOrAfterTimestamp(long timestamp, List<TaskData> tasks, int searchStartIndex) {
        if (((TaskData)CollectionsKt.last(tasks)).getExecutionStartTime() < timestamp) {
            return -1;
        }
        int left2 = searchStartIndex;
        int right2 = tasks.size() - 1;
        while (left2 < right2) {
            int middle = left2 + (right2 - left2) / 2;
            if (tasks.get(middle).getExecutionStartTime() < timestamp) {
                left2 = middle + 1;
                continue;
            }
            right2 = middle;
        }
        return left2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TaskData> calculateTasksCriticalPathBasedOnExecution(List<TaskData> tasks) {
        int n;
        int n2;
        int n3;
        int n4;
        Number number;
        ArrayList<Long> arrayList;
        void $this$mapTo$iv$iv2;
        if (tasks.isEmpty()) {
            return tasks;
        }
        Iterable $this$map$iv = tasks;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        ArrayList<Long> destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo322 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TaskData taskData = (TaskData)item$iv$iv;
            arrayList = destination$iv$iv22;
            boolean bl = false;
            number = it.getExecutionTime();
            arrayList.add((Long)number);
        }
        List criticalPathFromTask = CollectionsKt.toMutableList((Collection)destination$iv$iv22);
        $i$f$map = tasks.size();
        int $this$mapTo$iv$iv2 = 0;
        boolean destination$iv$iv22 = false;
        ArrayList<Long> $i$f$mapTo322 = new ArrayList<Long>($i$f$map);
        boolean bl = false;
        int n5 = 0;
        n5 = 0;
        int n6 = $i$f$map;
        while (n5 < n6) {
            void it;
            n4 = n5++;
            n3 = 0;
            n2 = n4;
            arrayList = $i$f$mapTo322;
            n = 0;
            number = (int)it;
            arrayList.add((Long)number);
        }
        List maxCriticalPathStartIndexInSuffix = CollectionsKt.toMutableList((Collection)$i$f$mapTo322);
        $this$mapTo$iv$iv2 = tasks.size();
        destination$iv$iv22 = false;
        boolean $i$f$mapTo322 = false;
        ArrayList arrayList2 = new ArrayList($this$mapTo$iv$iv2);
        n5 = 0;
        n6 = 0;
        n6 = 0;
        n4 = $this$mapTo$iv$iv2;
        while (n6 < n4) {
            n3 = n6++;
            n2 = 0;
            n = n3;
            arrayList = arrayList2;
            boolean bl2 = false;
            number = -1;
            arrayList.add((Long)number);
        }
        List bestChoiceIndex = CollectionsKt.toMutableList((Collection)arrayList2);
        $this$mapTo$iv$iv2 = tasks.size() - 2;
        destination$iv$iv22 = false;
        while ($this$mapTo$iv$iv2 >= 0) {
            void i2;
            int firstTaskIndex = this.getIndexOfFirstTaskStartingAtOrAfterTimestamp(tasks.get((int)i2).getExecutionEndTime(), tasks, (int)(i2 + true));
            if (firstTaskIndex != -1) {
                bestChoiceIndex.set((int)i2, maxCriticalPathStartIndexInSuffix.get(firstTaskIndex));
                criticalPathFromTask.set((int)i2, tasks.get((int)i2).getExecutionTime() + ((Number)criticalPathFromTask.get(((Number)bestChoiceIndex.get((int)i2)).intValue())).longValue());
            }
            if (((Number)criticalPathFromTask.get((int)i2)).longValue() < ((Number)criticalPathFromTask.get(((Number)maxCriticalPathStartIndexInSuffix.get((int)(i2 + true))).intValue())).longValue()) {
                maxCriticalPathStartIndexInSuffix.set((int)i2, maxCriticalPathStartIndexInSuffix.get((int)(i2 + true)));
            }
            --i2;
        }
        ArrayList<TaskData> criticalPath = new ArrayList<TaskData>();
        int index2 = ((Number)maxCriticalPathStartIndexInSuffix.get(0)).intValue();
        while (index2 != -1) {
            criticalPath.add(tasks.get(index2));
            index2 = ((Number)bestChoiceIndex.get(index2)).intValue();
        }
        return criticalPath;
    }

    private final List<TaskData> getTasksStrictlyInTimeRange(long startTime, long endTime, ListIterator<TaskData> taskListSortedByStartTimeIterator) {
        ArrayList<TaskData> tasksInBetween = new ArrayList<TaskData>();
        while (taskListSortedByStartTimeIterator.hasNext()) {
            TaskData currentTask = taskListSortedByStartTimeIterator.next();
            if (currentTask.getExecutionStartTime() < startTime) continue;
            if (currentTask.getExecutionStartTime() >= endTime) {
                taskListSortedByStartTimeIterator.previous();
                break;
            }
            if (currentTask.getExecutionEndTime() > endTime || currentTask.isOnTheCriticalPath()) continue;
            tasksInBetween.add(currentTask);
        }
        return tasksInBetween;
    }

    private final List<TaskData> getCriticalPathOfTasksStrictlyInTimeRange(long startTime, long endTime, ListIterator<TaskData> taskListSortedByStartTimeIterator) {
        return this.calculateTasksCriticalPathBasedOnExecution(this.getTasksStrictlyInTimeRange(startTime, endTime, taskListSortedByStartTimeIterator));
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTasksDeterminingBuildDuration(List<TaskData> tasksCriticalPath) {
        void $this$filterNot$iv;
        TaskData previousCriticalPathTask;
        boolean $i$f$filterNot;
        ArrayList<Object> tasksDeterminingBuildDurationList = new ArrayList<Object>();
        Iterable $this$sortedBy$iv = this.tasksSet;
        boolean $i$f$sortedBy2 = false;
        boolean bl = false;
        List taskListSortedByStartTime = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskData it = (TaskData)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getExecutionStartTime());
                it = (TaskData)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getExecutionStartTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        ListIterator<TaskData> listIterator = taskListSortedByStartTime.listIterator();
        if (tasksCriticalPath.isEmpty()) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv2;
            Iterable $i$f$sortedBy2 = this.calculateTasksCriticalPathBasedOnExecution(taskListSortedByStartTime);
            ArrayList<TaskData> arrayList = this.tasksDeterminingBuildDuration;
            $i$f$filterNot = false;
            void var7_13 = $this$filterNot$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                TaskData it = (TaskData)element$iv$iv;
                boolean bl2 = false;
                if (it.getExecutionMode() == TaskData.TaskExecutionMode.UP_TO_DATE) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            arrayList.addAll(list);
            return;
        }
        Iterable $this$forEach$iv22 = tasksCriticalPath;
        int $i$f$forEach = 0;
        Iterator $this$filterNotTo$iv$iv = $this$forEach$iv22.iterator();
        while ($this$filterNotTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterNotTo$iv$iv.next();
            TaskData task2 = (TaskData)element$iv;
            boolean bl3 = false;
            task2.setOnTheCriticalPath(true);
        }
        tasksDeterminingBuildDurationList.addAll((Collection)this.getCriticalPathOfTasksStrictlyInTimeRange(0L, ((TaskData)CollectionsKt.first(tasksCriticalPath)).getExecutionStartTime(), listIterator));
        int $this$forEach$iv22 = 0;
        $i$f$forEach = tasksCriticalPath.size() - 1;
        while ($this$forEach$iv22 < $i$f$forEach) {
            void i2;
            previousCriticalPathTask = tasksCriticalPath.get((int)i2);
            TaskData nextCriticalPathTask = tasksCriticalPath.get((int)(i2 + true));
            tasksDeterminingBuildDurationList.add(previousCriticalPathTask);
            tasksDeterminingBuildDurationList.addAll((Collection)this.getCriticalPathOfTasksStrictlyInTimeRange(previousCriticalPathTask.getExecutionEndTime(), nextCriticalPathTask.getExecutionStartTime(), listIterator));
            ++i2;
        }
        tasksDeterminingBuildDurationList.add(CollectionsKt.last(tasksCriticalPath));
        tasksDeterminingBuildDurationList.addAll((Collection)this.getCriticalPathOfTasksStrictlyInTimeRange(((TaskData)CollectionsKt.last(tasksCriticalPath)).getExecutionEndTime(), Long.MAX_VALUE, listIterator));
        Iterable i2 = tasksDeterminingBuildDurationList;
        ArrayList<TaskData> arrayList = this.tasksDeterminingBuildDuration;
        $i$f$filterNot = false;
        previousCriticalPathTask = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            TaskData it = (TaskData)element$iv$iv;
            boolean bl4 = false;
            if (it.getExecutionMode() == TaskData.TaskExecutionMode.UP_TO_DATE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList.addAll(list);
    }

    /*
     * WARNING - void declaration
     */
    private final void calculatePluginsDeterminingBuildDuration() {
        HashMap pluginBuildDurationMap = new HashMap();
        Object $this$forEach$iv = this.tasksDeterminingBuildDuration;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            TaskData task2 = (TaskData)element$iv;
            boolean bl = false;
            Long l = pluginBuildDurationMap.getOrDefault(task2.getOriginPlugin(), 0L);
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"pluginBuildDurationMap.g\u2026lt(task.originPlugin, 0L)");
            long currentDuration = ((Number)l).longValue();
            ((Map)pluginBuildDurationMap).put(task2.getOriginPlugin(), currentDuration + task2.getExecutionTime());
        }
        $this$forEach$iv = pluginBuildDurationMap;
        $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void plugin;
            Map.Entry element$iv;
            Map.Entry $dstr$plugin$duration = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$plugin$duration;
            boolean bl3 = false;
            PluginData pluginData = (PluginData)entry.getKey();
            entry = $dstr$plugin$duration;
            bl3 = false;
            long duration2 = ((Number)entry.getValue()).longValue();
            this.pluginsDeterminingBuildDuration.add(new PluginBuildData((PluginData)plugin, duration2));
        }
        List $this$sortByDescending$iv = this.pluginsDeterminingBuildDuration;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            boolean bl4 = false;
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PluginBuildData it = (PluginBuildData)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getBuildDuration());
                    it = (PluginBuildData)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = it.getBuildDuration();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            });
        }
    }

    @Override
    public void onBuildStart() {
        super.onBuildStart();
        this.tasksSet.clear();
        this.dependenciesMap.clear();
        this.tasksDeterminingBuildDuration.clear();
        this.pluginsDeterminingBuildDuration.clear();
        this.buildStartedTimestamp = Long.MAX_VALUE;
        this.buildFinishedTimestamp = Long.MIN_VALUE;
    }

    @Override
    public void onBuildSuccess() {
        this.calculateTasksDeterminingBuildDuration(this.calculateTasksCriticalPathBasedOnDependencies());
        this.calculatePluginsDeterminingBuildDuration();
        this.tasksSet.clear();
        this.dependenciesMap.clear();
    }

    @Override
    public void onBuildFailure() {
        this.tasksSet.clear();
        this.dependenciesMap.clear();
    }

    @Override
    @NotNull
    public BuildAttributionWarningsFilter getWarningsFilter() {
        return this.warningsFilter;
    }

    public CriticalPathAnalyzer(@NotNull BuildAttributionWarningsFilter warningsFilter, @NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)warningsFilter, (String)"warningsFilter");
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        super(taskContainer, pluginContainer);
        this.warningsFilter = warningsFilter;
        this.tasksSet = new HashSet();
        this.dependenciesMap = new HashMap();
        this.tasksDeterminingBuildDuration = new ArrayList();
        this.pluginsDeterminingBuildDuration = new ArrayList();
        this.buildStartedTimestamp = Long.MAX_VALUE;
        this.buildFinishedTimestamp = Long.MIN_VALUE;
    }
}

