/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.BuildAttributionStateReporter;
import com.android.build.attribution.BuildAttributionStateReporterImpl$WhenMappings;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AppUIUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\u0006\u0010\u0012\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/attribution/BuildAttributionStateReporterImpl;", "Lcom/android/build/attribution/BuildAttributionStateReporter;", "project", "Lcom/intellij/openapi/project/Project;", "uiManager", "Lcom/android/build/attribution/ui/BuildAttributionUiManager;", "(Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/BuildAttributionUiManager;)V", "state", "Lcom/android/build/attribution/BuildAttributionStateReporter$State;", "calculateInitState", "changeStateTo", "", "newState", "currentState", "dispose", "newStateOnBuildFail", "newStateOnBuildStart", "newStateOnSync", "setStateDataExist", "intellij.android.build-attribution"})
public final class BuildAttributionStateReporterImpl
implements BuildAttributionStateReporter {
    private BuildAttributionStateReporter.State state;
    private final Project project;
    private final BuildAttributionUiManager uiManager;

    public final void setStateDataExist() {
        this.changeStateTo(BuildAttributionStateReporter.State.REPORT_DATA_READY);
    }

    @Override
    @NotNull
    public BuildAttributionStateReporter.State currentState() {
        return this.state;
    }

    public void dispose() {
    }

    private final BuildAttributionStateReporter.State calculateInitState() {
        return (Boolean)StudioFlags.BUILD_ATTRIBUTION_ENABLED.get() == false ? BuildAttributionStateReporter.State.FEATURE_TURNED_OFF : (!BuildAttributionUtil.isAgpVersionHigherOrEqualToMinimal(this.project) ? BuildAttributionStateReporter.State.AGP_VERSION_LOW : (this.uiManager.hasDataToShow() ? BuildAttributionStateReporter.State.REPORT_DATA_READY : BuildAttributionStateReporter.State.NO_DATA));
    }

    private final BuildAttributionStateReporter.State newStateOnBuildStart() {
        BuildAttributionStateReporter.State state;
        switch (BuildAttributionStateReporterImpl$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: 
            case 2: {
                state = BuildAttributionStateReporter.State.NO_DATA_BUILD_RUNNING;
                break;
            }
            default: {
                state = this.state;
            }
        }
        return state;
    }

    private final BuildAttributionStateReporter.State newStateOnBuildFail() {
        BuildAttributionStateReporter.State state;
        switch (BuildAttributionStateReporterImpl$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: 
            case 2: {
                state = BuildAttributionStateReporter.State.NO_DATA_BUILD_FAILED_TO_FINISH;
                break;
            }
            default: {
                state = this.state;
            }
        }
        return state;
    }

    private final BuildAttributionStateReporter.State newStateOnSync() {
        return this.calculateInitState();
    }

    private final void changeStateTo(BuildAttributionStateReporter.State newState) {
        if (this.state == newState) {
            return;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, (Runnable)new Runnable(this, newState){
            final /* synthetic */ BuildAttributionStateReporterImpl this$0;
            final /* synthetic */ BuildAttributionStateReporter.State $newState;

            public final void run() {
                BuildAttributionStateReporterImpl.access$setState$p(this.this$0, this.$newState);
                ((BuildAttributionStateReporter.Notifier)BuildAttributionStateReporterImpl.access$getProject$p(this.this$0).getMessageBus().syncPublisher(BuildAttributionStateReporter.Companion.getFEATURE_STATE_TOPIC())).stateUpdated(BuildAttributionStateReporterImpl.access$getState$p(this.this$0));
            }
            {
                this.this$0 = buildAttributionStateReporterImpl;
                this.$newState = state;
            }
        });
    }

    public BuildAttributionStateReporterImpl(@NotNull Project project, @NotNull BuildAttributionUiManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        this.project = project;
        this.uiManager = uiManager;
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
        this.state = this.calculateInitState();
        GradleBuildState.subscribe(this.project, new GradleBuildListener.Adapter(){

            @Override
            public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (!status.isBuildSuccessful()) {
                    this.changeStateTo(this.newStateOnBuildFail());
                }
            }

            @Override
            public void buildStarted(@NotNull BuildContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.changeStateTo(this.newStateOnBuildStart());
            }
        }, this);
        GradleSyncState.Companion.subscribe(this.project, new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.changeStateTo(this.newStateOnSync());
            }
        }, this);
    }

    public static final /* synthetic */ BuildAttributionStateReporter.State access$getState$p(BuildAttributionStateReporterImpl $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(BuildAttributionStateReporterImpl $this, BuildAttributionStateReporter.State state) {
        $this.state = state;
    }

    public static final /* synthetic */ Project access$getProject$p(BuildAttributionStateReporterImpl $this) {
        return $this.project;
    }
}

