/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;

final class SceneBuilderUtil {
    private static final Logger LOG = Logger.getInstance(SceneBuilderUtil.class);
    static final String SCENE_BUILDER_VERSION = "11.0.6";
    static final String JAVAFX_VERSION = "11.0.2";
    static final String SCENE_BUILDER_KIT_FULL_NAME = "scenebuilderkit-11.0.6.jar";
    public static final String[] JAVAFX_ARTIFACTS = new String[]{"javafx-fxml", "javafx-controls", "javafx-graphics", "javafx-base", "javafx-swing", "javafx-media", "javafx-web"};
    private static URLClassLoader ourLoader = SceneBuilderUtil.createClassLoader();

    SceneBuilderUtil() {
    }

    static SceneBuilder create(URL url, Project project, EditorCallback editorCallback) throws Exception {
        Class<?> java11Class = ourLoader.loadClass("org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderImpl");
        Constructor<?> constructor = java11Class.getConstructor(URL.class, Project.class, EditorCallback.class, ClassLoader.class);
        return (SceneBuilder)constructor.newInstance(url, project, editorCallback, ourLoader);
    }

    private static URLClassLoader createClassLoader() {
        return new URLClassLoader(SceneBuilderUtil.getLibUrls(), SceneBuilderUtil.class.getClassLoader());
    }

    public static void updateLoader() {
        ourLoader = SceneBuilderUtil.createClassLoader();
    }

    private static URL[] getLibUrls() {
        try {
            Path javaFxJar = Paths.get(PathUtil.getJarPathForClass(SceneBuilderUtil.class), new String[0]);
            boolean isDevMode = Files.isDirectory(javaFxJar, new LinkOption[0]);
            Path sceneBuilder = SceneBuilderUtil.getSceneBuilder11Path();
            Path sceneBuilderImpl = SceneBuilderUtil.getJarPath(isDevMode ? "intellij.javaFX.sceneBuilder" : "rt/sceneBuilderBridge.jar", javaFxJar);
            try {
                Class.forName("javafx.scene.Node");
            }
            catch (ClassNotFoundException e) {
                try {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    urls.add(sceneBuilder.toUri().toURL());
                    urls.add(sceneBuilderImpl.toUri().toURL());
                    SceneBuilderUtil.addJavafxFromLocalRepository(urls);
                    return urls.toArray(new URL[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new URL[]{sceneBuilder.toUri().toURL(), sceneBuilderImpl.toUri().toURL()};
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return new URL[0];
        }
    }

    private static void addJavafxFromLocalRepository(List<URL> urls) throws IOException {
        File localRepositoryPath = JarRepositoryManager.getLocalRepositoryPath();
        Path javaFx = Paths.get(localRepositoryPath.getPath(), "org", "openjfx");
        for (String artifact : JAVAFX_ARTIFACTS) {
            Path path2Artifact = javaFx.resolve(artifact).resolve(JAVAFX_VERSION);
            try (Stream<Path> artifacts = Files.list(path2Artifact);){
                List paths = artifacts.filter(path -> {
                    String name = path.toFile().getName();
                    return name.startsWith(artifact + "-11.0.2") && name.endsWith(".jar");
                }).collect(Collectors.toList());
                for (Path path2 : paths) {
                    urls.add(path2.toUri().toURL());
                }
            }
        }
    }

    static Path getSceneBuilder11Path() {
        return Paths.get(PathManager.getConfigPath(), "plugins", "javaFX", "rt", SCENE_BUILDER_VERSION).resolve(SCENE_BUILDER_KIT_FULL_NAME);
    }

    private static Path getJarPath(@NotNull String relativePath, @NotNull Path javafxRuntimePath) {
        if (relativePath == null) {
            SceneBuilderUtil.$$$reportNull$$$0(0);
        }
        if (javafxRuntimePath == null) {
            SceneBuilderUtil.$$$reportNull$$$0(1);
        }
        return javafxRuntimePath.getParent().resolve(relativePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "relativePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "javafxRuntimePath";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderUtil";
        objectArray[2] = "getJarPath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

