/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.xml.XmlDoctypeImpl;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HAMLDoctypeImpl
extends XmlDoctypeImpl
implements XmlProlog {
    private static final String XHTML = "xhtml";
    private static final String HTML4 = "html4";
    private static final Map<String, Map<String, String>> DOCTYPE_TO_DTD;
    private static final Map<String, String> DEFAULT_DTD;

    public String getDtdUri() {
        String text = StringUtil.toLowerCase((String)this.getText());
        if (text.contains("xml")) {
            return null;
        }
        String baseType = StringUtil.toLowerCase((String)HAMLDoctypeImpl.getBaseType());
        if (!DOCTYPE_TO_DTD.containsKey(baseType)) {
            return null;
        }
        Map<String, String> map = DOCTYPE_TO_DTD.get(baseType);
        for (String doctype : map.keySet()) {
            if (!text.contains(doctype)) continue;
            return map.get(doctype);
        }
        return DEFAULT_DTD.get(baseType);
    }

    protected PsiReference createUrlReference(PsiElement dtdUrlElement) {
        return new PsiReferenceBase.Immediate<PsiElement>(dtdUrlElement, TextRange.from((int)0, (int)dtdUrlElement.getTextLength()), (PsiElement)this){

            public Object @NotNull [] getVariants() {
                HashSet<String> variants = new HashSet<String>();
                for (Map.Entry<String, Map<String, String>> entry : DOCTYPE_TO_DTD.entrySet()) {
                    variants.addAll(entry.getValue().keySet());
                }
                Object[] objectArray = ArrayUtil.toObjectArray(variants);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLDoctypeImpl$1", "getVariants"));
            }
        };
    }

    public XmlElement getDtdUrlElement() {
        return this;
    }

    public XmlElement getNameElement() {
        return this;
    }

    public XmlDoctype getDoctype() {
        return this;
    }

    public static String getBaseType() {
        return XHTML;
    }

    static {
        HashMap doctypeToDtd = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("5", null);
        map.put("1.1", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        map.put("strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        map.put("frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        map.put("mobile", "http://www.openmobilealliance.org/tech/DTD/xhtml-mobile12.dtd");
        map.put("basic", "http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd");
        map.put("rdfa", "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd");
        doctypeToDtd.put(XHTML, Collections.unmodifiableMap(map));
        map = new HashMap();
        map.put("strict", "http://www.w3.org/TR/html4/strict.dtd");
        map.put("frameset", "http://www.w3.org/TR/html4/frameset.dtd");
        doctypeToDtd.put(HTML4, Collections.unmodifiableMap(map));
        DOCTYPE_TO_DTD = Collections.unmodifiableMap(doctypeToDtd);
        map = new HashMap();
        map.put(XHTML, "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        map.put(HTML4, "http://www.w3.org/TR/html4/loose.dtd");
        DEFAULT_DTD = Collections.unmodifiableMap(map);
    }
}

