/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.recommenders.java.commons.names;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.jetbrains.recommenders.java.commons.names.IFieldName;
import com.jetbrains.recommenders.java.commons.names.IMemberName;
import com.jetbrains.recommenders.java.commons.names.IMethodName;
import com.jetbrains.recommenders.java.commons.names.IName;
import com.jetbrains.recommenders.java.commons.names.ITypeName;
import com.jetbrains.recommenders.java.commons.names.MethodSignature;
import com.jetbrains.recommenders.java.commons.names.QualifiedFieldName;
import com.jetbrains.recommenders.java.commons.names.QualifiedMemberName;
import com.jetbrains.recommenders.java.commons.names.QualifiedMethodName;
import com.jetbrains.recommenders.java.commons.names.QualifiedName;
import com.jetbrains.recommenders.java.commons.names.SimpleName;
import com.jetbrains.recommenders.java.commons.names.VmTypeName;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00122\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0012B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/recommenders/java/commons/names/QualifiedName;", "Lcom/jetbrains/recommenders/java/commons/names/IName;", "", "name", "", "declaringType", "Lcom/jetbrains/recommenders/java/commons/names/ITypeName;", "(Ljava/lang/String;Lcom/jetbrains/recommenders/java/commons/names/ITypeName;)V", "getDeclaringType", "()Lcom/jetbrains/recommenders/java/commons/names/ITypeName;", "identifier", "getIdentifier", "()Ljava/lang/String;", "getName", "compareTo", "", "other", "toString", "Companion", "recommenders-java-commons"})
public class QualifiedName
implements IName,
Comparable<QualifiedName> {
    @NotNull
    private final String name;
    @NotNull
    private final ITypeName declaringType;
    private static final Interner<QualifiedName> interner;
    public static final Companion Companion;

    @Override
    @JsonValue
    @JsonIgnore
    @NotNull
    public String getIdentifier() {
        return this.declaringType + '.' + this.getName();
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Comparator cmp2 = ComparisonsKt.compareBy((Function1[])new Function1[]{compareTo.cmp.1.INSTANCE, compareTo.cmp.2.INSTANCE});
        int res = cmp2.compare(this, other);
        return res;
    }

    @NotNull
    public String toString() {
        return this.getIdentifier();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final ITypeName getDeclaringType() {
        return this.declaringType;
    }

    public QualifiedName(@NotNull String name2, @NotNull ITypeName declaringType) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)declaringType, (String)"declaringType");
        this.name = name2;
        this.declaringType = declaringType;
    }

    static {
        Companion = new Companion(null);
        interner = Interners.newWeakInterner();
    }

    @JvmStatic
    @JsonCreator
    @NotNull
    public static final QualifiedName of(@NotNull String value) {
        return Companion.of(value);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0019\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u0005*\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001aJ\n\u0010\u0018\u001a\u00020\u0005*\u00020\tJ\n\u0010\u0018\u001a\u00020\u001b*\u00020\u001cJ\n\u0010\u001d\u001a\u00020\u001e*\u00020\u001cR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/recommenders/java/commons/names/QualifiedName$Companion;", "", "()V", "interner", "Lcom/google/common/collect/Interner;", "Lcom/jetbrains/recommenders/java/commons/names/QualifiedName;", "kotlin.jvm.PlatformType", "memberName", "Lcom/jetbrains/recommenders/java/commons/names/QualifiedMemberName;", "Lcom/jetbrains/recommenders/java/commons/names/IMemberName;", "getMemberName", "(Lcom/jetbrains/recommenders/java/commons/names/IMemberName;)Lcom/jetbrains/recommenders/java/commons/names/QualifiedMemberName;", "qualifiedName", "getQualifiedName", "simpleName", "Lcom/jetbrains/recommenders/java/commons/names/SimpleName;", "getSimpleName", "(Lcom/jetbrains/recommenders/java/commons/names/IMemberName;)Lcom/jetbrains/recommenders/java/commons/names/SimpleName;", "of", "value", "", "intern", "T", "(Lcom/jetbrains/recommenders/java/commons/names/QualifiedName;)Lcom/jetbrains/recommenders/java/commons/names/QualifiedName;", "toQualifiedName", "Lcom/jetbrains/recommenders/java/commons/names/QualifiedFieldName;", "Lcom/jetbrains/recommenders/java/commons/names/IFieldName;", "Lcom/jetbrains/recommenders/java/commons/names/QualifiedMethodName;", "Lcom/jetbrains/recommenders/java/commons/names/IMethodName;", "toSimpleMethodName", "Lcom/jetbrains/recommenders/java/commons/names/MethodSignature;", "recommenders-java-commons"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JsonCreator
        @NotNull
        public final QualifiedName of(@NotNull String value) {
            void type;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Object object2 = new String[]{"."};
            boolean bl = false;
            int n = 2;
            object2 = object = StringsKt.split$default((CharSequence)value, (String[])object2, (boolean)bl, (int)n, (int)2, null);
            bl = false;
            String string = (String)object2.get(0);
            object2 = object;
            bl = false;
            String name2 = (String)object2.get(1);
            object = name2;
            object2 = VmTypeName.Companion.of((String)type);
            return this.intern(new QualifiedName((String)object, (ITypeName)object2));
        }

        @NotNull
        public final QualifiedName toQualifiedName(@NotNull IMemberName $this$toQualifiedName) {
            QualifiedName qualifiedName;
            Intrinsics.checkParameterIsNotNull((Object)$this$toQualifiedName, (String)"$this$toQualifiedName");
            IMemberName iMemberName = $this$toQualifiedName;
            if (iMemberName instanceof IFieldName) {
                qualifiedName = this.toQualifiedName((IFieldName)$this$toQualifiedName);
            } else if (iMemberName instanceof IMethodName) {
                qualifiedName = this.toQualifiedName((IMethodName)$this$toQualifiedName);
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown type: " + $this$toQualifiedName);
            }
            return qualifiedName;
        }

        @NotNull
        public final QualifiedMethodName toQualifiedName(@NotNull IMethodName $this$toQualifiedName) {
            Intrinsics.checkParameterIsNotNull((Object)$this$toQualifiedName, (String)"$this$toQualifiedName");
            return (QualifiedMethodName)this.intern((QualifiedName)new QualifiedMethodName($this$toQualifiedName.getName(), $this$toQualifiedName.getDeclaringType()));
        }

        @NotNull
        public final QualifiedFieldName toQualifiedName(@NotNull IFieldName $this$toQualifiedName) {
            Intrinsics.checkParameterIsNotNull((Object)$this$toQualifiedName, (String)"$this$toQualifiedName");
            return (QualifiedFieldName)this.intern((QualifiedName)new QualifiedFieldName($this$toQualifiedName.getName(), $this$toQualifiedName.getDeclaringType()));
        }

        @NotNull
        public final <T extends QualifiedName> T intern(@NotNull T $this$intern) {
            Intrinsics.checkParameterIsNotNull($this$intern, (String)"$this$intern");
            Object object = interner.intern($this$intern);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)((QualifiedName)object);
        }

        @NotNull
        public final MethodSignature toSimpleMethodName(@NotNull IMethodName $this$toSimpleMethodName) {
            Intrinsics.checkParameterIsNotNull((Object)$this$toSimpleMethodName, (String)"$this$toSimpleMethodName");
            return new MethodSignature(this.getSimpleName($this$toSimpleMethodName), ArraysKt.asList((Object[])$this$toSimpleMethodName.getParameterTypes()));
        }

        @NotNull
        public final QualifiedMemberName getMemberName(@NotNull IMemberName $this$memberName) {
            Intrinsics.checkParameterIsNotNull((Object)$this$memberName, (String)"$this$memberName");
            return new QualifiedMemberName($this$memberName.getDeclaringType(), Companion.getSimpleName($this$memberName));
        }

        @NotNull
        public final SimpleName getSimpleName(@NotNull IMemberName $this$simpleName) {
            Intrinsics.checkParameterIsNotNull((Object)$this$simpleName, (String)"$this$simpleName");
            return SimpleName.Companion.of($this$simpleName.getName());
        }

        @NotNull
        public final QualifiedMemberName getQualifiedName(@NotNull IMemberName $this$qualifiedName) {
            Intrinsics.checkParameterIsNotNull((Object)$this$qualifiedName, (String)"$this$qualifiedName");
            return new QualifiedMemberName($this$qualifiedName.getDeclaringType(), Companion.getSimpleName($this$qualifiedName));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

