/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/streams/resolve/PartialReductionResolverBase;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "buildResult", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "mapping", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "", "resolve", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "intellij.java.debugger.streams"})
public abstract class PartialReductionResolverBase
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        boolean bl = false;
        Map reverseMapping = new LinkedHashMap();
        int i = 0;
        for (TraceElement valueAfter : valuesAfter) {
            boolean bl2 = false;
            List reverseList = new ArrayList();
            while (i + 1 < valuesBefore.size()) {
                TraceElement traceElement = valuesBefore.get(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)traceElement, (String)"valuesBefore[i + 1]");
                int n = traceElement.getTime();
                TraceElement traceElement2 = valueAfter;
                Intrinsics.checkNotNullExpressionValue((Object)traceElement2, (String)"valueAfter");
                if (n >= traceElement2.getTime()) break;
                Collection collection = reverseList;
                TraceElement traceElement3 = valuesBefore.get(i);
                boolean bl3 = false;
                collection.add(traceElement3);
                ++i;
            }
            TraceElement traceElement = valueAfter;
            Intrinsics.checkNotNullExpressionValue((Object)traceElement, (String)"valueAfter");
            reverseMapping.put(traceElement, reverseList);
        }
        List<TraceElement> list2 = valuesAfter;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"valuesAfter");
        Collection collection = list2;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            List<TraceElement> list3 = valuesBefore;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"valuesBefore");
            collection = list3;
            bl4 = false;
            if (!collection.isEmpty()) {
                Object v = reverseMapping.get(CollectionsKt.last(valuesAfter));
                Intrinsics.checkNotNull(v);
                collection = (List)v;
                Object object = CollectionsKt.last(valuesBefore);
                boolean bl5 = false;
                collection.add(object);
            }
        }
        return this.buildResult(reverseMapping);
    }

    @NotNull
    public abstract ValuesOrderResolver.Result buildResult(@NotNull Map<TraceElement, ? extends List<? extends TraceElement>> var1);
}

