/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.ui;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwSpecificationDetectionKt;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import com.intellij.swagger.ui.SwaggerUICefBrowser;
import com.intellij.swagger.ui.SwaggerUIEditorWithPreview;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/swagger/ui/SwaggerUIEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "writeState", "", "state", "targetElement", "Companion", "intellij.swagger"})
public final class SwaggerUIEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final String GENERAL_EDITOR = "general_editor";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!SwaggerFileHelper.INSTANCE.isSuitableFileType$intellij_swagger(file)) {
            return false;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"PsiManager.getInstance(p\u2026ile(file) ?: return false");
        PsiFile psiFile3 = psiFile2;
        SpecificationType specificationType = SwSpecificationDetectionKt.detectSpecificationType(file, psiFile3);
        return specificationType == SpecificationType.OPENAPI_3 || specificationType == SpecificationType.SWAGGER_2;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        FileEditorState fileEditorState;
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Element element = sourceElement.getChild(GENERAL_EDITOR);
        if (element != null) {
            Element element2 = element;
            boolean bl = false;
            boolean bl2 = false;
            Element it = element2;
            boolean bl3 = false;
            fileEditorState = PsiAwareTextEditorProvider.getInstance().readState(it, project, file);
        } else {
            fileEditorState = null;
        }
        FileEditorState generalEditorState = fileEditorState;
        return (FileEditorState)new TextEditorWithPreview.MyFileEditorState(null, generalEditorState, null);
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        if (!(state instanceof TextEditorWithPreview.MyFileEditorState)) {
            return;
        }
        Element child = new Element(GENERAL_EDITOR);
        FileEditorState textEditorState = ((TextEditorWithPreview.MyFileEditorState)state).getFirstState();
        if (textEditorState != null) {
            PsiAwareTextEditorProvider.getInstance().writeState(textEditorState, project, child);
            targetElement.addContent(child);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return "intellij.swagger.ui.editor.with.preview";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditor fileEditor = PsiAwareTextEditorProvider.getInstance().createEditor(project, file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"PsiAwareTextEditorProvid\u2026eateEditor(project, file)");
        FileEditor generalEditor = fileEditor;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file);
        if (!JBCefApp.isSupported() || !(generalEditor instanceof TextEditor) || psiFile2 == null) {
            return generalEditor;
        }
        return (FileEditor)new SwaggerUIEditorWithPreview((TextEditor)generalEditor, new SwaggerUICefBrowser(psiFile2, (TextEditor)generalEditor));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/swagger/ui/SwaggerUIEditorProvider$Companion;", "", "()V", "GENERAL_EDITOR", "", "intellij.swagger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

