/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.ui;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.model.SwObjectDefinitionUtilsKt;
import com.intellij.swagger.providers.SwJsonSchemaPatchUtils;
import com.intellij.swagger.ui.NameMapping;
import com.intellij.swagger.ui.NameSuggester;
import com.intellij.swagger.ui.ReferenceData;
import com.intellij.swagger.ui.SpecificationReferencesInlineHelper;
import com.intellij.swagger.ui.SpecificationReferencesInlineHelper$WhenMappings;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u001b\u001a\u00020\t2\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0006H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J4\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u0003H\u0002J5\u0010)\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u00072\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\t2\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0012H\u0002J\u001e\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u0001082\u0006\u00109\u001a\u00020\u0012H\u0002J0\u0010:\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010;\u001a\u00020.2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J(\u0010<\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0007H\u0002J \u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0018\u0010@\u001a\u00020\t2\u0006\u0010?\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u0005\u001aJ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b*#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u000b\u00a2\u0006\u0002\b\n0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/swagger/ui/SpecificationReferencesInlineHelper;", "", "inlineDepthLimit", "", "(I)V", "jsonFilesCache", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/JsonNode;", "Lorg/jetbrains/annotations/NotNull;", "", "jsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "yamlObjectMapper", "collectReferenceData", "Lcom/intellij/swagger/ui/ReferenceData;", "originalReferenceValue", "", "containingFile", "convertJsonToYaml", "specificationText", "convertJsonToYaml$intellij_swagger", "convertToJsonIfNeeded", "rawFileText", "convertToJsonIfNeeded$intellij_swagger", "convertYamlToJson", "createJsonNode", "children", "findAllReferences", "Lkotlin/sequences/Sequence;", "jsonSpecification", "findReferencedFile", "filePath", "inlineDefinitionsWithDepth", "jsonNode", "specificationType", "Lcom/intellij/swagger/SpecificationType;", "nameSuggester", "Lcom/intellij/swagger/ui/NameSuggester;", "depth", "inlineExternalDefinitions", "knownDefinitionNames", "", "inlineExternalDefinitions$intellij_swagger", "isLocalReference", "", "referenceBody", "readObjectDefinition", "file", "nameMapping", "Lcom/intellij/swagger/ui/NameMapping;", "resolveRelativeFilePath", "specification", "relativePath", "splitReference", "Lkotlin/Pair;", "value", "substituteExternalReferences", "substituteLocalReferences", "suggestInlinedObjectPath", "suitableMapperFor", "wrapDefinitionIfNeeded", "definitionsNode", "wrapDefinitions", "Companion", "intellij.swagger"})
public final class SpecificationReferencesInlineHelper {
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper yamlObjectMapper;
    private final Map<VirtualFile, JsonNode> jsonFilesCache;
    private final int inlineDepthLimit;
    private static final int MAXIMUM_INLINE_DEPTH = 10;
    private static final Regex REFERENCE_PATTERN;
    private static final int REFERENCE_BODY_GROUP_INDEX = 1;
    private static final Regex REFERENCE_STRUCTURE_PATTERN;
    private static final int EXTERNAL_FILE_GROUP_INDEX = 1;
    private static final int DEFINITION_PATH_GROUP_INDEX = 2;
    @NotNull
    public static final Companion Companion;

    private final ObjectMapper suitableMapperFor(VirtualFile file) {
        return file.getFileType() instanceof JsonFileType ? this.jsonObjectMapper : this.yamlObjectMapper;
    }

    @NotNull
    public final String inlineExternalDefinitions$intellij_swagger(@NotNull String specificationText, @NotNull SpecificationType specificationType, @NotNull VirtualFile containingFile, @NotNull Collection<String> knownDefinitionNames) {
        JsonNode jsonSpecificationRoot;
        Intrinsics.checkNotNullParameter((Object)specificationText, (String)"specificationText");
        Intrinsics.checkNotNullParameter((Object)((Object)specificationType), (String)"specificationType");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter(knownDefinitionNames, (String)"knownDefinitionNames");
        JsonNode jsonNode = jsonSpecificationRoot = this.suitableMapperFor(containingFile).readTree(specificationText);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"jsonSpecificationRoot");
        JsonNode jsonNode2 = SpecificationReferencesInlineHelper.inlineDefinitionsWithDepth$default(this, jsonNode, containingFile, specificationType, new NameSuggester(knownDefinitionNames), 0, 16, null);
        if (jsonNode2 == null) {
            return specificationText;
        }
        JsonNode specificationTree = jsonNode2;
        String string = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)specificationTree);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObjectMapper.writerW\u2026String(specificationTree)");
        return string;
    }

    public static /* synthetic */ String inlineExternalDefinitions$intellij_swagger$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, String string, SpecificationType specificationType, VirtualFile virtualFile2, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = SetsKt.emptySet();
        }
        return specificationReferencesInlineHelper.inlineExternalDefinitions$intellij_swagger(string, specificationType, virtualFile2, collection);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode inlineDefinitionsWithDepth(JsonNode jsonNode, VirtualFile containingFile, SpecificationType specificationType, NameSuggester nameSuggester, int depth) {
        JsonNode jsonNode2;
        Object v1;
        void $this$reduceOrNull$iv;
        String effectiveJsonAsString;
        ProgressManager.checkCanceled();
        if (depth >= this.inlineDepthLimit) {
            return jsonNode;
        }
        String string = effectiveJsonAsString = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"effectiveJsonAsString");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull(this.findAllReferences(string), (Function1)((Function1)new Function1<String, ReferenceData>(this, containingFile){
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;
            final /* synthetic */ VirtualFile $containingFile;

            @Nullable
            public final ReferenceData invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SpecificationReferencesInlineHelper.access$collectReferenceData(this.this$0, it, this.$containingFile);
            }
            {
                this.this$0 = specificationReferencesInlineHelper;
                this.$containingFile = virtualFile2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ReferenceData, Boolean>(depth, containingFile){
            final /* synthetic */ int $depth;
            final /* synthetic */ VirtualFile $containingFile;

            public final boolean invoke(@NotNull ReferenceData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$depth > 0 || Intrinsics.areEqual((Object)it.getTargetFile(), (Object)this.$containingFile) ^ true;
            }
            {
                this.$depth = n;
                this.$containingFile = virtualFile2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ReferenceData, JsonNode>(this, nameSuggester, specificationType, depth){
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;
            final /* synthetic */ NameSuggester $nameSuggester;
            final /* synthetic */ SpecificationType $specificationType;
            final /* synthetic */ int $depth;

            @Nullable
            public final JsonNode invoke(@NotNull ReferenceData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NameMapping nameMapping = this.$nameSuggester.createNameMapping$intellij_swagger(it);
                JsonNode jsonNode = SpecificationReferencesInlineHelper.access$readObjectDefinition(this.this$0, it.getTargetFile(), nameMapping);
                if (jsonNode == null) {
                    return null;
                }
                JsonNode definition = jsonNode;
                return SpecificationReferencesInlineHelper.access$inlineDefinitionsWithDepth(this.this$0, definition, it.getTargetFile(), this.$specificationType, this.$nameSuggester, this.$depth + 1);
            }
            {
                this.this$0 = specificationReferencesInlineHelper;
                this.$nameSuggester = nameSuggester;
                this.$specificationType = specificationType;
                this.$depth = n;
                super(1);
            }
        }));
        SwJsonSchemaPatchUtils swJsonSchemaPatchUtils = SwJsonSchemaPatchUtils.INSTANCE;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p2;
                JsonNode jsonNode3 = (JsonNode)iterator$iv.next();
                JsonNode p1 = (JsonNode)accumulator$iv;
                boolean bl = false;
                accumulator$iv = swJsonSchemaPatchUtils.mergeTrees(p1, (JsonNode)p2);
            }
            v1 = accumulator$iv;
        }
        JsonNode allExternalDefinitions2 = v1;
        JsonNode targetJsonRootNode = this.jsonObjectMapper.readTree(this.substituteExternalReferences(effectiveJsonAsString, specificationType, depth > 0, nameSuggester, containingFile));
        if (allExternalDefinitions2 == null) {
            jsonNode2 = targetJsonRootNode;
        } else {
            JsonNode jsonNode4 = targetJsonRootNode;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode4, (String)"targetJsonRootNode");
            jsonNode2 = SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(jsonNode4, this.wrapDefinitionIfNeeded(allExternalDefinitions2, specificationType, depth));
        }
        return jsonNode2;
    }

    static /* synthetic */ JsonNode inlineDefinitionsWithDepth$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, JsonNode jsonNode, VirtualFile virtualFile2, SpecificationType specificationType, NameSuggester nameSuggester, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return specificationReferencesInlineHelper.inlineDefinitionsWithDepth(jsonNode, virtualFile2, specificationType, nameSuggester, n);
    }

    @Nullable
    public final String convertToJsonIfNeeded$intellij_swagger(@NotNull String rawFileText, @NotNull VirtualFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)rawFileText, (String)"rawFileText");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        return containingFile.getFileType() instanceof JsonFileType ? rawFileText : this.convertYamlToJson(rawFileText);
    }

    private final String convertYamlToJson(String specificationText) {
        String string;
        try {
            JsonNode yamlTree = this.yamlObjectMapper.readTree(specificationText);
            string = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)yamlTree);
        }
        catch (JsonProcessingException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to convert yaml specification to json format", (Throwable)exception);
            string = null;
        }
        return string;
    }

    @Nullable
    public final String convertJsonToYaml$intellij_swagger(@NotNull String specificationText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)specificationText, (String)"specificationText");
        try {
            JsonNode jsonTree = this.jsonObjectMapper.readTree(specificationText);
            string = this.yamlObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonTree);
        }
        catch (JsonProcessingException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to convert json specification to yaml format", (Throwable)exception);
            string = null;
        }
        return string;
    }

    private final Sequence<String> findAllReferences(String jsonSpecification) {
        return SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)REFERENCE_PATTERN, (CharSequence)jsonSpecification, (int)0, (int)2, null), (Function1)findAllReferences.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final ReferenceData collectReferenceData(String originalReferenceValue, VirtualFile containingFile) {
        void filePath;
        Pair<String, String> pair = this.splitReference(originalReferenceValue);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String string = (String)pair2.component1();
        String objectPath = (String)pair2.component2();
        VirtualFile virtualFile2 = this.findReferencedFile((String)filePath, containingFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile targetFile = virtualFile2;
        return new ReferenceData(targetFile, objectPath);
    }

    private final Pair<String, String> splitReference(String value) {
        MatchResult matchResult = REFERENCE_STRUCTURE_PATTERN.matchEntire((CharSequence)value);
        if (matchResult == null) {
            return TuplesKt.to((Object)value, (Object)"");
        }
        MatchResult matchEntire = matchResult;
        return matchEntire.getGroups().size() < 2 ? null : TuplesKt.to(matchEntire.getGroupValues().get(1), matchEntire.getGroupValues().get(2));
    }

    private final VirtualFile findReferencedFile(String filePath, VirtualFile containingFile) {
        VirtualFile targetFile;
        CharSequence charSequence = filePath;
        boolean bl = false;
        VirtualFile virtualFile2 = targetFile = charSequence.length() > 0 ? this.resolveRelativeFilePath(containingFile, filePath) : containingFile;
        if (targetFile == null || targetFile.isDirectory()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to resolve external reference because specified file is not found: " + filePath);
            return null;
        }
        return targetFile;
    }

    private final VirtualFile resolveRelativeFilePath(VirtualFile specification, String relativePath) {
        VirtualFile virtualFile2 = specification.getParent();
        return virtualFile2 != null ? virtualFile2.findFileByRelativePath(relativePath) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode readObjectDefinition(VirtualFile file, NameMapping nameMapping) {
        JsonNode jsonNode = this.jsonFilesCache.get(file);
        if (jsonNode == null) {
            return null;
        }
        JsonNode node = jsonNode;
        CharSequence charSequence = nameMapping.getOriginalPath();
        boolean bl = false;
        if (charSequence.length() == 0) {
            return this.createJsonNode(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)nameMapping.getUniqueName(), (Object)node)}));
        }
        Iterable $this$fold$iv = nameMapping.getOriginalPathSegments();
        boolean $i$f$fold = false;
        JsonNode accumulator$iv = node;
        for (Object element$iv : $this$fold$iv) {
            void pathSegment;
            String string = (String)element$iv;
            JsonNode currentNode = accumulator$iv;
            boolean bl2 = false;
            if (currentNode.get(SwObjectDefinitionUtilsKt.unescapeSpecialSymbols((String)pathSegment)) != null) continue;
            SpecificationReferencesInlineHelper specificationReferencesInlineHelper = this;
            boolean bl3 = false;
            boolean bl4 = false;
            SpecificationReferencesInlineHelper $this$run = specificationReferencesInlineHelper;
            boolean bl5 = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to resolve node " + nameMapping.getOriginalName() + " inside file " + file.getName());
            return null;
        }
        JsonNode foundDefinition = accumulator$iv;
        return this.createJsonNode(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)SwObjectDefinitionUtilsKt.unescapeSpecialSymbols(nameMapping.getUniqueName()), (Object)foundDefinition)}));
    }

    private final String substituteExternalReferences(String jsonSpecification, SpecificationType specificationType, boolean substituteLocalReferences, NameSuggester nameSuggester, VirtualFile containingFile) {
        CharSequence charSequence = jsonSpecification;
        Regex regex = REFERENCE_PATTERN;
        Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(this, substituteLocalReferences, specificationType, nameSuggester, containingFile){
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;
            final /* synthetic */ boolean $substituteLocalReferences;
            final /* synthetic */ SpecificationType $specificationType;
            final /* synthetic */ NameSuggester $nameSuggester;
            final /* synthetic */ VirtualFile $containingFile;

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getGroups().size() < 1) {
                    return it.getValue();
                }
                String referenceBody = (String)it.getGroupValues().get(1);
                CharSequence charSequence = referenceBody;
                boolean bl = false;
                if (charSequence.length() == 0 || !this.$substituteLocalReferences && SpecificationReferencesInlineHelper.access$isLocalReference(this.this$0, referenceBody)) {
                    return it.getValue();
                }
                return SpecificationReferencesInlineHelper.access$suggestInlinedObjectPath(this.this$0, referenceBody, this.$specificationType, this.$nameSuggester, this.$containingFile);
            }
            {
                this.this$0 = specificationReferencesInlineHelper;
                this.$substituteLocalReferences = bl;
                this.$specificationType = specificationType;
                this.$nameSuggester = nameSuggester;
                this.$containingFile = virtualFile2;
                super(1);
            }
        };
        boolean bl = false;
        return regex.replace(charSequence, function1);
    }

    private final boolean isLocalReference(String referenceBody) {
        return StringsKt.startsWith$default((String)referenceBody, (String)"#/", (boolean)false, (int)2, null);
    }

    private final JsonNode wrapDefinitionIfNeeded(JsonNode definitionsNode, SpecificationType specificationType, int depth) {
        return depth == 0 ? this.wrapDefinitions(definitionsNode, specificationType) : definitionsNode;
    }

    private final JsonNode wrapDefinitions(JsonNode definitionsNode, SpecificationType specificationType) {
        JsonNode jsonNode;
        switch (SpecificationReferencesInlineHelper$WhenMappings.$EnumSwitchMapping$0[specificationType.ordinal()]) {
            case 1: {
                jsonNode = this.createJsonNode(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"definitions", (Object)definitionsNode)}));
                break;
            }
            case 2: {
                jsonNode = this.createJsonNode(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"components", (Object)this.createJsonNode(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"schemas", (Object)definitionsNode)})))}));
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("There is no object definitions storage template for specification type: " + (Object)((Object)specificationType));
            }
        }
        return jsonNode;
    }

    private final String suggestInlinedObjectPath(String referenceBody, SpecificationType specificationType, NameSuggester nameSuggester, VirtualFile containingFile) {
        NameMapping nameMapping = nameSuggester.getNameForReference$intellij_swagger(this.collectReferenceData(referenceBody, containingFile));
        String uniqueName = nameMapping != null ? nameMapping.getUniqueName() : null;
        CharSequence charSequence = uniqueName;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? "\"$ref\": \"" + referenceBody + '\"' : (specificationType == SpecificationType.SWAGGER_2 ? "\"$ref\": \"#/definitions/" + uniqueName + '\"' : (specificationType == SpecificationType.OPENAPI_3 ? "\"$ref\": \"#/components/schemas/" + uniqueName + '\"' : "\"$ref\": \"" + referenceBody + '\"'));
    }

    private final JsonNode createJsonNode(Map<String, JsonNode> children) {
        return (JsonNode)new ObjectNode(this.jsonObjectMapper.getNodeFactory(), children);
    }

    static /* synthetic */ JsonNode createJsonNode$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl = false;
            map2 = new LinkedHashMap();
        }
        return specificationReferencesInlineHelper.createJsonNode(map2);
    }

    public SpecificationReferencesInlineHelper(int inlineDepthLimit) {
        this.inlineDepthLimit = inlineDepthLimit;
        this.jsonObjectMapper = new ObjectMapper(new JsonFactory());
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Map map2 = FactoryMap.create((Function)new Function(this){
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;

            public final JsonNode fun(VirtualFile it) {
                JsonNode jsonNode;
                try {
                    VirtualFile virtualFile2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                    jsonNode = SpecificationReferencesInlineHelper.access$suitableMapperFor(this.this$0, virtualFile2).readTree(it.getInputStream());
                }
                catch (IOException exception) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to parse external file with object definitions: ");
                    VirtualFile virtualFile3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
                    logger.warn(stringBuilder.append(virtualFile3.getName()).toString(), (Throwable)exception);
                    jsonNode = null;
                }
                return jsonNode;
            }
            {
                this.this$0 = specificationReferencesInlineHelper;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"FactoryMap.create<Virtua\u2026ion)\n      null\n    }\n  }");
        this.jsonFilesCache = map2;
    }

    public /* synthetic */ SpecificationReferencesInlineHelper(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public SpecificationReferencesInlineHelper() {
        this(0, 1, null);
    }

    static {
        Companion = new Companion(null);
        String string = "\"\\$ref\"\\s*:\\s*\"([^\"]*)\"";
        boolean bl = false;
        REFERENCE_PATTERN = new Regex(string);
        string = "(.*)#/(.*)";
        bl = false;
        REFERENCE_STRUCTURE_PATTERN = new Regex(string);
    }

    public static final /* synthetic */ ReferenceData access$collectReferenceData(SpecificationReferencesInlineHelper $this, String originalReferenceValue, VirtualFile containingFile) {
        return $this.collectReferenceData(originalReferenceValue, containingFile);
    }

    public static final /* synthetic */ JsonNode access$readObjectDefinition(SpecificationReferencesInlineHelper $this, VirtualFile file, NameMapping nameMapping) {
        return $this.readObjectDefinition(file, nameMapping);
    }

    public static final /* synthetic */ JsonNode access$inlineDefinitionsWithDepth(SpecificationReferencesInlineHelper $this, JsonNode jsonNode, VirtualFile containingFile, SpecificationType specificationType, NameSuggester nameSuggester, int depth) {
        return $this.inlineDefinitionsWithDepth(jsonNode, containingFile, specificationType, nameSuggester, depth);
    }

    public static final /* synthetic */ boolean access$isLocalReference(SpecificationReferencesInlineHelper $this, String referenceBody) {
        return $this.isLocalReference(referenceBody);
    }

    public static final /* synthetic */ String access$suggestInlinedObjectPath(SpecificationReferencesInlineHelper $this, String referenceBody, SpecificationType specificationType, NameSuggester nameSuggester, VirtualFile containingFile) {
        return $this.suggestInlinedObjectPath(referenceBody, specificationType, nameSuggester, containingFile);
    }

    public static final /* synthetic */ ObjectMapper access$suitableMapperFor(SpecificationReferencesInlineHelper $this, VirtualFile file) {
        return $this.suitableMapperFor(file);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/ui/SpecificationReferencesInlineHelper$Companion;", "", "()V", "DEFINITION_PATH_GROUP_INDEX", "", "EXTERNAL_FILE_GROUP_INDEX", "MAXIMUM_INLINE_DEPTH", "REFERENCE_BODY_GROUP_INDEX", "REFERENCE_PATTERN", "Lkotlin/text/Regex;", "REFERENCE_STRUCTURE_PATTERN", "intellij.swagger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

